#!/bin/sh
#ifname=$1
#vip=$2
ha_profile=$3

GLOBAL_LOCK="/tmp/ucarp/ha-up_HS_lock"

enter_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
while true; do
	#spin if any ha-down lock is found
	lock=`ls /tmp/ucarp/ha_down_lock_HS_*` 2>/dev/null >/dev/null
	if [ "$?" = "0" ] ;then
		logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): Found ha_down_lock_HS:$lock, wait..."
		BREAK_LOCK_INTV=30
		nowtime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		DIFF=$(($nowtime - $enter_time))
		if [ $DIFF -le $BREAK_LOCK_INTV ] ;then
			sleep 5
			continue
		else
			logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): has been over $BREAK_LOCK_INTV secs, break all ha_down_lock_HS:$lock"
			for k in $lock ;do
				rm -f $k
			done
		fi
	else
		break
	fi
done
######################## Private Works ########################
#create my lock
[ -f /tmp/ucarp/ha_up_lock_HS_$ha_profile ] && return
touch /tmp/ucarp/ha_up_lock_HS_$ha_profile
#logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): create my script lock"

######################## Global Works ########################
lock $GLOBAL_LOCK
if [ -f "/var/run/ucarp/HSmaster.pid" ] ;then
	logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): master-polling_HS is already running, need not create another one"
else
	touch "/var/run/ucarp/HSmaster.pid"
	logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): I am the superior, now I become Master"
	
	##### update state to master for ifup script
	json set ucarp state=master
	##### stop backup-polling_HS
	enter_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
	while true; do
		#spin if any ha_bulk_sync_lock is found
		if [ -f /tmp/ucarp/ha_bulk_sync_lock ] ;then
			logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): Found ha_bulk_sync_lock, wait..."
			BREAK_LOCK_INTV=30
			nowtime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
			DIFF=$(($nowtime - $enter_time))
			if [ $DIFF -le $BREAK_LOCK_INTV ] ;then
				sleep 1
				continue
			else
				logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): has been over $BREAK_LOCK_INTV secs, break ha_bulk_sync_lock"
				rm -rf /tmp/ucarp/ha_bulk_sync_lock
			fi
		else
			break
		fi
	done
	killall backup-polling_HS.sh
	rm -f /var/run/ucarp/backup-polling_HS.pid
	logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): stop backup-polling_HS"
	##### start master-polling_HS
	/etc/ucarp/master-polling_HS.sh &
	logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): start master-polling_HS"
	##### Deactive manual preemption mode
	#If preemption is manual, deactive preemption status when it is going to be master
	#get HA parameters
	preempt_mode=`uci get ucarp_mode.general.preempt_mode`
	if [ "$preempt_mode" = "manual" ] ;then
		logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): one-time promotion is used, reset global preemption flag [manual preemption status]"
		uci set ucarp_mode.general.manual_status=disable
		uci commit ucarp_mode
	fi
fi
lock -u $GLOBAL_LOCK

#release script lock
rm -f /tmp/ucarp/ha_up_lock_HS_$ha_profile
#logger -p 152.5 "[High Availability] ha-up_HS($ha_profile)($$): script done, remove my script lock"
