#!/bin/sh
ifname=$1
vip=$2
ha_profile=$3

GLOBAL_LOCK="/tmp/ucarp/ha-down_HS_lock"

#echo "ha-down($ha_profile)($$) START: profile=$ha_profile, ifname=$ifname, vip=$vip" >/dev/console

update_vip_arp_table()
{
	#Remove VIP from LAN
	config_get vip $1 vip
	config_get lan $1 lan
	ifname=lan-$lan
	#remove possible incompleted arp entries
	arp -d $vip -i $ifname >/dev/bull 2>/dev/null
	arping -f -c 2 -w 2 -i $ifname $vip >/dev/bull 2>/dev/null
	#remove VIP from Ipset:ip_lanX for user management dst bypassing
	ipset -D ip_$lan $vip
}
disable_extra_subnet()
{
	second_subnet=`uci get -d, network.$ifc.static_2nd_subnet`
	echo "$second_subnet" | grep , >/dev/null
	do_loop=$?
	i=0
	[ -n "$second_subnet" ] && {
		while true; do
			i=$(($i+1))
			set -- `echo $second_subnet | cut -d, -f $i`
			if [ "$3" = "NAT" ]; then
				ipset -D lan_nat_subnet $1/$2
				ipset -D lan_${config}_subnet $1/$2
			elif [ "$3" = "ROUTING" ]; then
				ipset -D lan_routing_subnet $1/$2
			else [ -z "$3" ]
				break
			fi
			ip addr del $1/$2 dev lan-$ifc brd +
			json delete network.$ifc.2nd_subnet
			logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): Remove extra subnet:$1/$2 from $ifc"
			[ "$do_loop" -eq 0 ] || break
		done
	}
}
set_status_to_backup(){
	uci set ucarp_hs.$1.ha_profile_status=Backup
}
remove_all_vip() {
	config_get ha_vip $1 vip
	config_get iface $1 lan
	mask=`uci get network.$iface.static_netmask`
	ifname=lan-$iface
	/usr/sbin/ip addr del $ha_vip/$mask dev $ifname 2> /dev/null >/dev/null
}

enter_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
while true; do
	lock=`ls /tmp/ucarp/ha_up_lock_HS_*` 2>/dev/null >/dev/null
	if [ "$?" = "0" ] ;then
		logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): Found ha_up_lock_HS:$lock, wait..."
		BREAK_LOCK_INTV=30
		nowtime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		DIFF=$(($nowtime - $enter_time))
		if [ $DIFF -le $BREAK_LOCK_INTV ] ;then
			sleep 5
			continue
		else
			logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): over $BREAK_LOCK_INTV secs, Break ha_up_lock_HS:$lock"
			for k in $lock ;do
				rm -f $k
			done
		fi
	else
		break
	fi
done

######################## Private Works ########################
#create my lock
[ -f /tmp/ucarp/ha_down_lock_HS_$ha_profile ] && return
touch /tmp/ucarp/ha_down_lock_HS_$ha_profile
#logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): create my script lock"

. /etc/functions.sh
include /lib/network

######################## Global Works ########################
lock $GLOBAL_LOCK
if [ -f "/var/run/ucarp/backup-polling_HS.pid" ] ;then
	logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): backup-polling_HS is already running, abort"
else
	touch /var/run/ucarp/backup-polling_HS.pid
	logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): Now I become Backup"
	
	##### update state to backup for ifup script
	json set ucarp state=backup

	##### stop master-polling_HS
	killall master-polling_HS.sh
	rm -f /var/run/ucarp/HSmaster.pid
	rm -f /tmp/HA_rebind_*
	logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): stop master-polling_HS process"
	
	######## Handle HA LAN related work
	#Remove VIP on all HA LAN
	config_load ucarp_hs
	config_foreach remove_all_vip

	##### G38957: Disable All HA LANs' DHCP Service
	my_ha_lans=`json get ucarp.general.ha_lan`
	for i in $my_ha_lans ;do
		json set ucarp.$i dhcp_state=down
		logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): stop $i dhcp service"
	done
	/etc/init.d/dhcpd apply
	
	######## Handle WAN related work
	#ifdown All WAN interfaces or remove extra subnet on All LANs
	master_ethaddr=`head -n 2 /etc/ucarp/revision | tail -n 1` 2>/dev/null
	config_clear
	config_load network
	scan_interfaces
	#echo "ha-down($ha_profile)($$): interface=$interfaces" >/dev/console
	for ifc in $interfaces; do
		config_get status $ifc status
		config_get physical $ifc physical
		if [ "$status" = "enable" ] ;then
			##### Multi-LANs case:
			if [ "$physical" = "eth0" ] ;then
				config_get macaddr $ifc macaddr
				[ "$macaddr" = "default" ] && macaddr=$master_ethaddr
				config_get static_ipaddr $ifc static_ipaddr
				[ -n "$macaddr" -a -n "$static_ipaddr" ] && {
					#Send garp of LAN's primary IP
					arping -b -c 1 -i lan-$ifc -S $macaddr $static_ipaddr > /dev/null
				}
				#Unload extra subnet on LAN which copied from master to prevent subnet IP conflict
				disable_extra_subnet $ifc
			else
				[ "$ifc" = "wan4" ] && {
					[ $(uci get network.$ifc.proto) = "dmz" ] && json set network.wan4 connection=down
				}
				logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): shutdown $ifc"
				ifdown $ifc &
			fi
		fi
	done
	
	config_clear
	config_load ucarp_hs
	config_foreach set_status_to_backup
	config_foreach update_vip_arp_table
	
	##### G49223: stop LAN pppoe server
	/etc/init.d/pppoe_server stop
	##### Send signal of "DevChange" to ubf_polling_d
	web_portal_status=`uci get general_conf.base.status`
	[ "$web_portal_status" == "enable" ] && kill -SIGUSR1 `pidof ubf_polling_d` >/dev/null 2>&1
	
	##### start backup-polling_HS
	/etc/ucarp/backup-polling_HS.sh &
	logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): start backup-polling_HS"
	
	#remove non-necessary lock if existed (this lock only used by master-polling)
	[ -f "/tmp/HA_ifdown_lock" ] && {
		rm -f /tmp/HA_ifdown_lock 2>/dev/null
		logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): remove master's HA_ifdown_lock"
	}
fi
lock -u $GLOBAL_LOCK

#release script lock
rm -f /tmp/ucarp/ha_down_lock_HS_$ha_profile
#logger -p 152.5 "[High Availability] ha-down_HS($ha_profile)($$): script done, remove my script lock"
