#ifndef SSLTUNNEL_H
#define SSLTUNNEL_H

#define NOSSL 1

#define SIZE 32768 //16384 //8192
#define PACKET_MAX 16384 //8192

#define MAXCHILD 20
#define DEFAULT_PORT 4443
#define DEFAULT_IPADDR "0.0.0.0"
#define DEFAULT_PIDFILE  "/var/run/ssltunnel.pid"
#define USERFILE "/etc/ppp/options.ssltunnel"
#define CERTFILE "/etc/lighttpd/host.pem"
#define KEYFILE  "/etc/lighttpd/host.pem"

#define DEFAULT_NETWORK_TIMEOUT	20

#define MAXARGS 255
typedef struct client_data_t
{
	char *exec;
	char *args[MAXARGS];
	int  pty;
	uid_t uid;
	gid_t gid;
} client_data_t;

typedef int bool;

typedef struct key_value_t
{
	char *key;
	char *value;
} key_value_t;

#define FALSE 0
#define TRUE  1
#define false 0
#define true  1

typedef struct tunnel_config_t
{
	int  maxclients;              /* Max Clients */
	char *userfile;		/* UserFiles */
	char *listenaddr;             /* Limit address */
	int  port;                    /* Port */
  int  network_timeout;         /* Network Timeout */
  char *pidfile;		/* Pid File */
} tunnel_config_t;

//DrayTek SSL Tunnel: SSTP
struct SSTP_HEADER {
	unsigned char command;
	unsigned char version;
	unsigned short int ulLen;
};

#define SSTP_HEADER_LEN sizeof(struct SSTP_HEADER)
#define SSTP_REQ_LEN 16

#define SESSION_ID_LEN 		9

#define SSTP_CMD_DATA		0
#define SSTP_CMD_CLOSE		1
#define SSTP_CMD_REQUEST 	2
#define SSTP_CMD_REPLY 		3

#define SSTP_TIME_OUT  60	 // seconds

#define PPPINITFCS16    0xffff  /* Initial FCS value */
#define PPPGOODFCS16    0xf0b8  /* Good final FCS value */

u_int16_t pppfcs16(u_int16_t fcs, void *cp, int len);

#endif //SSLTUNNEL_H
