#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <openssl/ssl.h>
#include <openssl/x509.h>
#include <openssl/err.h>
#include <errno.h>
#include <sys/types.h> 
#include <sys/socket.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <syslog.h>
#include <netdb.h>
#include <fcntl.h>
#include <string.h>
#include <termios.h>
#include <zlib.h>
#include <utmp.h>
#include <time.h>

#include <sys/types.h>
#include <sys/socket.h>
#if defined(__FreeBSD__)
#include <libutil.h>
#elif defined(__NetBSD__) || defined(__OpenBSD__)
#include <util.h>
#elif defined(__APPLE__)
#include <util.h>
#else
#include <pty.h>
#endif
#ifdef USER_PPP
#include <fcntl.h>
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#include "ssltunnel.h"


#include <sys/types.h>
#include <assert.h>
//#include "ppp_fcs.h"
#define ASSERT(x) assert(x)

/*
 * u16 represents an unsigned 16-bit number.  Adjust the typedef for
 * your hardware.
 */
typedef u_int16_t u16;

int listen_sock = -1;
int nbchild = 0;
pid_t *child_ids;
int stopped = 0;
pid_t pppid = -1;

unsigned long inbytes=0;
unsigned long outbytes=0;
time_t lastrecv_tm=0;
time_t lastsend_tm=0;
time_t current_tm=0;

tunnel_config_t *cfgtunnel;
char buffer[SIZE];
char ttydev[PATH_MAX];

int berr_exit(char *string);
key_value_t *file_parse(char *line, bool *err);
client_data_t *getclientdata(char *remote_ip, char *cookie);
void sig_chld_master(int status);
void sig_chld_slave(int status);
void sig_int_slave(int status);
void sig_alrm_slave(int status);
void sig_int_master(int status);
void kill_then_wait_childs();
int init_socket(unsigned long addr, unsigned short port);
void sockerror(char *string);
int tcp_accept_fork();
int do_server_loop_nossl(int csk);

client_data_t *getclientdata (char *remote_ip, char *cookie) {

 FILE *userfile;
 char line[256];
 bool err=false;
 client_data_t *userdata=NULL;
 char *ptrblank;
 int index;
 syslog(LOG_INFO, "getclientdata()");
 userfile = fopen (cfgtunnel->userfile, "r");
 if (userfile == NULL) {
   syslog(LOG_ERR, "Unable to open user file: %s", strerror(errno));
   return NULL;
 } 

 while (!err && (fgets( line, 255, userfile) != NULL)) {
 	
    key_value_t *key_value ;

    key_value = file_parse ( line , &err) ;
    if (err == true)
    {
       fclose ( userfile ) ;
       syslog(LOG_ERR, "Unable to parse user file");
       return 0 ;
    }
    else if (key_value == NULL) {
        /* white or commenet line : skip it */
        continue;
    }

    if (!strcasecmp ( key_value->key, "user" )) {
    	if (userdata != NULL) break;
    	syslog(LOG_INFO, "Find user");
       //if ( !strcasecmp(key_value->value, subject) ) {
         /* Good user */
         userdata = malloc (sizeof(client_data_t));
         //userdata->subject = strdup ( subject );
         userdata->exec = NULL;
         //userdata->fingerprint = NULL;
         //userdata->issuer = NULL;
         userdata->args[0] = NULL;
         userdata->pty = 0;
        // userdata->uid = 0;
         //userdata->gid = 0;
       //}
       //else if (userdata != NULL) break;
    }
    
    if (!strcasecmp (  key_value->key, "command") && userdata != NULL) {
		userdata->exec = strdup(key_value->value);    
		userdata->args[0] = strdup(key_value->value);
		userdata->args[1] = NULL;
       //syslog(LOG_INFO, "%s, userdata->exec=%s, userdata->args[0]=%s", key_value->key, userdata->exec, userdata->args[0]);
    }

    if (!strcasecmp (  key_value->key, "pty") && userdata != NULL) {
       userdata->pty = atoi(key_value->value);
       //userdata->args[1] = strdup(ttydev);
       //userdata->args[2] = strdup("38400");
       //userdata->args[3] = strdup("nolzs");
       //userdata->args[3] = NULL;
       
    }

    if (!strcasecmp (  key_value->key, "args") && userdata != NULL) {
       index = 0;
       while (index < MAXARGS -1 && userdata->args[index] != NULL)
         index++;
       for (ptrblank = strtok(key_value->value," \t");
            ptrblank;
            ptrblank = strtok(NULL," \t")) {
         userdata->args[index++] = strdup(ptrblank);
         syslog(LOG_INFO, "userdata->args[%d]=%s", index-1, userdata->args[index-1]);
         
				if(remote_ip && !strcmp(userdata->args[index-1], "nomppe")) {
         	userdata->args[index++] = strdup("remote-host");
         	syslog(LOG_INFO, "userdata->args[%d]=%s", index-1, userdata->args[index-1]);
         	userdata->args[index++] = strdup(remote_ip);
         	syslog(LOG_INFO, "userdata->args[%d]=%s", index-1, userdata->args[index-1]);
         	
         	if(cookie && cookie[0]) { // not empty cookie
         		userdata->args[index++] = strdup("remote-cookie");
         		syslog(LOG_INFO, "userdata->args[%d]=%s", index-1, userdata->args[index-1]);
         		userdata->args[index++] = strdup(cookie);
         		syslog(LOG_INFO, "userdata->args[%d]=%s", index-1, userdata->args[index-1]);
         	}
				}
				
         userdata->args[index] = NULL;
       }
    }
 }

 fclose ( userfile ) ;
 return userdata;
}

key_value_t *file_parse ( char *line , bool *err)
{
   char *tmp , *key ;
   key_value_t *key_value ;

   *err = false;
   
   key_value = ( key_value_t * ) malloc ( sizeof ( key_value_t ) ) ;
   if ( key_value == NULL )
   {
      *err = true;
      return NULL ;
   }

   /* strip comment or final \n */

   for ( tmp = line ; *tmp != '\0' ; tmp ++ )
   {
      if ( *tmp == '#' || *tmp == '\n' )
      {
         *tmp = '\0' ;
         break ;
      }
   }

   /* strip trailing whitespaces */

   while ( tmp != line )
   {
      tmp -- ;
      if ( *tmp == ' ' || *tmp == '\t' )
      {
         *tmp = '\0' ;
      }
      else
      {
         break ;
      }
   }

   /* find the key */

   tmp = line ;
   while ( *tmp == ' ' || *tmp == '\t' )
   {
      tmp ++ ;
   }
   if ( *tmp == '\0' )   /* premature end of line */
   {
      return NULL ;
   }

   /* strip the key */

   key = tmp ;
   while ( *tmp != ' ' && *tmp != '\t' && *tmp != '\0' )
   {
      tmp ++ ;
   }
   if ( *tmp == '\0' )   /* no value */
   {
      key_value->key = strdup ( key ) ;
      if ( key_value->key == NULL )
      {
         *err = true;
         return NULL ;
      }
      key_value->value = NULL ;
      return key_value ;
   }
   *tmp = '\0' ;

   /* copy the key */

   key_value->key = strdup ( key ) ;
   if ( key_value->key == NULL )
   {
      *err = true;
      return NULL ;
   }

   /* strip the blanks */

   tmp ++ ;
   while ( *tmp == ' ' || *tmp == '\t' )
   {
      tmp ++ ;
   }
   if ( *tmp == '\0' )   /* premature end of line */
   {
      key_value->value = NULL ;
      return key_value ;
   }

   /* copy the value */

   key_value->value = strdup ( tmp ) ;
   if ( key_value->value == NULL )
   {
      *err = true;
      return NULL ;
   }

   return key_value ;
}

void sig_chld_master(int status)
{
	pid_t child_pid;
	int index;

	while ((child_pid = waitpid(-1, NULL, WNOHANG)) > 0) {
		nbchild--;
		for (index = 0; index < cfgtunnel->maxclients; index++) {
			if (child_pid == *(child_ids + index)) {
				*(child_ids + index) = -1;
				break;
			}
		}
	}
	signal(SIGCHLD, &sig_chld_master);
}

void sig_chld_slave(int status)
{
	pid_t child_pid;

	while ((child_pid = waitpid(-1, NULL, WNOHANG)) > 0) {
		nbchild --;
		if (child_pid == pppid) { 
			pppid = -1;
			stopped = 1;
		}
	}
	signal(SIGCHLD, &sig_chld_slave);
}

void sig_int_slave(int status)
{
	/* Kill ppp */
	if (pppid != -1)
		kill(pppid, SIGTERM);
	else {
		//update_wtmp(cfgtunnel->wtmp, "", getpid(), "");
		exit(0);
	}
	signal(SIGINT, &sig_int_slave);
	signal(SIGTERM, &sig_int_slave);
}

void sig_alrm_slave(int status)
{
	stopped = 1;
	signal(SIGALRM, &sig_alrm_slave);
}

void sig_int_master(int status)
{
	stopped = 1;
	signal(SIGINT, &sig_int_master);
	signal(SIGTERM, &sig_int_master);
}

void kill_then_wait_childs()
{
	int index;
	syslog(LOG_INFO, "kill_then_wait_childs");
	for (index = 0; index < cfgtunnel->maxclients; index ++) {
		if (*(child_ids + index) != - 1) {
			syslog(LOG_DEBUG, "Killing %d", *(child_ids + index));
			kill(*(child_ids + index), SIGTERM);
		}
	}
	while (nbchild) {
		select(0 , NULL, NULL, NULL, NULL);
	}
}

int init_socket(unsigned long addr, unsigned short port)
{
	int sock= -1 ;
	struct sockaddr_in sin;
	int one = 1;
  
	if ( ( sock = socket(AF_INET, SOCK_STREAM, 0) ) < 0 ) {
		syslog(LOG_ERR, "socket: %s", strerror(errno));
		exit(-1);
	}
	
	/* Bind socket */
	memset( &sin, sizeof(struct sockaddr_in), 0 );
	sin.sin_family = AF_INET;
	sin.sin_port = ntohs(port);
	sin.sin_addr.s_addr = addr;
	
	setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &one, sizeof(int));
	
	if ( bind(sock, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) ) {
		syslog(LOG_ERR, "bind: %s", strerror(errno));
		exit(-1);
	}
	
	if ( listen(sock, 10) ) {
		syslog(LOG_ERR, "listen: %s", strerror(errno));
		exit (-1);
	}
	
	if( ioctl(sock, FIONBIO, &one) < 0 ) {
		syslog(LOG_ERR, "ioctl: %s", strerror(errno));
		exit (-1);
	}
	
	return sock;
}

void sockerror(char *string) 
{
  syslog(LOG_WARNING, "sock error %s", string);
}

int berr_exit(char *string)
{
    syslog(LOG_ERR, "berr_exit: %s", string);
    exit(0);
}


static void show_help (void) {
	char *b = PACKAGE_NAME "-" PACKAGE_VERSION " ("__DATE__ " " __TIME__ ")" \
" - a DrayTek SSLTunnel server\n" \
"usage:\n" \
" -A         bind ip address\n" \
" -P         bind port\n" \
" -h         show this help\n" \
"\n"
;
	write(STDOUT_FILENO, b, strlen(b));
}

int main (int argc, char **argv)
{
	int o, dev_null, csd;
	unsigned short ssltunnel_port = DEFAULT_PORT;
	unsigned long ssltunnel_addr = inet_addr(DEFAULT_IPADDR);
	int fpid;
	char pidstring[32];
	int index;

	while (-1 != (o = getopt(argc, argv, "A:P:h"))) {
		switch(o) {
		case 'A':
			ssltunnel_addr = inet_addr(optarg);
			break;
		case 'P':
			ssltunnel_port = atoi(optarg);
			ssltunnel_port = ssltunnel_port > 0 && ssltunnel_port <= 65535 ? ssltunnel_port : DEFAULT_PORT;
			break;
		case 'h':
			show_help(); return 0;
		default:
			show_help(); return -1;
		}
	}

	cfgtunnel = malloc(sizeof(tunnel_config_t));
  cfgtunnel->userfile = USERFILE;
  cfgtunnel->maxclients = MAXCHILD;
  cfgtunnel->network_timeout = DEFAULT_NETWORK_TIMEOUT;
  //cfgtunnel->listenaddr = DEFAULT_IPADDR; 
  //cfgtunnel->port = DEFAULT_PORT;
  cfgtunnel->pidfile = DEFAULT_PIDFILE;
  
	syslog (LOG_INFO, "ssltunnel server start....");
	
	/* close stdin, stdout and stderr, as they are not needed */
	close(0);
	close(1);
	close(2);
	dev_null = open("/dev/null", O_RDWR);
	dup2(dev_null, 0);
	dup2(dev_null, 1);
	dup2(dev_null, 2);
  
  if (dev_null > 2) close(dev_null);
	
	child_ids = malloc(cfgtunnel->maxclients * sizeof(pid_t));
  for (index = 0; index < cfgtunnel->maxclients; index++) 
    *(child_ids + index) = -1;

  signal(SIGCHLD, &sig_chld_master) ;
  signal(SIGINT, &sig_int_master) ;
  signal(SIGTERM, &sig_int_master) ;

	/* Create pid file */
	unlink(cfgtunnel->pidfile);
	if ((fpid = open(cfgtunnel->pidfile, O_CREAT|O_WRONLY|O_EXCL, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH )) < 0) {
		syslog(LOG_ERR, "Unable to open %s: %s", cfgtunnel->pidfile, strerror(errno));
		exit(1);
  }
  snprintf(pidstring, 31 , "%d\n", (int) getpid());
  write(fpid, pidstring, strlen(pidstring));
  close(fpid);

#if 0
  /* Create/check lockdir */
  mkdir(cfgtunnel->lockdir, S_IRWXU);
  chmod(cfgtunnel->lockdir, S_IRWXU);
  if ( lstat(cfgtunnel->lockdir, &lockdirs) ||
      (lockdirs.st_mode & S_IFMT) != S_IFDIR ||
      (lockdirs.st_uid != getuid()) ||
      (lockdirs.st_mode & S_IRWXG) != 0 ||
      (lockdirs.st_mode & S_IRWXO) != 0) {

    //syslog(LOG_ERR, "Unable to create %s securely",
    //    cfgtunnel->lockdir);
  }
#endif


	listen_sock = init_socket(ssltunnel_addr, ssltunnel_port);

	while (!stopped) {
		if ( (csd = tcp_accept_fork()) != -1 ) {
			do_server_loop_nossl(csd);
			exit(0);
		}
	}

	/* Kill and wait child */
	kill_then_wait_childs();
	syslog(LOG_NOTICE, "ssltunnel server exiting");
	unlink(cfgtunnel->pidfile);

	close(listen_sock);
	
	return 0;
}

static int signaled = 0;

/*** do nothing signal handler ************************************************/
void do_nothing(int sig)
{ 
    /* do nothing signal handler. Better than SIG_IGN. */
    signaled = sig;
}


int tcp_accept_fork()
{
	int sock=-1;
	int newsock;
	struct sockaddr_in peeraddr;
	unsigned int len;
	int pid;
	int r,num;
	client_data_t *myClient=NULL;
	int tuyauIn[2];
	int tuyauOut[2];
	int  masterfd,slavefd;
	struct termios blah;
  
	fd_set rset;
	int index;
	int maxsocket;
	int nd;
	int one=1;
	char *ptr;
	struct flock locks;
	int fdlock;
	char *ptrsrc,*ptrdest;
#ifdef WITH_LIBWRAP
  struct request_info request;
#endif
	char remote_ipaddr[32];
  
	syslog(LOG_INFO, "tcp_accept_fork");

	FD_ZERO(&rset);
	maxsocket = 0;
 
	FD_SET(listen_sock, &rset);
	if ( listen_sock > maxsocket ) maxsocket = listen_sock;
  
	while ( (nd = select ( maxsocket + 1, &rset, NULL, NULL, NULL )) < 0 && 
          errno == EINTR && !stopped) ;

	if (nd <=0 ) {
		syslog(LOG_INFO, "select: %s", strerror(errno));
		return -1;
	}

	if (FD_ISSET( listen_sock, &rset )) {
		sock = listen_sock;
	}
  
	len = sizeof (struct sockaddr_in);
	newsock = accept( sock , (struct sockaddr *) &peeraddr, &len);

	if (newsock < 0 ) {
		syslog(LOG_ERR, "accept: %s", strerror(errno));
		return -1;
	}

	if (nbchild >= cfgtunnel->maxclients ) {
		syslog(LOG_ERR, "too many childs !");
		close( newsock );
		return -1;
	}

#ifdef WITH_LIBWRAP
  request_init(&request, RQ_DAEMON, TCPD_DAEMON_NAME , RQ_FILE, newsock , NULL);
  fromhost(&request); 
  if (!hosts_access(&request)) {
    syslog(LOG_WARNING,"Refused connection from %s\n", eval_client(&request));
    close(newsock);
    return -1;
  }
#endif 

	if (newsock > 0) {
		pid = fork();
		if (pid > 0) {
			close(newsock);
			for (index = 0; index < cfgtunnel->maxclients; index ++) {
				if (*(child_ids + index) == - 1) {
					*(child_ids + index) = pid;
					break;
				}
			}
			nbchild++;
			return -1;
		} 
		else if (pid == 0 ) {
			close(listen_sock);
      stopped = 0;
      signal(SIGCHLD, &sig_chld_slave);
      signal(SIGINT, &sig_int_slave);
      signal(SIGALRM, &sig_alrm_slave);
      signal(SIGTERM, &sig_int_slave);

			strcpy(remote_ipaddr, inet_ntoa(peeraddr.sin_addr));
			syslog(LOG_NOTICE, "Accepting connection from %s", remote_ipaddr);
			
      /* Set non block */
			if(ioctl(newsock, FIONBIO, &one)<0) {
				syslog(LOG_ERR, "ioctl: %s", strerror(errno));
				exit (-1);
			}
			//setsockopt( newsock, 6, TCP_NODELAY, &one, sizeof(int));
      
      syslog(LOG_NOTICE, "network_timeout = %d", cfgtunnel->network_timeout);
      //printf("network_timeout = %d\r\n", cfgtunnel->network_timeout);
	  
		memset(remote_ipaddr,0,32);
		memset(buffer,0,36);
		sleep(1);
		num=read(newsock, remote_ipaddr, 16);
		if (num != 16) {
    	syslog(LOG_INFO, "Error reading remote ip");
      goto catch;
    }
      
		syslog ( LOG_INFO, "[ssltunnel]read remote ip=%s, len=%d", remote_ipaddr, num);
	  
	  num=read(newsock, buffer, 34);
		if (num != 34) {
    	syslog(LOG_INFO, "Error reading cookie");
      goto catch;
    }
      
		syslog ( LOG_INFO, "[ssltunnel]read cookie=%s, len=%d", buffer, num);
	  
	  //printf("read buffer=%s, len=%d\r\n", buffer, num);
	  //myClient = getclientdata (remote_ipaddr, buffer);

				if (openpty(&masterfd,&slavefd,ttydev,NULL,NULL)) {
          syslog(LOG_ERR, "openpty: %s", strerror(errno));
          goto catch;
        };
        syslog(LOG_ERR, "openpty: %s", ttydev);

        tuyauIn[0]= slavefd;
        tuyauOut[0]= masterfd;
        tuyauIn[1]= masterfd;
        tuyauOut[1]= slavefd;

			myClient = getclientdata (remote_ipaddr, buffer);

			/* fork and wait. */
      //signal(SIGUSR1, do_nothing); /* don't die */
      //signal(SIGCHLD, do_nothing); /* don't ignore SIGCHLD */
      int parent_pid = getpid();
        
      nbchild = 0;
      if ((pppid = fork()) !=0 ) {

         nbchild++;
         close(slavefd);
         close(0);
         close(1);
         dup2(tuyauOut[0],0);
         dup2(tuyauIn[1],1);
         sleep(2);
         //kill(parent_pid, SIGUSR1);
         //sleep(2);
		    return newsock;
      }
      else if (pppid == 0) {

         //if (wtmpfd != -1) close(wtmpfd);
         //close(fdlock);
         close(0);
         close(1);
         close(newsock);
         close(masterfd);
         dup2(tuyauIn[0],0);
         dup2(tuyauOut[1],1);
				
				/*
                 * There is still a very small race condition here.  If a signal
                 * occurs after signaled is checked but before pause is called,
                 * things will hang.
                 */
                //if (!signaled) {
                //    pause(); /* wait for the signal */
                //}
       syslog ( LOG_INFO, "[ssltunnel]Exec: %s", myClient->exec );

         if (execvp ( myClient->exec, myClient->args )) {
           syslog(LOG_ERR, "execv: %s", strerror(errno));
           exit(1);
         }

      }
      else {
         syslog (LOG_ERR, "fork: %s", strerror(errno));
      }

catch:
        //update_wtmp(cfgtunnel->wtmp, "", getpid(), "");
        close(newsock);
        exit ( 0 );
    }
    else {
      syslog(LOG_ERR, "fork: %s", strerror(errno));
      close(newsock);
      return -1;
    }
  }

  return -1;

}


unsigned char packet_buff[SIZE*2 + 2048];
unsigned char back_buffer[SIZE * 3];
int back_ptr;
unsigned char ssl_buff[SIZE + 2048];

unsigned char *sock_buff;
unsigned char *ppp_buff;
unsigned char *ppp_pkt_header, *ppp_pkt_tail, *ppp_pkt_current;
int last_len = 0, last_read = 0;


#define HDLC_FLAG         0x7E
#define HDLC_ESCAPE       0x7D
#define HDLC_TRANSPARENCY 0x20
int syncppp = 1;

unsigned char* next_sync_header(unsigned char *ppp_pkt, int ppp_len)
{
	int i;
	unsigned char *ppp_sync_hdr = NULL;
	if(!ppp_pkt) return NULL;
	
	ppp_sync_hdr = ppp_pkt;
	for(i = 0; i < ppp_len; i++) {
		if(*ppp_sync_hdr == 0xff && ppp_pkt[i] == 0x03) {
			return ppp_sync_hdr;
		}
		ppp_sync_hdr = ppp_pkt + i;
	}
	
	return NULL;
}


/* ONE blocking read per call; dispatches all packets possible */
/* returns 0 on success, or <0 on read failure                 */
int decaps_hdlc(int fd, int (*cb)(int cl, unsigned char *pack, unsigned int len), int cl)
{
    unsigned char *buffer;
    unsigned char *next_hdr = NULL;
    unsigned int start = 0;
    int end;
    int status, isComplete = 0;
    static unsigned int len = 0, escape = 0, copy_len = 0, space = 0;
    static unsigned char copy[PACKET_MAX];
    static int checkedsync = 0;
    
    buffer = copy;
    space = PACKET_MAX - copy_len;
    /* start is start of packet.  end is end of buffer data */
    /*  this is the only blocking read we will allow */
    if ((end = read (fd, buffer + copy_len, space)) <= 0) {
        int saved_errno = errno;
        syslog(LOG_INFO, "short read (%d): %s", end, strerror(saved_errno));
	switch (saved_errno) {
	  case EMSGSIZE: {
	    int optval, optlen = sizeof(optval);
	    syslog(LOG_INFO, "transmitted GRE packet triggered an ICMP destination unreachable, fragmentation needed, or exceeds the MTU of the network interface");
#define IP_MTU 14
	    if(getsockopt(fd, IPPROTO_IP, IP_MTU, &optval, &optlen) < 0)
	      syslog(LOG_INFO, "getsockopt: %s", strerror(errno));
	    syslog(LOG_INFO, "getsockopt: IP_MTU: %d\n", optval);
	    return 0;
	  }
	case EIO:
    	    syslog(LOG_INFO, "pppd may have shutdown, see pppd log");
	    break;
	}
        return -1;
    }
    end += copy_len;
    copy_len = 0;
    /* in synchronous mode there are no hdlc control characters nor checksum
     * bytes. Find end of packet with the length information in the PPP packet
     */
    if ( syncppp ){
        while ( start + 8 <= end) {
        	if(*(buffer + start) == 0xff && *(buffer + start + 1) == 0x03) {
            len = ntohs(*(short int *)(buffer + start + 6)) + 4;
            next_hdr = next_sync_header(buffer + start + 2, end - (start + 2));
            if( start + len == end)
            	isComplete = 1;
            if( start + len + 2 <= end) {
            	if(*(buffer + start + len) == 0xff && *(buffer + start + len + 1) == 0x03)
            		isComplete = 1;
            }	
            /* note: the buffer may contain an incomplete packet at the end
             * this packet will be read again at the next read() */
            if ( start + len <= end) {
            	if(!next_hdr || (len == next_hdr - (buffer + start)) || isComplete) {
                if ((status = cb (cl, buffer + start, len)) < 0) {
                	syslog(LOG_INFO, "syncppp start = %d, end = %d, buffer", start, end);
                    return status; /* error-check */
                }
            } else {
              	syslog(LOG_INFO, "syncppp start = %d, end = %d, 01skip len = %d, %d", start, end, len, next_hdr - (buffer + start));
              	len = next_hdr - (buffer + start);
              }
            } else {
            	//syslog(LOG_INFO, "syncppp start = %d, end = %d, len = %d, discard", start, end, len);
            	copy_len = end-start;
            	memmove(copy, buffer + start, copy_len);
            }
            start += len;
          } else {
          	next_hdr = next_sync_header(buffer + start, end - start);
          	if(!next_hdr) {
          		len = end - start;
          	} else {
          		len = next_hdr - (buffer + start);
          	}
          	syslog(LOG_INFO, "syncppp start = %d, end = %d, 02skip len = %d", start, end, len);
          	start += len;
          }
        }

        if(!(start + 8 <= end) && start < end) {
        	syslog(LOG_INFO, "syncppp start = %d, end = %d, len = %d, copy", start, end, len);
          copy_len = end-start;
          memmove(copy, buffer + start, copy_len);
        }
        
        return 0;
    }

    return 0;
    /* No more data to process. */
}

int send_ssl_packet (int fd, unsigned char *pack, unsigned int len)
{
	int ret = -1, num, n, retry_len;
	struct SSTP_HEADER *p_header_send;
	p_header_send = packet_buff;
  unsigned char *sock_buff = packet_buff + SSTP_HEADER_LEN;
  static unsigned int last_len = 0;
  if(0) { //pack[0]!=0xff || pack[1]!=0x03) {
  	syslog(LOG_INFO, "send_ssl_packet last len = %d, curr len = %d, %02x, %02x", last_len, len, pack[0], pack[1]);
  	for(n = SSTP_HEADER_LEN; n < last_len; n+=16) {
			syslog(LOG_INFO, "%02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x",
                    		packet_buff[n], packet_buff[n+1], packet_buff[n+2], packet_buff[n+3],
                    		packet_buff[n+4], packet_buff[n+5], packet_buff[n+6], packet_buff[n+7],
                    		packet_buff[n+8], packet_buff[n+9], packet_buff[n+10], packet_buff[n+11],
                    		packet_buff[n+12], packet_buff[n+13], packet_buff[n+14], packet_buff[n+15]);
		}
		syslog(LOG_INFO, "send_ssl_packet pack");
		for(n = 0; n < len; n+=16) {
			syslog(LOG_INFO, "%02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x",
                    		pack[n], pack[n+1], pack[n+2], pack[n+3],
                    		pack[n+4], pack[n+5], pack[n+6], pack[n+7],
                    		pack[n+8], pack[n+9], pack[n+10], pack[n+11],
                    		pack[n+12], pack[n+13], pack[n+14], pack[n+15]);
		}
  	return -2;
  }
  memset(p_header_send, 0, sizeof(struct SSTP_HEADER));
  p_header_send->command = SSTP_CMD_DATA;
  p_header_send->ulLen = htons(len);
  memcpy(sock_buff, pack, len);
  
  last_len = len;
  num=write(fd, packet_buff, len+SSTP_HEADER_LEN); 
	if(num == len+SSTP_HEADER_LEN) {
		outbytes+=len;
		ret = 0;
	} else if(num > 0) { // retry one time
		retry_len = len+SSTP_HEADER_LEN - num;
		num=write(fd, packet_buff+num, retry_len);
		if(num == retry_len) {
			outbytes+=len;
			ret = 0;
		} else {
			syslog(LOG_INFO, "send_ssl_packet num = %d, retry_len = %d.", num, retry_len);
		}
	} else {
		syslog(LOG_INFO, "send_ssl_packet num = %d.", num);
	}
	
	lastsend_tm = time(NULL);
	return ret;
}

/*** Make stripped packet into HDLC packet ************************************/
int encaps_hdlc(int fd, void *pack, unsigned int len)
{
    unsigned char *source = (unsigned char *)pack;
    unsigned char dest[2 * PACKET_MAX + 2]; /* largest expansion possible */
    unsigned int pos = 0, i;
    u_int16_t fcs;
    /* in synchronous mode there is little to do */
    if ( syncppp )
        return write(fd, source, len);
    return 0;
}

int do_server_loop_nossl(int csk)
{
    fd_set rd_set, wr_set, err_set;
    int num=0, fdno, ssl_fd, ssl_bytes, sock_bytes, retval, ssl_err;
    //struct SSTP_HEADER sstp_header_send, sstp_header_recv;
    int sock_ptr, ssl_ptr, ppp_ptr, sock_open, ssl_open;
    unsigned long l;
    int try_kill;
    struct timeval tmo;
    int recv_header = 0;
    struct SSTP_HEADER *p_header_send, *p_header_recv;
    int send_len, recv_len;
    char tmplog[100];
    char tmpbf[10];
    int i, j, n, z;
    unsigned short *pLen;
    int ppplen = 0;
    char reqbuf[20];
    int reqlen, want_recv, want_send, want_ssl_send, ssl_sent_ptr;
    struct timeval tv;
    struct timeval tv0;
    
    syslog ( LOG_INFO, "[ssltunnel]%s", "do_server_loop_nossl()");
    
    p_header_send = packet_buff;
    sock_buff = packet_buff + SSTP_HEADER_LEN;
    p_header_recv = ssl_buff;
    ppp_buff = ssl_buff + SSTP_HEADER_LEN;
    memset(p_header_send, 0, sizeof(struct SSTP_HEADER));
    memset(p_header_recv, 0, sizeof(struct SSTP_HEADER));
    //p_header_send->version = 0;
    //p_header_recv->version = 0;
    lastrecv_tm = time(NULL);
    lastsend_tm = time(NULL);

    ssl_fd=csk;
    fdno=ssl_fd+1;
    sock_ptr=0;
    ssl_ptr=0;
    sock_open=1;
    ssl_open=1;
    sock_bytes=0;
    ssl_bytes=0;
    
    want_send=0;
    ppp_ptr=0;

    want_ssl_send = 0;
    ssl_sent_ptr = 0;

		back_ptr = 0;
		
		
    l=1; /* ON */
    if(ioctl(0, FIONBIO, &l)<0)
        sockerror("ioctlsocket (sock)");
    if(ioctl(1, FIONBIO, &l)<0)
        sockerror("ioctlsocket (sock)");
    if(ioctl(ssl_fd, FIONBIO, &l)<0)
        sockerror("ioctlsocket (ssl)");

    while((sock_open||sock_ptr) && (ssl_open||ssl_ptr) && !stopped) {

        FD_ZERO(&rd_set);
        FD_ZERO(&err_set);
        if(sock_open && sock_ptr<SIZE) { /* can read from socket */
            FD_SET(0, &rd_set);
            FD_SET(0, &err_set);
        }
        if(ssl_open && ssl_ptr<SIZE)   /* can read from SSL */
            FD_SET(ssl_fd, &rd_set);

        FD_ZERO(&wr_set);
        if(sock_open && want_send) {      /* can write to socket */
            FD_SET(1, &wr_set);
            FD_SET(1, &err_set);
        }

        //if(ssl_open && sock_ptr)       /* can write to SSL */
        //    FD_SET(ssl_fd, &wr_set);

/*
        if ( SSL_pending(ssl) > 0 ){
           FD_ZERO(&rd_set);
           FD_ZERO(&wr_set);
           FD_SET(ssl_fd, &rd_set);
           goto next;
        }
*/
        //gettimeofday (&tv , NULL);
        //syslog(LOG_INFO, "%d.%d", tv.tv_sec, tv.tv_usec);
        tv.tv_sec = 1;
        tv.tv_usec = 0;
        if((z = select(fdno, &rd_set, &wr_set, &err_set, &tv))<0 && errno!=EINTR) {
            sockerror("select");
            goto error;
        }

        if(z == 0) {
        	current_tm = time(NULL);
				  if(current_tm - lastrecv_tm >= SSTP_TIME_OUT) { // keepalive timeout
					  syslog(LOG_INFO, "Keepalive timeout %lu, %lu.", current_tm, lastrecv_tm);
					  goto term_normally;
				  }
				  continue;
				}
				
next:
        if(FD_ISSET(0, &err_set)){
            sockerror("err_set 0");
            goto error;
        }

        if(FD_ISSET(1, &err_set)){
            sockerror("err_set 1");
            goto error;
        }
        if(FD_ISSET(0, &rd_set)) {
        	
					if ( (num = decaps_hdlc(0, send_ssl_packet,  ssl_fd)) < 0) {
			    	syslog(LOG_INFO, "decaps_hdlc error %d.", num);
			    	goto error;
			    }

        }

        if(ssl_open && !want_send && FD_ISSET(ssl_fd, &rd_set)) {
            //syslog(LOG_INFO, "rd_set ssl_fd, ssl_ptr=%d", ssl_ptr);
            if(ssl_ptr < SSTP_HEADER_LEN) {
                num = read(ssl_fd, ssl_buff+ssl_ptr, SSTP_HEADER_LEN-ssl_ptr);
                //syslog(LOG_INFO, "read ssl, SSL Tunnel Header, num=%d", num);

                if (num < 0) {
                    sockerror("ssl read");
                    ssl_open = 0;
                } else if (num > 0) {
                    ssl_ptr += num;
                } else { // close 
                    syslog(LOG_INFO, "ssl closed on read");
                    ssl_open = 0;
                }
            }
            
            if(ssl_open && ssl_ptr >= SSTP_HEADER_LEN) {
                if(p_header_recv->command == SSTP_CMD_CLOSE){
                    syslog(LOG_INFO, "SSTP_CMD_CLOSE");
                    goto term_normally;
                } else if(p_header_recv->command == SSTP_CMD_REQUEST){
                    syslog(LOG_INFO, "SSTP_CMD_REQUEST,%d", ntohs(p_header_recv->ulLen));
            				
                    want_recv = ntohs(p_header_recv->ulLen);
                    //num = SSL_read(ssl, reqbuf, reqlen);
                    if(ssl_ptr < want_recv+SSTP_HEADER_LEN) {
                        num=read(ssl_fd, ssl_buff+ssl_ptr, want_recv-(ssl_ptr-SSTP_HEADER_LEN));
                        //syslog(LOG_INFO, "SSTP_CMD_REQUEST: want_recv=%d, num=%d, ssl_ptr=%d", want_recv, num, ssl_ptr);

                        if (num < 0) {
                            sockerror("ssl read");
                            ssl_open = 0;
                        } else if (num > 0) {
                            ssl_ptr += num;
                            //inbytes += num;
                            lastrecv_tm = time(NULL);
                        } else { // close 
                            syslog(LOG_INFO, "ssl closed on read");
                            ssl_open = 0;
                        }
                    }
                  
                    if(ssl_open && ssl_ptr == want_recv+SSTP_HEADER_LEN) {
                        p_header_recv->command = SSTP_CMD_REPLY;
                        num=write(ssl_fd, ssl_buff, ssl_ptr); 
                    		syslog(LOG_INFO, "SSTP_CMD_REPLY,%d", num - SSTP_HEADER_LEN);
                    		if(ssl_ptr!=num) {
                        	sockerror("SSL_write (socket)");
								        	goto error;
                    		} else {
                    			lastsend_tm = time(NULL);
                        	ssl_bytes+=num;
                        	sock_ptr = 0;
                    		}

                    		want_send = 0;
                        ssl_ptr = 0;
                    }
                } else if(p_header_recv->command == SSTP_CMD_DATA){
                    //gettimeofday (&tv , NULL);
                    //syslog(LOG_INFO, "%d.%d|data,%d", tv.tv_sec, tv.tv_usec, ntohs(p_header_recv->ulLen));
                    want_recv = ntohs(p_header_recv->ulLen);
                    //syslog(LOG_INFO, "SSTP_CMD_DATA: want_recv=%d, ssl_ptr=%d", want_recv, ssl_ptr);
                    if(ssl_ptr < want_recv+SSTP_HEADER_LEN) {
                        num=read(ssl_fd, ssl_buff+ssl_ptr, want_recv-(ssl_ptr-SSTP_HEADER_LEN));
                        //syslog(LOG_INFO, "SSTP_CMD_DATA: want_recv=%d, num=%d, ssl_ptr=%d", want_recv, num, ssl_ptr);
                        if (num < 0) {
                            sockerror("ssl read");
                            ssl_open = 0;
                        } else if (num > 0) {
                            ssl_ptr += num;
                            inbytes += num;
                            lastrecv_tm = time(NULL);
                        } else { // close 
                            syslog(LOG_INFO, "ssl closed on read");
                            ssl_open = 0;
                        }
                    }
                  
                    if(ssl_open && ssl_ptr == want_recv+SSTP_HEADER_LEN) {
                    	
										if((num = encaps_hdlc(1, ppp_buff, want_recv)) < 0) {
											syslog(LOG_INFO, "encaps_hdlc error %d, want_recv = %d.", num, want_recv);
			    						goto error;
										} else {
											ppp_ptr = num;
                      want_send = want_recv - num;
                      if(!want_send)
                      	ssl_ptr = 0;
                      //else
                      	//syslog(LOG_INFO, "encaps_hdlc real_send = %d, want_recv = %d.", num, want_recv);
										}
                        
                    }
                }
            }
        }

        if(sock_open && want_send>0 && FD_ISSET(1, &wr_set)) {
            num=write(1, ppp_buff+ppp_ptr, want_send);
            //syslog(LOG_INFO, "wr_set: want_recv=%d, num=%d", want_send, num);
            if (num < 0) {
                sockerror("ppp write");
                sock_open = 0;
            } else if (num > 0) {
                ppp_ptr += num;
                want_send -= num;
                if(!want_send)
                	ssl_ptr = 0;
                else
                	syslog(LOG_INFO, "need more write %d", want_send);
            } else { // close 
                syslog(LOG_INFO, "ppp closed on write");
                sock_open = 0;
            }
        }
        
        current_tm = time(NULL);
				if(current_tm - lastrecv_tm >= SSTP_TIME_OUT) { // keepalive timeout
					syslog(LOG_INFO, "Keepalive timeout %lu, %lu.", current_tm, lastrecv_tm);
					goto term_normally;
				}
    } // while
    retval=0;
term_normally:
    syslog(LOG_NOTICE,"terminating normally");
    retval = 0;
    goto done;

error:
    syslog(LOG_NOTICE,"terminating abnormally");
    retval=-1;

done:
    close(ssl_fd);
    close(0);
    close(1);

    syslog(LOG_NOTICE,"In Bytes: %ld, Out Bytes: %ld", inbytes, outbytes);
    
    try_kill = 0;
    while (pppid != -1) {
      syslog(LOG_NOTICE,"killing child");
      kill ( pppid, try_kill > 3 ? SIGKILL : SIGTERM );
      try_kill ++;
      tmo.tv_sec = 5;
      tmo.tv_usec = 0;
      select (0, NULL, NULL, NULL, &tmo);
    }
    syslog(LOG_NOTICE,"Child has exited");
      
    return retval;
}