#!/bin/sh
[ -e /etc/functions.sh ] && . /etc/functions.sh || . ./functions.sh
[ -x /sbin/modprobe ] && insmod="modprobe" || insmod="insmod"

add_insmod() {
	eval "export isset=\${insmod_$1}"
	case "$isset" in
		1) ;;
		*) append INSMOD "$insmod $* " "$N"; export insmod_$1=1;;
	esac
}

[ -e /etc/config/network ] && {
	# only try to parse network config on openwrt

	find_ifname() {(
		reset_cb
		include /lib/network
		scan_interfaces
		config_get "$1" ifname
	)}
} || {
	find_ifname() {
		echo "Interface not found."
		exit 1
	}
}

parse_matching_rule() {
	local var="$1"
	local section="$2"
	local options="$3"
	local prefix="$4"
	local suffix="$5"
	local proto="$6"
	local mport=""
	local ports=""

	append "$var" "$prefix" "$N"
	config_get type "$section" TYPE
	case "$type" in
		classify) unset pkt;;
		default) pkt=1;;
		reclassify) pkt=1;;
	esac
	for option in $options; do
		config_get value "$section" "$option"
		
		case "$pkt:$option" in
			*:srchost)
				append "$var" "match ip src $value"
			;;
			*:dsthost)
				append "$var" "match ip dst $value"
			;;
			*:sport)
				append "$var" "match ip sport $value 0xffff"
			;;
			*:dport)
				append "$var" "match ip dport $value 0xffff"
			;;
			*:port)
				append "$var" "match ip dport $value 0xffff"
			;;
			*:proto)
				case "$value" in
					udp) append "$var" "match ip protocol 0x11 0xff";;
					tcp) append "$var" "match ip protocol 0x06 0xff";;
					*) append "$var" "match ip protocol 0x06 0xff";;
				esac
			;;
			*:dsmark)
				case "$value" in
				        EF) append "$var" "flowid 1:1";;
				        AF11) append "$var" "flowid 1:2";;
				        AF21) append "$var" "flowid 1:3";;
				        AF31) append "$var" "flowid 1:4";;
				        AF41) append "$var" "flowid 1:5";;
				        BE) append "$var" "flowid 1:6";;
				esac
			;;
		esac
	done
	case "$type" in
		classify) append "$var" "$suffix";;
		*) ;;
	esac
	case "$ports:$proto" in
		1:)	parse_matching_rule "$var" "$section" "$options" "$prefix" "$suffix" "udp";;
	esac
}

config_cb() {
	option_cb() {
		return 0
	}

	# Section start
	case "$1" in
		interface)
			config_set "$2" "classgroup" "Default"
		;;
		classify|default|reclassify)
			option_cb() {
				append options "$1"
			}
		;;
	esac

    # Section end
	config_get TYPE "$CONFIG_SECTION" TYPE
	case "$TYPE" in
		interface)
			config_get_bool enabled "$CONFIG_SECTION" enabled 1
			[ 1 -eq "$enabled" ] || return 0
			config_get classgroup "$CONFIG_SECTION" classgroup
			append INTERFACES "$CONFIG_SECTION"
			config_set "$classgroup" enabled 1
			config_get device "$CONFIG_SECTION" device
			[ -z "$device" ] && {
				device="$(find_ifname ${CONFIG_SECTION})"
				config_set "$CONFIG_SECTION" device "${device:-eth0}"
			}
		;;
		classgroup) append CG "$CONFIG_SECTION";;
		classify|default|reclassify)
			case "$TYPE" in
				classify) var="ctrules";;
				*) var="rules";;
			esac
			config_get target "$CONFIG_SECTION" target
			config_set "$CONFIG_SECTION" options "$options"
			append "$var" "$CONFIG_SECTION"
			unset options
		;;
	esac
}


enum_classes() {
	local c="0"
	config_get classes "$1" classes
	config_get default "$1" default
	for class in $classes; do
		c="$(($c + 1))"
		config_set "${class}" classnr $c
		case "$class" in
			$default) class_default=$c;;
		esac
	done
	class_default="${class_default:-$c}"
}


start_interface() {
	local iface="$1"
	local rate="0"
	add_insmod cls_u32
	add_insmod cls_tcindex
	add_insmod sch_prio
	add_insmod sch_dsmark
	
	config_get device "$iface" device
	config_get_bool enabled "$iface" enabled 1
	[ -z "$device" -o 1 -ne "$enabled" ] && {
		echo "Interface '$iface' not found or disabled."
		return 1 
	}
	config_get upload "$iface" upload
	config_get classgroup "$iface" classgroup
	
	rate=`expr $upload / 4`
	dev_up="ifconfig $device up txqueuelen 1000
tc qdisc add dev $device handle 1:0 root dsmark indices 32 set_tc_index 
tc class change dev $device classid 1:1 dsmark mask 0x03 value 0xb8
tc class change dev $device classid 1:2 dsmark mask 0x03 value 0x28
tc class change dev $device classid 1:3 dsmark mask 0x03 value 0x48
tc class change dev $device classid 1:4 dsmark mask 0x03 value 0x68
tc class change dev $device classid 1:5 dsmark mask 0x03 value 0x88
tc class change dev $device classid 1:6 dsmark mask 0x03 value 0x00
tc qdisc add dev $device parent 1:0 handle 2:0 prio bands 4 priomap  2 3 3 3 2 3 0 0 1 1 2 2 2 2 2 2"
echo "$INSMOD" | sh
echo "$dev_up" | sh
	unset INSMOD dev_up
	
	for group in $CG; do
		start_cg $group
	done
}

start_interfaces() {
	for iface in $INTERFACES; do
		start_interface "$iface"
	done
}

add_rules() {
	local var="$1"
	local rules="$2"
	local prefix="$3"
	
	for rule in $rules; do
		unset iptrule
		config_get target "$rule" target
		case "$target" in
		     High) classnr=1;;
		     Medium) classnr=2;;
		     Normal) classnr=3;;
		     Bulk) classnr=4;;
		     *) classnr=3;;
		esac
		config_get options "$rule" options
		parse_matching_rule iptrule "$rule" "$options" "$prefix"
		append "$var" "$iptrule" "$N"
	done
}

start_cg() {
	local iptrules
	local pktrules
	add_rules iptrules "$ctrules" "tc filter add dev $device parent 1: protocol ip u32"
	add_rules pktrules "$rules" "tc filter add dev $device parent 1: protocol ip u32 "
	append pktrules "tc filter add dev $device parent 1:0 protocol ip tcindex mask 0xfc shift 2 pass_on" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 1 handle 0x2e tcindex classid 2:1" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 2 handle 0x0A tcindex classid 2:2" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 2 handle 0x0C tcindex classid 2:2" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 2 handle 0x0E tcindex classid 2:2" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 2 handle 0x12 tcindex classid 2:2" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 2 handle 0x14 tcindex classid 2:2" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 2 handle 0x16 tcindex classid 2:2" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 3 handle 0x1A tcindex classid 2:3" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 3 handle 0x1C tcindex classid 2:3" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 3 handle 0x1E tcindex classid 2:3" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 3 handle 0x22 tcindex classid 2:3" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 3 handle 0x24 tcindex classid 2:3" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 3 handle 0x26 tcindex classid 2:3" "$N"
	append pktrules "tc filter add dev $device parent 2: protocol ip prio 4 handle 0 tcindex mask 0 classid 2:4" "$N"
echo "$INSMOD" | sh
echo "${iptrules:+${iptrules}${N}}" | sh
echo "$pktrules" | sh
        unset INSMOD
}

C="0"
INTERFACES=""
[ -e ./qos.conf ] && {
	. ./qos.conf
	config_cb
} || config_load qos

C="0"
for iface in $INTERFACES; do
	export C="$(($C + 1))"
done

case "$1" in
	interface)
	case "$2" in
	  wan) ingress=eth2;;
	  lan) ingress=eth0;;
	esac
		start_interface "$2"
	;;
	interfaces)
		start_interfaces
	;;
esac
