scan_pppoe() {
	scan_ppp "$@"
}

setup_interface_pppoe() {
	local iface="$1"
	local config="$2"
	local caller="$4"
	local fixed_ip_address=""
	#tr069
	uci set network.$config.ppp_status=enable
	uci set network.$config.ip_status=disable
	config_get always_on "$config" pppoe_always_on
	logger "pppoe.sh enter:"
	[ "$always_on" = "enable" -o "$caller" = "wcd" ] || {
		logger "pppoe.sh: iface=$1, config=$2, caller=$4 => not always_on, not wcd => return"
		return 0
	}
	logger "pppoe.sh: iface=$1, config=$2, caller=$4, always_on=$always_on"
	
	config_get fixed_ip $config pppoe_fixed_ip
	config_get fixed_ip_address $config pppoe_fixed_ip_address
	#echo "Before, fixed_ip=$fixed_ip, fixed_ip_address=$fixed_ip_address" >/dev/console
	if [ "$fixed_ip" = "enable" -a -n "$fixed_ip_address" ]; then
		fixed_ip_option="ipcp-accept-local $fixed_ip_address:"
		#echo "fixed ip enable, fixed_ip_option=$fixed_ip_option" >/dev/console
	else
		fixed_ip_option="noipdefault"
		#echo "fixed ip disable, fixed_ip_option=$fixed_ip_option" >/dev/console
	fi

	for module in slhc ppp_generic pppox pppoe; do
		/sbin/insmod $module 2>&- >&-
	done

	config_get service_name "$config" service_name
	config_get opt "$config" pppd_options
	config_get mtu "$config" pppoe_mtu
	mtu=${mtu:-1492}
	logger "pppoe.sh: start start_pppd"
	start_pppd "$config" \
		$fixed_ip_option \
		plugin rp-pppoe.so \
		mtu $mtu mru $mtu \
		${service_name:+rp_pppoe_service "$service_name"} \
		$opt \
		"nic-$iface"
}
