scan_ppp() {
	config_get ifname "$1" ifname
	pppdev="${pppdev:-0}"
	config_set "$1" ifname "ppp$pppdev"
	config_set "$1" unit "$pppdev"
}

start_pppd() {
	local cfg="$1"; shift

	# make sure only one pppd process is started
	lock "/var/lock/ppp-${cfg}"
	local pid="$(head -n1 /var/run/ppp-${cfg}.pid 2>/dev/null)"
	[ -d "/proc/$pid" ] && grep pppd "/proc/$pid/cmdline" 2>/dev/null >/dev/null && {
		lock -u "/var/lock/ppp-${cfg}"
		return 0
	}

	config_get proto "$cfg" proto
	#config_get device "$cfg" device
	#config_get unit "$cfg" unit
	config_get username "$cfg" "$proto"_username
	config_get password "$cfg" "$proto"_password
	config_get debug "$cfg" "$proto"_debug

	config_get connect "$cfg" connect
	config_get disconnect "$cfg" disconnect

	config_get demand "$cfg" demand
	[ -n "$demand" ] && echo "nameserver 1.1.1.1" > /tmp/resolv.conf.auto
	[ "$debug" = "disable" ] && debug=
	/usr/sbin/pppd "$@" \
		lcp-echo-interval 3 lcp-echo-failure 10 \
		${demand:+precompiled-active-filter /etc/ppp/filter demand idle }${demand:-persist} \
		usepeerdns \
		defaultroute \
		replacedefaultroute \
		${username:+user "$username" password "$password"} \
		linkname "$cfg" \
		ipparam "$cfg" \
		${connect:+connect "$connect"} \
		${disconnect:+disconnect "$disconnect"} \
		holdoff 0 \
		ipv6 , \
		${debug:+debug} 2>/dev/null >/dev/null

	lock -u "/var/lock/ppp-${cfg}"
}

setup_interface_ppp() {
	local iface="$1"
	local config="$2"

	config_get device "$config" device

	config_get mtu "$cfg" mtu
	mtu=${mtu:-1492}
	start_pppd "$config" \
		mtu $mtu mru $mtu \
		"$device"
}

