#include <stdio.h>
#include   <sys/socket.h> 
#include   <netinet/in.h> 
#include   <arpa/inet.h>
#include   <signal.h>
#define SLEEP_DURATION 30
#define MAX_PNP_NETOWRK_IP 100
#define MAX_LEN_PNP_IP_RECORD 1024

unsigned long pnpiplist[MAX_PNP_NETOWRK_IP] = {0};
char pnp_lan[32] = {0};
int pnplistindex = 0;
sig_atomic_t received_signal = 0;

void sighandler_usr(const int sig)
{
	if (sig == SIGUSR1){
		received_signal=1;
	}
}
int isinList(unsigned long ip)
{
	int i;
	char cmd[128];
	for (i=0; i<MAX_PNP_NETOWRK_IP; i++ )
	{
		if(pnpiplist[i]==ip){
			//sprintf(cmd,"echo PNP(isinList): ip=%s is in List of i=%d >/dev/console",ip, i);
			//system(cmd);
			return 1;
		}
	}
	return 0;
}
void addtoList(unsigned long ip)
{
	pnpiplist[pnplistindex]=ip;
	if(pnplistindex == (MAX_PNP_NETOWRK_IP-1) )
		pnplistindex=0;
	else
		pnplistindex++;
}
void flsuhpnpip(void)
{
	int i;
	struct in_addr saddr;
	char setip[16] = {0}, cmd[128] = {0}, tmpip[16] = {0};
	
	for(i=0;i<MAX_PNP_NETOWRK_IP;i++)
	{
		if(!pnpiplist[i])
			continue;
		saddr.s_addr=pnpiplist[i];
		strcpy(setip,inet_ntoa(saddr));
		//sprintf(tmpip,"%lu",pnpiplist[i]);
		sprintf(cmd,"ipset -D lan_nat_subnet %s",setip);
		system(cmd);
		sprintf(cmd,"ip route delete %s dev lan-%s",setip, pnp_lan);
		system(cmd);
		pnpiplist[i]=0;
		
		//sprintf(cmd,"echo PNP Network:Flush IP:%s pnp_lan=lan-%s >/dev/console",setip,pnp_lan);
		//system(cmd);
	}
}

int main(int argc, const char* argv[])
{
	int i,j;
	unsigned long ntmpip=0;
	FILE *fp;
	/*	Note for following array:
	 *	ipaddr[1024]: 1024 > 100*9
	 *		(1)total number of IPs that pnp networking support=100
	 *		(2)each IP maximum record size=9 (ex: ,1a2b3c4d )
	 *	tmpip[16]: 16 > 9
	 *		Is used to store the IP in unsigned long format
	 *	setip[16]:
	 *		Is used to store the IP in dots-and-numbers format
	 */
	char ipaddr[MAX_LEN_PNP_IP_RECORD], cmd[128];
	char tmpip[16] = {0};
	char setip[16] = {0};
	struct in_addr saddr;
	/*register signal SIGUSR1, do complete flush work while recieving this singal*/
	(void) signal(SIGUSR1, sighandler_usr);
	/*get pnp lan profile*/
	FILE *fpipe;
	sprintf(cmd,"uci get pnp_network.pnp.pnp_lan");
	if (!(fpipe = (FILE*) popen(cmd, "r")))
		return 1;
	if (fgets(pnp_lan, 32, fpipe) != NULL)
		pnp_lan[strlen(pnp_lan) - 1] = '\0';
	pclose(fpipe);
	
	//sprintf(cmd,"echo PNP:1 get pnp_lan=%s >/dev/console",pnp_lan);
	//system(cmd);
	
	while(1)
	{
		//sprintf(cmd,"echo PNP:IN WHILE >/dev/console");
		//system(cmd);
		memset(ipaddr,0,MAX_LEN_PNP_IP_RECORD);
		fp=fopen("/proc/pnp_ipaddr","r");
		if(!fp){
			sprintf(cmd,"echo PNP Network:can not open file /proc/pnp_ipaddr >/dev/console");
			system(cmd);
			return 1;
		}
		if ( fread(ipaddr,1,MAX_LEN_PNP_IP_RECORD,fp) == 0 ){
			//sprintf(cmd,"echo PNP:/proc/pnp_ipaddr is empty, sleep >/dev/console");
			//system(cmd);
			sleep(SLEEP_DURATION);
			continue;
		}
		//sprintf(cmd,"echo PNP:fread ipaddr=%s >/dev/console", ipaddr);
		//system(cmd);
		if (received_signal != 0) {
			int flag = received_signal;
			received_signal = 0;
			if( flag == 1){
				sprintf(cmd,"echo PNP Network:Get SIGUSR1,flush all records then terminate process >/dev/console");
				system(cmd);
				flsuhpnpip();
				fclose(fp);
				//reset original LAN subnet: because if IP is in origianl LAN subnet, flsuhpnpip() may also clear it
				sprintf(cmd,"/sbin/ifup %s", pnp_lan);
				system(cmd);
				return 1;
			}
		}
		/* 
		 * Retrive each PnP IP from /proc/pnp_ipddar
		 */
		//sprintf(cmd,"echo ipaddr strlen=%d >/dev/console", strlen(ipaddr));
		//system(cmd);
		for(i=0,j=0 ;i<strlen(ipaddr); i++,j++)
		{
			if( ipaddr[i]==','|| i==(strlen(ipaddr)-1) )
			{
				tmpip[j]=ipaddr[i];
				tmpip[j+1]=0;
				ntmpip=strtoul(tmpip, NULL, 0);
				//sprintf(cmd,"echo PNP:tmpip=%s, ntmpip=%lu >/dev/console", tmpip, ntmpip);
				//system(cmd);
				j=-1;	//reset j to buffer next IP
				if(tmpip[0] != NULL && ntmpip != 0 )
				{
					//get the ip and set the config
					if(!isinList(ntmpip))	//if this IP is not already in list, add it
					{
						saddr.s_addr=ntmpip;
						strcpy(setip,inet_ntoa(saddr));
						sprintf(cmd,"/usr/sbin/ipset -A lan_nat_subnet %s",setip);
						system(cmd);
						sprintf(cmd,"/usr/sbin/ip route add %s dev lan-%s",setip,pnp_lan);
						system(cmd);
						addtoList(ntmpip);
						//sprintf(cmd,"echo PNP:Add ip=%s to IPset >/dev/console",setip);
						//system(cmd);
					}
				}
			}
			else
				tmpip[j]=ipaddr[i];
		}
		fclose(fp);
		
		/*Why: Should flush route in every loop?*/
			//Notice: Here flush ALL route cache
			//system("/usr/sbin/flush_route_cache.sh pnpset.c");
		sleep(SLEEP_DURATION);
	}
	return 1;
}
