#!/bin/sh


username=$1
type=$2
result=$3
ip=$4
routername=$(uci get syslogd.syslogd.routername)
date=$(eval date -R)
status=$(uci get mail_alert.config.status)

if [ "$status" = "disable" ];then
exit
fi 
mailto=$(uci get mail_alert.config.mailto)
if [ "$mailto" = "" ];then
exit
fi 
smtpserver=$(uci get mail_alert.config.smtpserver)
if [ "$smtpserver" = "" ];then
exit
fi 

res=$(ping $(uci get mail_alert.config.smtpserver)  -c 3 -W 1 | grep "0 packets" 2>/dev/null)
if [ "$res" != "" ];then
exit
fi

printf "$username login $routername $result on $date"  > /tmp/mail

if [ "$type" = "TELNET" ];then
	echo	>> /tmp/mail
	echo	>> /tmp/mail
	echo connecting TELNET clients ...  >> /tmp/mail
	netstat | grep tcp | grep ":$(uci get acc_ctrl.access_control.telnet_port) " |grep ESTABLISHED  >> /tmp/mail
	echo	>> /tmp/mail
	echo connecting SSH host ... >> /tmp/mail
	netstat | grep tcp | grep ":$(uci get acc_ctrl.access_control.ssh_port) " |grep ESTABLISHED >> /tmp/mail
else
	echo "  from $ip [WEB]" >> /tmp/mail
fi

rm -f /tmp/mutt-*

subject="$routername alert - User Login Message"

mailto_u=$(uci get mail_alert.config.mailto)
for user in ${mailto_u}; do	
	cat /tmp/mail | mutt -F /etc/config/muttrc -s "$subject"  $user >/dev/null 2>&1 &
done