#!/bin/sh

# Command:
# /usr/sbin/set_lan_df_route.sh [action] [iface]

# Usage:
# set lan route in ip route table default.

# Parameters:
# [action]	: ifup/ifdown
# [iface]	: lan interface, ie. lan1

# Examples:
# /usr/sbin/set_lan_df_route.sh ifup lan1

# Trace and Debug:
# To enable echo in following DBG_PRINT() function.

ACTION=$1
IFACE=$2

#--------------------
# Enable echo in this function when debug
DBG_PRINT() {
	#echo	"[set_lan_df_route.sh][`date +%Y/%m/%d-%H:%M:%S`] $1" > /dev/console
	#echo	"[`date +%Y/%m/%d-%H:%M:%S`] $1" >> /tmp/dbg_log/set_lan_df_route.sh
	#logger	"[set_lan_df_route.sh][`date +%Y/%m/%d-%H:%M:%S`] $1"
	return
}
#--------------------

#validate input
DBG_PRINT "action: $ACTION, iface: $IFACE"
[ "$ACTION" -a "$IFACE" ] || exit 0
[ "`uci get network.$IFACE.physical`" == "eth0" ] || exit 0
status=`uci get network.$IFACE.status`

#ifdown =====
#do nothing

#ifup =======
if [ "$ACTION" == "ifup" -a "$status" == "enable" ]; then
	addr=`uci get network.$IFACE.static_ipaddr`
	mask=`uci get network.$IFACE.static_netmask`
	[ "$addr" -a "$mask" ] && {
		subnet=`ipcalc -n $addr $mask |sed s/NETWORK=//g`
		prefix=`ipcalc -p $addr $mask |sed s/PREFIX=//g`
		DBG_PRINT "ip route replace table default $subnet/$prefix dev lan-$IFACE"
		ip route replace table default $subnet/$prefix dev lan-$IFACE >/dev/null 2>&1
	}
	
	#more subnet
	nets=`uci get network.$IFACE.static_2nd_subnet`
	if [ "$nets" ]; then
		cnt=0
		for oct in $nets; do
			cnt=$(($cnt + 1))
			case $cnt in
				1)
					addr=$oct
					;;
				2)
					mask=$oct
					subnet=`ipcalc -n $addr $mask |sed s/NETWORK=//g`
					prefix=`ipcalc -p $addr $mask |sed s/PREFIX=//g`
					DBG_PRINT "ip route replace table default $subnet/$prefix dev lan-$IFACE"
					ip route replace table default $subnet/$prefix dev lan-$IFACE >/dev/null 2>&1
					;;
				4)
					if [ "$oct" != "enable" -a "$oct" != "disable" ]; then
						addr=$oct
						cnt=1
					fi
					;;
				6)
					cnt=0
					;;
			esac
		done
	fi
fi
