#!/bin/sh
#
# arguments:  $1 $2
# $1 - username
# $2 - one-time-password that is to be checked 
#
# one-time-password must match md5(EPOCHTIME+SECRET+PIN)
# 

BEF_AFT=8	# time before and after in 10s of seconds (8 = 80 seconds)

chop()
{
	num=`echo -n "$1" | wc -c | sed 's/ //g' `
	nummin1=`expr $num "-" 1`
	echo -n "$1" | cut -b 1-$nummin1 
}

if [ ! $# -eq 2 ] ; then
	echo "USAGE: otp_check.sh Username, OTP"
	exit 3
fi

USE_MOTP=`uci get appuser."$1".usemotp`
if [ "$USE_MOTP" != "enable" ]; then
	echo "User not found or OTP disabled"
	exit 2
fi

USERNAME="$1"
PASSWD=`echo -n "$2" | sed 's/[^0-9a-f]/0/g' `
SECRET=`uci get appuser."$USERNAME".motp_secret | sed 's/[^0-9a-fA-F]/0/g' `
PIN=`uci get appuser."$USERNAME".motp_pin| sed 's/[^0-9]/0/g' `
EPOCHTIME=`date +%s` ; EPOCHTIME=`chop $EPOCHTIME`

# delete old logins
#if [ -e "/var/motp/cache/$PASSWD" ]; then
#	echo "FAIL"
#	exit 5
#fi

# failed more than 8 times, account locked?....no lock now 
#if [ "`cat /var/motp/users/$USERNAME 2>/dev/null`" == "8" ]; then
#	echo "FAIL"
#	exit 3
#fi

I=0
EPOCHTIME=`expr $EPOCHTIME - $BEF_AFT`
RUNS=`expr $BEF_AFT + $BEF_AFT`
while [ $I -lt $RUNS ] ; do # minutes before and after
	OTP=`printf $EPOCHTIME$SECRET$PIN | md5sum | cut -b 1-6`
	if [ "$OTP" = "$PASSWD" ] ; then
		#touch /var/motp/cache/$OTP
		echo "ACCEPT"
		exit 0
	fi
	I=`expr $I + 1`
	EPOCHTIME=`expr $EPOCHTIME + 1`
done

echo "FAIL"
#NUMFAILS=`cat "/var/motp/users/$USERNAME" 2>/dev/null`
#if [ "$NUMFAILS" = "" ]; then
#	NUMFAILS=0
#fi
#NUMFAILS=`expr $NUMFAILS + 1`
#echo $NUMFAILS > "/var/motp/users/$USERNAME"
exit 1
