#!/bin/sh

# Command:
# /usr/sbin/flush_conn_by_dev.sh [call from] [device name] [alias?] [ip_filed]

# Usage:
# This command will flush conntracks which [ip_filed] match the device's IPs
# The IPs of a device include its primary IP and alias
# [call from]	: for debug use, which help to trace who call here
# [device name]	: the name should be "wan1","wan2"...(not wan-wanX)
# [alias?]:		: "alias" or "no_alias", which means does it also need to clear conntrack by alias?
# [ip_filed]	: 5 types. (1)orig-src, (2)orig-dst, (3)reply-src, (4)reply-dst (5)all_dir
# the "all_dir" in [ip_filed] will includes (1)~(4)

CALL_FROM=$1
DEVICE_NAME=$2
IF_ALIAS=$3
IP_FIELD=$4
[ "$#" -eq 4 ] || {
	echo "flush_conn_by_dev.sh:call from ${CALL_FROM}, require 4 arguments:[call from] [device name] [alias?] [ip_filed]" >/dev/console
	exit 1
}

ipaddr=`json get network.$DEVICE_NAME.ipaddr`
[ "$IF_ALIAS" = "alias" ] && ipalias=`json get network.$DEVICE_NAME.ip_alias`

if [ "$IP_FIELD" = "all_dir" ] ;then
	#/usr/sbin/conntrack -D -s $ipaddr >/dev/null 2>&1
	#/usr/sbin/conntrack -D -d $ipaddr >/dev/null 2>&1
	#/usr/sbin/conntrack -D -r $ipaddr >/dev/null 2>&1
	#/usr/sbin/conntrack -D -q $ipaddr >/dev/null 2>&1
	/usr/sbin/conntrack -D -A $ipaddr >/dev/null 2>&1 #rev. 2597 new option
	echo "[flush_conn_by_dev.sh][`date +%Y/%m/%d-%H:%M:%S`]:call from [${CALL_FROM}], clear [all_dir] conntrack of device:$DEVICE_NAME's IP:$ipaddr" >/dev/console
	[ "$IF_ALIAS" = "alias" ] && {
		while [ -n "$ipalias" ] ;do
			alias=${ipalias%% *}
			ipalias=${ipalias#$alias}
			ipalias=${ipalias# }
			ip=$(echo $alias |awk -F "/" '{print $1}')
			[ -n "$ip" ] && {
				echo "[flush_conn_by_dev.sh][`date +%Y/%m/%d-%H:%M:%S`]:call from [${CALL_FROM}], clear [all_dir] conntrack of device:$DEVICE_NAME's alias:$ip" >/dev/console
				#/usr/sbin/conntrack -D -s $ip >/dev/null 2>&1
				#/usr/sbin/conntrack -D -d $ip >/dev/null 2>&1
				#/usr/sbin/conntrack -D -r $ip >/dev/null 2>&1
				#/usr/sbin/conntrack -D -q $ip >/dev/null 2>&1
				/usr/sbin/conntrack -D -A $ip >/dev/null 2>&1 #rev. 2597 new option
			}
		done
	}
else
	/usr/sbin/conntrack -D --$IP_FILED $ipaddr >/dev/null 2>&1
	echo "[flush_conn_by_dev.sh][`date +%Y/%m/%d-%H:%M:%S`]:call from [${CALL_FROM}], clear [$IP_FIELD] conntrack of device:$DEVICE_NAME's IP:$ipaddr" >/dev/console
	[ "$IF_ALIAS" = "alias" ] && {
		while [ -n "$ipalias" ] ;do
			alias=${ipalias%% *}
			ipalias=${ipalias#$alias}
			ipalias=${ipalias# }
			ip=$(echo $alias |awk -F "/" '{print $1}')
			[ -n "$ip" ] && {
				echo "[flush_conn_by_dev.sh][`date +%Y/%m/%d-%H:%M:%S`]:call from [${CALL_FROM}], clear [$IP_FIELD] conntrack of device:$DEVICE_NAME's alias:$ip" >/dev/console
				/usr/sbin/conntrack -D --$IP_FILED $ip >/dev/null 2>&1
			}
		done
	}
fi
