
. /etc/functions.sh
include /lib/network

#loads all options for a given package and section
#also, sets all_option_variables to a list of the variable names
load_all_config_options()
{
	pkg_name="$1"
	section_id="$2"

	ALL_OPTION_VARIABLES=""
	# this callback loads all the variables
	# in the section_id section when we do
	# config_load. We need to redefine
	# the option_cb for different sections
	# so that the active one isn't still active
	# after we're done with it.  For reference
	# the $1 variable is the name of the option
	# and $2 is the name of the section
	config_cb()
	{
		if [ ."$2" = ."$section_id" ]; then
			option_cb()
			{
				ALL_OPTION_VARIABLES="$ALL_OPTION_VARIABLES $1"
			}
		else
			option_cb() { return 0; }
		fi
	}


	config_load "$pkg_name"
	for var in $ALL_OPTION_VARIABLES
	do
		config_get "$var" "$section_id" "$var"
	done
}

verbose_echo()
{
	if [ "$verbose_mode" = 1 ]
	then
		echo $1
	fi
}

start_daemon_for_sms()
{
	SECTIONS=""
	config_cb()
	{
		SECTIONS="$SECTIONS $2"
	}
	config_load "sms"

	for section in $SECTIONS
	do
		/usr/lib/ddns/sms_updater.sh $section 0 > /dev/null 2>&1 &
	done
}

monotonic_time()
{
	local uptime
	read uptime < /proc/uptime
	echo "${uptime%%.*}"
}
subtract_quota()
{
	quota=$(uci -q get sms.@service[$profile_id].quota)
	quota=`expr $quota - 1`
	uci -q set sms.@service[$profile_id].quota="$quota"
	uci commit sms
}

resend_sms()
{
	SMS_ALERT_LOG=/tmp/sms_alert.log
	if [ -f $SMS_ALERT_LOG ]; then
		log_time=$(cat $SMS_ALERT_LOG | awk 'FS="|" {print $1}')
		log_service_id=$(cat $SMS_ALERT_LOG | awk 'FS="|" {print $2}')
		log_cmd=$(cat $SMS_ALERT_LOG | awk 'FS="|" {print $3}')
		timeout=$(uci -q get sms.s$log_service_id.timeout)
		now=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		interval=$(($now - $log_time))
		if [ "$now" -gt "$log_time" -a "$interval" -lt "$timeout" ]; then
			$log_cmd
			if [ "$?" -eq "0" ]; then
				rm $SMS_ALERT_LOG
				subtract_quota
				logger -p 160.5 "Retry to send sms alert success."
			else
				logger -p 160.5 "Retry to send sms alert failed."
			fi
		fi
	fi
}