#!/bin/sh

logger -p 144.5 "[User Management]:Daily Schedule: logout online users"

###Get List of logined user account by LOCAL or LDAP AUTH
#local_users=$(cat /tmp/all_local_user_name)
ldap_users=$(cat /tmp/all_ldap_user_name)
radius_users=$(cat /tmp/all_radius_user_name)

#Flush online user only to save execution time
[ -f "/tmp/ubf_record" ] && local_users=`cat /tmp/ubf_record |awk '{if ($2==_t) print $1}' _t=0`
for user in $local_users ;do
	#clear user ipset
	ipset -F usr_$user 2>/dev/null
	#reset login counter in json
	json set appuser.$user login_count=0
done

for ldap_user in $ldap_users ;do
	ipset -X Lus_$ldap_user 2>/dev/null
	json delete ldap_user
	eval sed -i '/^${ldap_user}$/d' /tmp/all_ldap_user_name
	sed -i '/^$/d' /tmp/all_ldap_user_name
done

for radius_user in $radius_users ;do
	ipset -X Rus_$radius_user 2>/dev/null
	eval sed -i '/^${radius_user}$/d' /tmp/all_radius_user_name
	sed -i '/^$/d' /tmp/all_radius_user_name
done

#Get List of IPset name of LDAP profile
[ -f "/tmp/profile_backup/ldap/ldap_ipset_list" ] && {
	ldap_ipset_list=`cat /tmp/profile_backup/ldap/ldap_ipset_list`
	for ldap in $ldap_ipset_list ;do
		ipset -F $ldap 2>/dev/null
	done
}

###clear global records
ipset -F app_guest_all 2>/dev/null
echo > /var/ubf_record 2>/dev/null
echo > /var/ubf_session.json 2>/dev/null
##G47421:Flush all conntrack will also interrupt the connection of white-list IPs
#conntrack -F >/dev/null 2>/dev/null
/usr/sbin/flush_conn_by_ipset.sh logined_user_ip orig-src
ipset -F logined_user_ip 2>/dev/null

#NOTE: To reset `arp -u %s NA` requires IP of user, but to get IP here cost a lot. We ignore this

#call um_auto_recharge
auto_recharge=$(uci get general_conf.base.auto_recharge)
if [ "$auto_recharge" = "enable" ] ;then
	logger -p 144.5 "[User Management]:Daily Schedule: recharge time quota of accounts"
	uci commit appuser
	/sbin/um_auto_recharge
fi

