#!/bin/sh
host=$1
src_if=$2

[ -z "$host" -o -z "$src_if" ] && {
	echo "traceroute [host] [src_if]"
	return 1
}

src_ip=`json get network.$src_if.ipaddr`
connection=`json get network.$src_if.connection`
[ -z "$src_ip" -o "$connection" = "down" ] && {
	echo "$src_if is not available."
	echo "Traceroute done."
	return 1
}

/usr/bin/traceroute -s $src_ip $host
echo "Traceroute done."
return 0
