#!/bin/sh

uptime=$(cat /proc/uptime | cut -d'.' -f 1)

SYS_Rate="$1"
DO_SYS_LOG="$2"
ROUTER_SERIES_NAME="$3"

if [ -f /var/old_systime ]; then
	uptime_1=`cat /var/old_systime`

	DIFF=$(expr $uptime - $uptime_1)
    echo "$uptime" > /var/old_systime
else
	DIFF=$uptime
	echo "$uptime" > /var/old_systime
	touch /var/old_cmm_net
fi

#mem
MEMINFO=$(cat /proc/meminfo | awk 'NR<5{print $2}')
set -- $MEMINFO
TOTAL_MEM=$1
FREE_MEM=$2
CACHED_MEM=$4
MEM_Rate=$((($TOTAL_MEM-$FREE_MEM-$CACHED_MEM)*100/$TOTAL_MEM))

#fpp info 2012/5/16 boham modified
fpp_core=$(cat /sys/devices/fpp/cpu_load)
fpp_mem_size=$(cat /sys/devices/fpp/ddr_heap |(sed 's/ //g')|(sed 's/size://')|(sed 's/free://')|(sed 's/,.*//'))
fpp_mem_use=$(cat /sys/devices/fpp/ddr_heap |(sed 's/ //g')|(sed 's/size://')|(sed 's/free://')|(sed 's/.*,//'))
fpp_mem=$(expr 100 - $fpp_mem_use \* 100 / $fpp_mem_size)

json -f /var/status_system_interface set system \
	fpp_core="$fpp_core" fpp_mem="$fpp_mem"

json -f /var/status_system_interface set system \
	uptime="$uptime" date="$(date | sed -e 's/CST //')" \
	cpuusage="$SYS_Rate" memsize="$TOTAL_MEM" memusage=$MEM_Rate
	

eval `json load network`

intf_list_lan=$(json show network | grep "physical=lan" | cut -d'.' -f 2)
intf_list_wan=$(json show network | grep "physical=wan" | cut -d'.' -f 2)

wancount=1

for elem in $intf_list_lan $intf_list_wan;do
	eval intf_ip_addr=\${network_${elem}_ipaddr}
	eval intf_mac_addr=\${network_${elem}_macaddr}
	eval intf_route_ipaddr=\${network_${elem}_gateway}
	eval intf_uptime=\${network_${elem}_uptime}
	eval intf_connection=\${network_${elem}_connection}
	eval intf_description=\${network_${elem}_des}
	eval intf_proto=\${network_${elem}_proto}
	eval intf_ifname=\${network_${elem}_ifname}
	eval intf_physical=\${network_${elem}_physical}
	eval intf_dns=\${network_${elem}_dns}
	eval intf_proto6=\${network_${elem}_proto6}
	eval intf_ip6addr=\${network_${elem}_ip6addr}
	eval intf_ip6linkip=\${network_${elem}_ip6linkip}
	eval intf_dns6=\${network_${elem}_dns6}
	eval intf_gateway6=\${network_${elem}_gateway6}

	operation=""
	ipv4proto=$(echo $intf_proto | cut -d'(' -f 1)
	if   [ "$ipv4proto" = "pptp" ]; then
		stats=$(cat /proc/net/dev | grep $intf_ifname: | sed -e "s/\(.*\)\:\(.*\)/\2/g" | awk ' { print $10 " " $2 " " $9 " " $1}')
	elif [ "$intf_proto" = "3g" ]; then
		stats="0 0 0 0"
		if [ "$intf_connection" = "up" ]; then
			usb_rpkt=$(ifconfig wan-${elem} 2>/dev/null | grep "RX packets" | awk '{print $2}' | cut -d ':' -f 2)
			usb_tpkt=$(ifconfig wan-${elem} 2>/dev/null | grep "TX packets" | awk '{print $2}' | cut -d ':' -f 2)
			usb_rbyte=$(ifconfig wan-${elem} 2>/dev/null | grep "RX bytes" | awk '{print $2}' | cut -d ':' -f 2)
			usb_tbyte=$(ifconfig wan-${elem} 2>/dev/null | grep "TX bytes" | awk '{print $6}' | cut -d ':' -f 2)
			[ -z "$usb_rpkt" ] || stats="$usb_tpkt $usb_rpkt $usb_tbyte $usb_rbyte"
			operation=`uci -q -P /var/state/ get network.${elem}.usbif`
		fi
	else
		stats=$(cmm -c show stat interface $intf_ifname myquery 2> /dev/null)
	fi
	[ -z "$stats" ] && stats="0 0 0 0"
	echo "$intf_ifname $stats" >> /var/tmp_cmm_net
	set -- $stats
	intf_tx_packets=$1
	intf_rx_packets=$2
	intf_tx_bytes=$3
	intf_rx_bytes=$4

	if   [ "$stats" = "0 0 0 0" ]; then
		intf_tx_rate=0
		intf_rx_rate=0
	else
		old_stats=$(cat /var/old_cmm_net | grep $intf_ifname)
		[ -z "$old_stats" ] && old_stats="$intf_ifname 0 0 0 0"
		set -- $old_stats
		intf_old_tx_bytes=$4
		intf_old_rx_bytes=$5

		old_tx_bytes_len=${#intf_old_tx_bytes}
		old_rx_bytes_len=${#intf_old_rx_bytes}
		tx_bytes_len=${#intf_tx_bytes}
		rx_bytes_len=${#intf_rx_bytes}
		if   [ "$old_tx_bytes_len" -le 8 ]; then
			chunked_old_tx_bytes=$intf_old_tx_bytes
		else
			start_pos=$(expr $old_tx_bytes_len - 8)
			chunked_old_tx_bytes=$(expr substr $intf_old_tx_bytes $start_pos 8)
		fi
		if   [ "$old_rx_bytes_len" -le 8 ]; then
			chunked_old_rx_bytes=$intf_old_rx_bytes
		else
			start_pos=$(expr $old_rx_bytes_len - 8)
			chunked_old_rx_bytes=$(expr substr $intf_old_rx_bytes $start_pos 8)
		fi
		if   [ "$tx_bytes_len" -le 8 ]; then
			chunked_tx_bytes=$intf_tx_bytes
		else
			start_pos=$(expr $tx_bytes_len - 8)
			chunked_tx_bytes=$(expr substr $intf_tx_bytes $start_pos 8)
		fi
		if   [ "$rx_bytes_len" -le 8 ]; then
			chunked_rx_bytes=$intf_rx_bytes
		else
			start_pos=$(expr $rx_bytes_len - 8)
			chunked_rx_bytes=$(expr substr $intf_rx_bytes $start_pos 8)
		fi

		if   [ "$chunked_old_tx_bytes" -lt "$chunked_tx_bytes" ]; then
			intf_tx_rate=$(expr $chunked_tx_bytes - $chunked_old_tx_bytes)
			intf_tx_rate=$(expr $intf_tx_rate / $DIFF)
		else
			intf_tx_rate=0
		fi
		if   [ "$chunked_old_rx_bytes" -lt "$chunked_rx_bytes" ]; then
			intf_rx_rate=$(expr $chunked_rx_bytes - $chunked_old_rx_bytes)
			intf_rx_rate=$(expr $intf_rx_rate / $DIFF)
		else
			intf_rx_rate=0
		fi
	fi
    #echo "$intf_ifname $intf_tx_rate $intf_rx_rate" >> /var/old_network_rate

	if [ -z "$intf_uptime" -o "$intf_connection" = "down" ]; then
		total_time=0
	else
		total_time=$(($uptime - $intf_uptime))
	fi

	json -f /var/status_system_interface set "network.$elem" static_ipaddr="$intf_ip_addr" \
		macaddr="$intf_mac_addr" tx_bytes="$intf_tx_bytes" rx_bytes="$intf_rx_bytes" \
		proto="$intf_proto" gateway="$intf_route_ipaddr" total_time="$total_time" \
		connection="$intf_connection" physical="$intf_physical" rx_packets="$intf_rx_packets" \
		tx_packets="$intf_tx_packets" tx_rate="$intf_tx_rate" rx_rate="$intf_rx_rate" \
		uptime="$intf_uptime" dns_server="$intf_dns" des="$intf_description" \
		proto6="$intf_proto6" ip6addr="$intf_ip6addr" ip6linkip="$intf_ip6linkip" dns6="$intf_dns6" gateway6="$intf_gateway6" \
		operation="$operation"

	if [ "$DO_SYS_LOG" == "1" ]; then
		if [ "$intf_physical" == "lan" -a "$intf_connection" == "up" ]; then
			LanTxPacket=$intf_tx_packets
			LanRxPacket=$intf_rx_packets
		fi
		if [ "$intf_physical" == "wan" -a "$intf_connection" == "up" ]; then
			if [ "$ipv4proto" == "static" ]; then
				WanIpMode="Static IP"
			elif [ "$ipv4proto" == "dhcp" ]; then
				WanIpMode="DHCP Client"			
			elif [ "$ipv4proto" == "pptp" ]; then
				WanIpMode="PPTP"			
			elif [ "$ipv4proto" == "pppoe" ]; then
				WanIpMode="PPPoE"			
			else
				WanIpMode=" "
			fi

 			if [ $wancount == 1 ]; then
				logger -p local5.info -t "syslog" "LAN_Status:[Tx=$LanTxPacket Rx=$LanRxPacket ] WAN_Status:[GW_IP=$intf_route_ipaddr BBandMode=$WanIpMode BBandIp=$intf_ip_addr BBandTxPkt=$intf_tx_packets BBandTxRate=$intf_tx_rate BBandRxPkt=$intf_rx_packets BBandRxRate=$intf_rx_rate BBandUpTime=$(($intf_uptime/3600)):$(($(($intf_uptime/60))%60)):$(($(($intf_uptime%60))))] Model:[Style=0 ModelName=$ROUTER_SERIES_NAME ] "
			else
				logger -p local5.info -t "syslog" "WAN"$wancount"_Status:[GW_IP"$wancount"=$intf_route_ipaddr BBandMode"$wancount"=$WanIpMode BBandIp"$wancount"=$intf_ip_addr BBandTxPkt"$wancount"=$intf_tx_packets BBandTxRate"$wancount"=$intf_tx_rate BBandRxPkt"$wancount"=$intf_rx_packets BBandRxRate"$wancount"=$intf_rx_rate BBandUpTime"$wancount"=$(($intf_uptime/3600)):$(($(($intf_uptime/60))%60)):$(($(($intf_uptime%60))))] "				
			fi

			wancount=$(($wancount+1))

		fi
	fi
done

mv /var/tmp_cmm_net /var/old_cmm_net

