#!/bin/sh

output=$1
if [ "$output" == "json" ]; then
	exit 1
fi

eval `json -f /var/status_system_interface load system`

eval model=\${system_model}
eval hardware=\${system_hardware}
eval firmware=\${system_firmware}
eval model=\${system_model}
eval build_date=\${system_build_date}
eval build_time=\${system_build_time}
eval revision=\${system_revision}
eval SYS_Rate=\${system_cpuusage}
eval TOTAL_MEM=\${system_memsize}
#eval FREE_MEM=\${system_memusage}
eval REM_Rate=\${system_memusage}

mtd fw_printenv 1 >> /data/eeprom_uboot_version

eeprom_version=`grep 'ver_eeprom' /data/eeprom_uboot_version`
variable=${eeprom_version%%=*}
tmp=${eeprom_version#$variable}
ver_eeprom=${tmp#=}

uboot_version=`grep 'ver_uboot' /data/eeprom_uboot_version`
variable=${uboot_version%%=*}
tmp=${uboot_version#$variable}
ver_uboot=${tmp#=}

rm /data/eeprom_uboot_version
uptime=$(cat /proc/uptime  | cut -d' ' -f 1 | cut -d'.' -f 1)

day=$(expr $uptime / 86400)
hour=$(expr $uptime % 86400 / 3600)
minutes=$(expr $uptime % 3600 / 60)
seconds=$(expr $uptime % 60)

echo
echo "Model               : " $model
echo "Hardware Version    : " $hardware
echo "Firmware Version    : " $firmware
echo "Build Date&Time     : " $build_date $build_time
echo "Revision            : " $revision
echo "System up Time      : " $day days $hour hours $minutes minutes $seconds seconds
echo "CPU usage           : " $SYS_Rate%
echo "Memory Size         : " $TOTAL_MEM
#echo "Memory Usage        : " $(expr 100 - $FREE_MEM "*" 100 / $TOTAL_MEM)%
echo "Memory Usage        : " $REM_Rate%
echo "Current System Time : " $(date -R)
echo "EEPROM Version      : " $ver_eeprom
echo "Bootloader Version  : " $ver_uboot
echo

