#!/bin/sh

interface=$1
host_ip=$2
port=$3
expression=$4

if [ "$interface" == "" ] || [ "$host_ip" == "" ] || [ "$port" == "" ];then
    echo ""
    echo "usage: rc <Interface> <Local Host IP> <Port> [Expression]"
    echo "  example: rc wan-wan1 [local PC IP] 12345"
    echo ""
    echo "ATTENTION: user MUST install netcat and run wireshark on local PC first."
    echo "  example: nc -l -p 12345 | \"C:\Program Files\Wireshark\wireshark.exe\" -ki - "
    echo ""
    echo "netcat download: http://joncraton.org/blog/46/netcat-for-windows/"
    echo ""
    return
fi
	
echo " enter 'ctrl + c' to END "
expression=$(echo $expression | sed 's/_/ /g')

tcpdump -s 0 -i $interface -w - $expression | nc $host_ip $port 
