#!/bin/sh

#scheduled by /etc/cron-job: backup snapshot of iptables in
#/tmp/iptables.hourly
#/tmp/iptalbes.daily
#/tmp/iptalbes.weekly

IPTABLE_H_NEW=/tmp/debug/iptables.hourly_new
IPTABLE_H_LAS=/tmp/debug/iptables.hourly_last
IPTABLE_D_NEW=/tmp/debug/iptables.daily_new
IPTABLE_D_LAS=/tmp/debug/iptables.daily_last
IPTABLE_W_NEW=/tmp/debug/iptables.weekly_new
IPTABLE_W_LAS=/tmp/debug/iptables.weekly_last

IPSET_H_NEW=/tmp/debug/ipset.hourly_new
IPSET_H_LAS=/tmp/debug/ipset.hourly_last
IPSET_D_NEW=/tmp/debug/ipset.daily_new
IPSET_D_LAS=/tmp/debug/ipset.daily_last
IPSET_W_NEW=/tmp/debug/ipset.weekly_new
IPSET_W_LAS=/tmp/debug/ipset.weekly_last


[ -d "/tmp/debug/" ] || mkdir /tmp/debug/

[ -f $IPTABLE_H_NEW ] || touch $IPTABLE_H_NEW
[ -f $IPTABLE_H_LAS ] || touch $IPTABLE_H_LAS
[ -f $IPTABLE_D_NEW ] || touch $IPTABLE_D_NEW
[ -f $IPTABLE_D_LAS ] || touch $IPTABLE_D_LAS
[ -f $IPTABLE_W_NEW ] || touch $IPTABLE_W_NEW
[ -f $IPTABLE_W_LAS ] || touch $IPTABLE_W_LAS

[ -f $IPSET_H_NEW ] || touch $IPSET_H_NEW
[ -f $IPSET_H_LAS ] || touch $IPSET_H_LAS
[ -f $IPSET_D_NEW ] || touch $IPSET_D_NEW
[ -f $IPSET_D_LAS ] || touch $IPSET_D_LAS
[ -f $IPSET_W_NEW ] || touch $IPSET_W_NEW
[ -f $IPSET_W_LAS ] || touch $IPSET_W_LAS


hourly()
{
	#backup last time snapshot
	cat $IPTABLE_H_NEW > $IPTABLE_H_LAS
	cat $IPSET_H_NEW > $IPSET_H_LAS
	#make new snapshot
	/usr/sbin/iptables-save -c > $IPTABLE_H_NEW &
	/usr/sbin/ipset -S > $IPSET_H_NEW &
	logger "Hourly firewall iptables snapshot done"
}

daily()
{
	#backup last time snapshot
	cat $IPTABLE_D_NEW > $IPTABLE_D_LAS
	cat $IPSET_D_NEW > $IPSET_D_LAS
	#make new snapshot
	/usr/sbin/iptables-save -c > $IPTABLE_D_NEW &
	/usr/sbin/ipset -S > $IPSET_D_NEW &
	logger "Daily firewall iptables snapshot done"
}

weekly()
{
	#backup last time snapshot
	cat $IPTABLE_W_NEW > $IPTABLE_W_LAS
	cat $IPSET_W_NEW > $IPSET_W_LAS
	#make new snapshot
	/usr/sbin/iptables-save -c > $IPTABLE_W_NEW &
	/usr/sbin/ipset -S > $IPSET_W_NEW &
	logger "Weekly firewall iptables snapshot done"
}

case "$1" in 
"hourly")
	hourly
;;
"daily")
	daily
;;
"weekly")
	weekly
;;
*)
;;
esac