########################## Architecture Decription ##############################
# directory: /tmp/profile_backup/$(hash table directory)/
# file: /tmp/profile_backup/$(hash table directory)/pro_$(profile name) ....
# file contain: $(hash key1)@$(value section)
#				$(hash key2)@$(value section)
########################## Argument Decription ##############################
# $1: directory name, ex: function name or script name (must be unique)
# $2: hash table name, ex: profile's name (must be unique)
# $3: hash key, ex: rule index (must be unique)
# $4: value, ex: the rule's contents
# dont use '@' character in $3(hash key), it will conflict the split char
########################## Functions Desciption #############################
#ht_init(): create/reset directory
#ht_rm_dir(): remove entire directory
#ht_rm_file(): remove a file in the directory
#ht_rename_file(): rename a file the directory: require: $1,$2(old name),$3(new_name)
#ht_put(): create dir then save an entry into the file
#ht_get(): retrieve the data value from a specific entry
#ht_del_entry(): remove the specific entry in the file: require $1,$2,$3
#ht_replace_entry(): replace the value of a specific entry in the file: require $1,$2,$3,$4
#ht_test(): return 0 if target file exists, else return 1.
#ht_find_word_in_profiles(): look into every file with prefix "pro_" in the directory,
#		return a list of filenames(remove prefix:pro_) whose value section contains the search keyword
#############################################################################
DEBUG_LOG=logger

ht_init() {
	if [ ! -d "/tmp/profile_backup/$1" ] ;then
		mkdir /tmp/profile_backup/$1
	else
		rm -fr /tmp/profile_backup/$1
		mkdir /tmp/profile_backup/$1
	fi
}

ht_rm_dir() {
	if [ -d "/tmp/profile_backup/$1" ] ;then
		rm -fr /tmp/profile_backup/$1
	#else
	#	$DEBUG_LOG "ht_rm_dir(notice): directory:/tmp/profile_backup/$1 not found" 2>/dev/null
	fi
}

ht_rm_file() {
	if [ -f "/tmp/profile_backup/$1/pro_$2" ] ;then
		rm -f /tmp/profile_backup/$1/pro_$2 2>/dev/null
	#else
	#	$DEBUG_LOG "ht_rm_file(notice): file:/tmp/profile_backup/$1/pro_$2 not found" 2>/dev/null
	fi
}

ht_rename_file() {
	if [ -f "/tmp/profile_backup/$1/pro_$2" ] ;then
		mv /tmp/profile_backup/$1/pro_$2 /tmp/profile_backup/$1/pro_$3
	#else
	#	$DEBUG_LOG "ht_rename_file(error): file:/tmp/profile_backup/$1/pro_$2 not found" 2>/dev/null
	fi
}

ht_put() {
	[ ! -d "/tmp/profile_backup/$1" ] && mkdir /tmp/profile_backup/$1
	echo "$3@$4" >> /tmp/profile_backup/$1/pro_$2
}

ht_get() {
	if [ -f "/tmp/profile_backup/$1/pro_$2" ] ;then
		grep "^$3@" /tmp/profile_backup/$1/pro_$2 | awk -F"@" '{ print $2 }'
	#else
	#	$DEBUG_LOG "ht_get(error): file:/tmp/profile_backup/$1/pro_$2 not found" 2>/dev/null
	fi
}

ht_del_entry() {
	if [ -f "/tmp/profile_backup/$1/pro_$2" ] ;then
		sed -i '/'$3@'/d' /tmp/profile_backup/$1/pro_$2
	#else
	#	$DEBUG_LOG "ht_del_entry(error): file:/tmp/profile_backup/$1/pro_$2 not found" 2>/dev/null
	fi
}

ht_replace_entry() {
	if [ -f "/tmp/profile_backup/$1/pro_$2" ] ;then
		sed -i '/'$3@'/d' /tmp/profile_backup/$1/pro_$2
		echo "$3@$4" >> /tmp/profile_backup/$1/pro_$2
	#else
	#	$DEBUG_LOG "ht_replace_entry(error): file:/tmp/profile_backup/$1/pro_$2 not found" 2>/dev/null
	fi
}

ht_test() {
	if [ -f "/tmp/profile_backup/$1/pro_$2" ] ;then
		echo 0 
	else
		echo 1
	fi
}

#$1: table directory name
#$2: hash key
#$3: data value of hash key
ht_find_word_in_profiles() {
	local ht_ret_file_list=""
	local ret_name=""
	if [ -d "/tmp/profile_backup/$1" ] ;then
		all_profile=`ls /tmp/profile_backup/$1 |grep "^pro_"`
		#echo "ht_find_word_in_profiles: all_profile=$all_profile" >/dev/console
		for item in $all_profile ;do
			get_value=`grep "^$2@" /tmp/profile_backup/$1/$item | awk -F"@" '{ print $2 }'`
			#echo "item=$item: get_value=$get_value, param3=$3" >/dev/console
			if [ "$get_value" = "$3" ] ;then
				#found matched profile! remove its prefix "pro_"
				ret_name=${item#pro_}
				ht_ret_file_list="$ret_name $ht_ret_file_list"
				#echo "item=$item: match!! list=$ht_ret_file_list" >/dev/console
			fi
		done
		echo "$ht_ret_file_list"
	else
		#$DEBUG_LOG "ht_find_word_in_profiles(error): dir:/tmp/profile_backup/$1 not found" 2>/dev/null
		echo "$ht_ret_file_list"
	fi
}