#!/bin/sh
BIN=/usr/bin/ether-wake

if   [ `echo $1 | grep -E ^\([0-9a-fA-F]{2}:\){5}[0-9a-fA-F]{2}$` ]; then
	##### $1 is a MAC address	
	$BIN -i lan-$2 $1 2>/dev/null	
else
	##### convert IP to MAC
	mac=`cat /etc/ethers | grep "$1 " | awk '{print $2}'`		
	$BIN -i lan-$2 $mac 2>/dev/null || {
		echo "MAC or IP address is invalid."
		return 1
	}
fi

echo "Send command to client done."
return 0
