#!/bin/sh
function=$1
parameter=$2
WriteToFile=$3

func_dir=/sbin/debug_collector
file_dir=/tmp/dray_debug
src_package=/tmp/debug_log_file.tar.gz
link=/www/debug_file.tar.gz

# This script is to call other debug script in telnet "debug" function.
# If you want add new one:
#   1.Please add your new debug script in package\base-files\files\sbin\debug_collector

debug_script_list=`ls $func_dir`

#prevent user input ".." and "/" (replace it to NULL)
function=`echo $function | sed 's/\.\.//g'`
function=`echo $function | sed 's/\///g'`

#==============================================
#when no 'parameter' or reverse
if [ "$parameter" == "tofile" ];then
	parameter="$WriteToFile"
	WriteToFile="tofile"
#when no 'tofile'
elif [ "$parameter" != "tofile" ] && [ "$WriteToFile" != "tofile" ];then
	parameter="${WriteToFile} ${parameter}"
	WriteToFile=""
fi
#==============================================

#if many parameter ,use # connect. example: function P1#P2#P3 (replace \# to space)
parameter=`echo $parameter | sed 's/\\\#/ /g'`

#if no function ,list all
if [ "$function" == "" ];then
	echo Function: $debug_script_list

#Only for "db_to_web"
elif [ "$function" == "ALL_IN_ONE" ];then
	for tmp in $debug_script_list
	do 
		echo "Do $tmp..."
		$func_dir/$tmp > $file_dir/$tmp.log
		echo "$tmp done"
	done
	tar -zcf $src_package tmp/dray_debug
	ln -sf $src_package $link

	rm -rf $file_dir
	mkdir $file_dir

	echo "done!"
	echo "Download http://[Router IP]/debug_file.tar.gz"

#if "all" ,do all function
elif [ "$function" == "all" ];then
	if [ "$WriteToFile" == "tofile" ];then
		for tmp in $debug_script_list
		do
			echo "Do $tmp..."
			$func_dir/$tmp > $file_dir/$tmp.log
			echo "$tmp done"
		done
	else
		for tmp in $debug_script_list
		do
			echo "Do $tmp..."
			$func_dir/$tmp
			echo "$tmp done"
		done
	fi
#one function
else
	#function exist
	if [ -f "$func_dir/$function" ];then
		if [ "$WriteToFile" == "tofile" ];then
			$func_dir/$function $parameter > $file_dir/$function.log
		else
			$func_dir/$function $parameter
		fi
	#function not exist
	else
		echo "Wrong function name."
	fi
fi

return 0