#!/bin/sh
append DRIVERS "atherosmb81"

scan_atherosmb81() {
	local device="$1"
	local wds
	local adhoc sta ap
	
	config_get vifs "$device" vifs
#	for vif in $vifs; do
	for vif in iface1 iface2 iface3; do
	
		config_get ifname "$vif" ifname
		config_set "$vif" ifname "${ifname:-ath}"
		
#		config_get mode "$vif" mode
mode=ap
		case "$mode" in
			adhoc|ahdemo|sta|ap)
				append $mode "$vif"
			;;
			wds)
				config_get addr "$vif" bssid
				config_get ssid "$vif" ssid
				[ -z "$addr" -a -n "$ssid" ] && {
					config_set "$vif" wds 1
					config_set "$vif" mode sta
					mode="sta"
					addr="$ssid"
				}
				${addr:+append $mode "$vif"}
			;;
			*) echo "$device($vif): Invalid mode, ignored."; continue;;
		esac
	done

	case "${adhoc:+1}:${sta:+1}:${ap+1}" in
		# valid mode combinations
		1::) wds="";;
		1::1);;
		:1:1)config_set "$device" nosbeacon 1;; # AP+STA, can't use beacon timers for STA
		:1:);;
		::1);;
		::);;
		*) echo "$device: Invalid mode combination in config"; return 1;;
	esac

	config_set "$device" vifs "${ap:+$ap }${adhoc:+$adhoc }${ahdemo:+$ahdemo }${sta:+$sta }${wds:+$wds }"
}


disable_atherosmb81() (
	local device="$1"

	# kill all running hostapd and wpa_supplicant processes that
	# are running on atheros vifs 
	for pid in `pidof hostapd wpa_supplicant`; do
		grep ath /proc/$pid/cmdline >/dev/null && \
			kill $pid
	done
	
	include /lib/network
	cd /proc/sys/net
	for dev in *; do
		grep "$device" "$dev/%parent" >/dev/null 2>/dev/null && {
			ifconfig "$dev" down 
			unbridge "$dev"
			wlanconfig "$dev" destroy
		}
	done
	return 0
)

enable_atherosmb81() {
	config_get channel "$device" channel
	config_get vifs "$device" vifs
	disable_atherosmb81 "$device"
	local first=1

	ifconfig wifi0 txqueuelen 1000
#	for vif in $vifs; do
	for vif in wifi0 iface1 iface2 iface3; do
		config_get disable "$vif" disabled
if [ "$disable" = "0" ]; then
		nosbeacon=
		config_get ifname "$vif" ifname
		config_get rate "$vif" rate
		config_get frag "advance" fr_threshold
		config_get rts "advance" rts_threshold
#		config_get mode "$vif" mode
mode=ap	
		
#		[ "$mode" = sta ] && config_get nosbeacon "$device" nosbeacon
		
		config_get ifname "$vif" ifname
		ifname=$(wlanconfig "$ifname" create wlandev "$device" wlanmode "$mode" ${nosbeacon:+nosbeacon})
		[ $? -ne 0 ] && {
			echo "enable_atheros($device): Failed to set up $mode vif $ifname" >&2
			continue
		}
		config_set "$vif" ifname "$ifname"
                deviceid=`cat /sys/class/net/wifi0/device/device`

		[ "$first" = 1 ] && {
			# only need to change freq band and channel on the first vif
			config_get agnmode "$device" mode
			iwconfig "$ifname" channel 0
			iwpriv "$ifname" pureg 0
			pureg=0
			shortgi=0
			cwmmode=0

			case "$agnmode" in
				*a)
					agnmode=11A
					;;
				*b)
					agnmode=11B
					;;
				11bg)
					agnmode=11G
					;;
				11g)
					agnmode=11G
					pureg=1
					;;
				*n)
					if [ "$deviceid" = 0x0023 ] || [ "$deviceid" = 0x0024 ] || [ "$deviceid" = 0x0027 ] || [ "$deviceid" = 0xff1c ] || [ "$deviceid" = 0x002a ]; then
			
						case "$agnmode" in
							11an)
								config_get channel_width ${device} channel_width
								case "$channel_width" in
									20)
										shortgi=1
										cwmmode=0
										agnmode=11NAHT20
									;;
									*|40)
										shortgi=1
										cwmmode=1
										agnmode=11NAHT40PLUS
									;;
								esac
							;;
							11gn|11bgn)
								config_get channel_width ${device} channel_width
								case "$channel_width" in
									20)
										shortgi=1
										cwmmode=0
										agnmode=11NGHT20
									;;
									*|40)
										shortgi=1
										cwmmode=1
										agnmode=11NGHT40PLUS
									;;
								esac
							;;
						esac
					else
						agnmode=11G
							
					fi

			      		
	
	
					;;
				*)
					agnmode=auto
					;;
			esac
				
		
			

			case "$agnmode" in
				11N*)
				frag="off"
				rts="off"
				iwpriv ath0 disablecoext 1
				# Enabling shorr gaurd interval
				iwpriv "$ifname" shortgi "$shortgi"
				iwpriv "$ifname" cwmmode "$cwmmode"
				;;
			esac	

			# Setting mode				
			iwpriv "$ifname" mode "$agnmode"
			
#     			iwpriv "$ifname" doth 0
				
			#Setting channel frequency
			iwconfig "$ifname" channel "$channel"

			case "$agnmode" in
				11N*)
				#Setting extension channel 
				config_get channel_ext ${device} channel_ext
				case "$channel_ext" in
# Observed that, extension chennel offset -1 is not working. 				
#					0)
#					iwpriv "$ifname" extoffset -1
#					;;
					*|1)
					iwpriv "$ifname" extoffset +1
					;;
				esac

				#Setting extension channel width to 20MHZ
		      		iwpriv "$ifname" extprotspac 0
				
	
				
				#Enabling HT Element for intel interoperability
			     	echo 1 > /proc/sys/dev/ath/htdupieenable
			esac


			ifconfig "$ifname" txqueuelen 1000
				
			ifconfig "$ifname" up

		
	

		}
	
#		iwconfig "$ifname" rate "$rate" >/dev/null 2>/dev/null 
		iwconfig "$ifname" rts "$rts" >/dev/null 2>/dev/null 
		iwconfig "$ifname" frag "$frag" >/dev/null 2>/dev/null 
		iwpriv "$ifname" mcast_rate 36000
	
		config_get_bool hidden "$vif" hidden 0
		iwpriv "$ifname" hide_ssid "$hidden"

#		config_get_bool ff "$vif" ff 0
#		iwpriv "$ifname" ff "$ff"

#		config_get wds "$vif" wds
#		case "$wds" in
#			1|on|enabled) wds=1;;
#			*) wds=0;;
#		esac
#		iwpriv "$ifname" wds "$wds"

		wpa=
#		case "$enc" in

#			WEP|wep)
#				iwpriv "$ifname" authmode 2
		config_get auth "$vif" auth
		config_get enc "$vif" encryption
		case "$auth" in
		open|shared)
			case "$enc" in
			WEP|wep)
				case "$auth" in
				open)
					$DEBUG iwpriv "$ifname" authmode 1
					;;
				shared)
					$DEBUG iwpriv "$ifname" authmode 2
					;;
				esac
				for idx in 1; do
					config_get key "$vif" "key${idx}"
					iwconfig "$ifname" key "[$idx]" "${key:-off}"
				done
				config_get key "$vif" key
				key="${key:-1}"
				case "$key" in
					*)
						iwconfig "$ifname" key "[$key]"
					;;
				esac
			;;
			esac
		;;
		*)
			config_get key "$vif" key
		;;
		esac
#			PSK|psk|PSK2|psk2)
#				config_get key "$vif" key
#			;;
#		esac

		case "$mode" in
			wds)
				config_get addr "$vif" bssid
				iwpriv "$ifname" wds_add "$addr"
			;;
			adhoc|ahdemo)
				config_get addr "$vif" bssid
				[ -z "$addr" ] || { 
					iwconfig "$ifname" ap "$addr"
				}
			;;
		esac
		config_get ssid "$vif" ssid

		[ "$mode" = "sta" ] && {
			config_get_bool bgscan "$vif" bgscan 1
			iwpriv "$ifname" bgscan "$bgscan"
		}

#		config_get_bool antdiv "$device" diversity 1
#		sysctl -w dev."$device".diversity="$antdiv" >&-

#		config_get antrx "$device" rxantenna
#		if [ -n "$antrx" ]; then
#			sysctl -w dev."$device".rxantenna="$antrx" >&-
#		fi

#		config_get anttx "$device" txantenna
#		if [ -n "$anttx" ]; then
#			sysctl -w dev."$device".txantenna="$anttx" >&-
#		fi
#
#		config_get distance "$device" distance
#		if [ -n "$distance" ]; then
#			athctrl -i "$device" -d "$distance" >&-
#		fi
#
#		config_get txpwr "$vif" txpower
#		if [ -n "$txpwr" ]; then
#			iwconfig "$ifname" txpower "${txpwr%%.*}"
#		fi
	
		
		config_get ipaddr ${device} ipaddr
		if [ -n "$ipaddr" ]; then
			ifconfig ${ifname} $ipaddr
		fi
	
		config_get netmask ${device} netmask
		if [ -n "$netmask" ]; then
			ifconfig ${ifname} netmask $netmask up
		fi


		local net_cfg bridge
		net_cfg="$(find_net_config "$vif")"
		[ -z "$net_cfg" ] || {
			bridge="$(bridge_interface "$net_cfg")"
			config_set "$vif" bridge "$bridge"
			start_net "$ifname" "$net_cfg"
		}
		iwconfig "$ifname" essid "$ssid"
		case "$mode" in
			ap)
				config_get_bool isolate "$vif" isolate 0
				iwpriv "$ifname" ap_bridge "$((isolate^1))"

				if eval "type hostapd_setup_vif" 2>/dev/null >/dev/null; then
					hostapd_setup_vif "$vif" madwifi || {
						echo "enable_atheros($device): Failed to set up wpa for interface $ifname" >&2
						# make sure this wifi interface won't accidentally stay open without encryption
						ifconfig "$ifname" down
						wlanconfig "$ifname" destroy
						continue
					}
				fi
			;;
#			wds|sta)
#				case "$enc" in 
#					PSK|psk|PSK2|psk2)
#						case "$enc" in
#							PSK|psk)
#								proto='proto=WPA';;
#							PSK2|psk2)
#								proto='proto=RSN';;
#						esac
#						cat > /var/run/wpa_supplicant-$ifname.conf <<EOF
#ctrl_interface=/var/run/wpa_supplicant
#network={
#	scan_ssid=1
#	ssid="$ssid"
#	key_mgmt=WPA-PSK
#	$proto
#	psk="$key"
#}
#EOF
#					;;
#					WPA|wpa|WPA2|wpa2)
#						#add wpa_supplicant calls here
#					;;
#				esac
#				[ -z "$proto" ] || wpa_supplicant ${bridge:+ -b $bridge} -Bw -D wext -i "$ifname" -c /var/run/wpa_supplicant-$ifname.conf
#			;;
		esac
		fi
	first=0
	done
}


detect_atherosmb81() {
	cd /sys/class/net
	#[ -d ath ] || return
	for dev in $(ls -d wifi* 2>&-); do
		uci set wireless.${dev}.type=atherosmb81
		uci commit wireless
	done
found=`uci get wireless.general.found`
if [ "$found" = "0" ]; then
	cd /sys/class/net
	ls -d wifi* 2>&-
	if [ "$?" = "0" ]; then
echo "Atheros card found"
	uci set wireless.general.found=1
	uci set wireless.general.type=wifi0
	uci set wireless.general.card=1
	uci commit wireless
	else
	uci set wireless.general.card=0
	uci commit wireless
	fi
fi
}
