#!/bin/sh
append DRIVERS "atheros"

scan_atheros() {
	local device="$1"
}


disable_atheros() (
	local device="$1"

	cd /proc/sys/net
	for dev in *; do
		grep ${device} "$dev/%parent" >/dev/null 2>/dev/null && {
			ifconfig "$dev" down 
			wlanconfig "$dev" destroy
		}
	done

	return 0
)

enable_atheros() {
for device in wifi0 iface1 iface2 iface3; do
	config_get disabled "${device}" disabled
	if [ "$disabled" = "0" ]; then
	
		config_get channel ${device} channel
		
		disable_atheros ${device}
	
		config_get mode ${device} mode
	
		ifname=`wlanconfig ath0 create wlandev ${device} wlanmode ap`
	
			[ $? -ne 0 ] && {
		echo "enable_atheros($device): Failed to set up ${mode} vif $ifname" >&2
			exit
		}
	
		iwpriv ${ifname} wds 0
		iwpriv ${ifname} bgscan 0
	
		case ${mode} in
		*n)
			iwpriv ${ifname} mode 11ng
	
			iwpriv ${ifname} shortgi 1
	
			if [ ${mode} == "11gn" ]; then
				echo 1 > /proc/sys/dev/ath/hal/forceBiasAuto
			fi
		
			config_get ch_width ${device} ch_width
			case "$ch_width" in
			20)
				iwpriv ${ifname} cwmmode 0
					;;
	
			*|40)
				iwpriv ${ifname} cwmmode 2
					;;
			esac
	
			config_get ext_ch ${device} ext_ch
			case "$ext_ch" in
			0)
				iwpriv ${ifname} extoffset -1
				;;
	
			*|1)
				iwpriv ${ifname} extoffset +1
				;;
			esac
	
		        iwpriv ${ifname} extprotspac 0
	
			;;
		*)
		        iwpriv ${ifname} countryie 1
       	 	iwpriv ${ifname} doth 0
			;;
		esac
	
		config_get channel ${device} channel
		iwconfig ${ifname} channel ${channel}
	
		config_get ssid ${device} ssid
		iwconfig ${ifname} essid ${ssid}
	
		ifconfig ${ifname} up
		
		config_get ipaddr ${device} ipaddr
		if [ -n "$ipaddr" ]; then
			ifconfig ${ifname} $ipaddr
		fi
	
		config_get netmask ${device} netmask
		if [ -n "$netmask" ]; then
			ifconfig ${ifname} netmask $netmask
		fi
	
		config_get enc ${device} encryption
		case "$enc" in
		WEP|wep)
			for idx in 1 2 3 4; do
				config_get key ${ifname} "key${idx}"
				iwconfig ${ifname} enc "[$idx]" "${key:-off}"
			done
	
			config_get key ${device} key
			key="${key:-1}"
			case "$key" in
				[1234]) iwconfig ${ifname} enc "[$key]";;
				*) iwconfig ${ifname} enc "$key";;
			esac
			;;
	
		PSK|psk|WPA|wpa)
			;;
	
		PSK2|psk2|WPA2|wpa2)
			;;
	
		*|open|OPEN)
			iwconfig ${ifname} enc off
			;;
		esac
	fi
done
}


detect_atheros() {
	cd /proc/sys/dev
	[ -d ath ] || return
	for dev in $(ls -d wifi* 2>&-); do
		uci set wireless.${dev}.type=atheros
		uci commit wireless
	done
found=`uci get wireless.general.found`
if [ "$found" = "0" ]; then
	cd /proc/sys/dev
	ls -d wifi* 2>&-
	if [ "$?" = "0" ]; then
echo "Atheros card found"
	uci set wireless.general.found=1
	uci set wireless.general.type=wifi0
	uci set wireless.general.card=1
	uci commit wireless
	else
	uci set wireless.general.card=0
	uci commit wireless
	fi
fi
}
