/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.ClassConstants;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.ConstantTag;

public class ConstantPool
extends Oop
implements ClassConstants {
    private static final boolean DEBUG = false;
    private static OopField tags;
    private static OopField operands;
    private static OopField cache;
    private static OopField poolHolder;
    private static CIntField length;
    private static long headerSize;
    private static long elementSize;
    private static int INDY_BSM_OFFSET;
    private static int INDY_ARGC_OFFSET;
    private static int INDY_ARGV_OFFSET;
    private static final String[] nameForTag;

    protected void debugMessage(String message) {
        System.out.println(message);
    }

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("constantPoolOopDesc");
        tags = new OopField(type.getOopField("_tags"), 0L);
        operands = new OopField(type.getOopField("_operands"), 0L);
        cache = new OopField(type.getOopField("_cache"), 0L);
        poolHolder = new OopField(type.getOopField("_pool_holder"), 0L);
        length = new CIntField(type.getCIntegerField("_length"), 0L);
        headerSize = type.getSize();
        elementSize = 0L;
        INDY_BSM_OFFSET = db.lookupIntConstant("constantPoolOopDesc::_indy_bsm_offset");
        INDY_ARGC_OFFSET = db.lookupIntConstant("constantPoolOopDesc::_indy_argc_offset");
        INDY_ARGV_OFFSET = db.lookupIntConstant("constantPoolOopDesc::_indy_argv_offset");
    }

    ConstantPool(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    @Override
    public boolean isConstantPool() {
        return true;
    }

    public TypeArray getTags() {
        return (TypeArray)tags.getValue(this);
    }

    public TypeArray getOperands() {
        return (TypeArray)operands.getValue(this);
    }

    public ConstantPoolCache getCache() {
        return (ConstantPoolCache)cache.getValue(this);
    }

    public Klass getPoolHolder() {
        return (Klass)poolHolder.getValue(this);
    }

    public int getLength() {
        return (int)length.getValue(this);
    }

    private long getElementSize() {
        if (elementSize != 0L) {
            return elementSize;
        }
        elementSize = VM.getVM().getOopSize();
        return elementSize;
    }

    private long indexOffset(long index) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(index > 0L && index < (long)this.getLength(), "invalid cp index " + index + " " + this.getLength());
        }
        return index * this.getElementSize() + headerSize;
    }

    public ConstantTag getTagAt(long index) {
        return new ConstantTag(this.getTags().getByteAt((int)index));
    }

    public CPSlot getSlotAt(long index) {
        return new CPSlot(this.getHandle().getAddressAt(this.indexOffset(index)));
    }

    public Oop getObjAtRaw(long index) {
        return this.getHeap().newOop(this.getHandle().getOopHandleAt(this.indexOffset(index)));
    }

    public Symbol getSymbolAt(long index) {
        CPSlot slot = this.getSlotAt(index);
        return slot.getSymbol();
    }

    public int getIntAt(long index) {
        return this.getHandle().getJIntAt(this.indexOffset(index));
    }

    public float getFloatAt(long index) {
        return this.getHandle().getJFloatAt(this.indexOffset(index));
    }

    public long getLongAt(long index) {
        int oneHalf = this.getHandle().getJIntAt(this.indexOffset(index + 1L));
        int otherHalf = this.getHandle().getJIntAt(this.indexOffset(index));
        return VM.getVM().buildLongFromIntsPD(oneHalf, otherHalf);
    }

    public double getDoubleAt(long index) {
        return Double.longBitsToDouble(this.getLongAt(index));
    }

    public int getFieldOrMethodAt(int which) {
        int i = -1;
        ConstantPoolCache cache = this.getCache();
        i = cache == null ? which : cache.getEntryAt(0xFFFF & VM.getVM().getBytes().swapShort((short)which)).getConstantPoolIndex();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isFieldOrMethod(), "Corrupted constant pool");
        }
        int res = this.getIntAt(i);
        return res;
    }

    public int[] getNameAndTypeAt(int which) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(which).isNameAndType(), "Corrupted constant pool");
        }
        int i = this.getIntAt(which);
        return new int[]{ConstantPool.extractLowShortFromInt(i), ConstantPool.extractHighShortFromInt(i)};
    }

    public Symbol getNameRefAt(int which) {
        int nameIndex = this.getNameAndTypeAt(this.getNameAndTypeRefIndexAt(which))[0];
        return this.getSymbolAt(nameIndex);
    }

    public Symbol getSignatureRefAt(int which) {
        int sigIndex = this.getNameAndTypeAt(this.getNameAndTypeRefIndexAt(which))[1];
        return this.getSymbolAt(sigIndex);
    }

    public Klass getKlassRefAt(int which) {
        if (!this.getTagAt(which).isKlass()) {
            return null;
        }
        return (Klass)this.getObjAtRaw(which);
    }

    public InstanceKlass getFieldOrMethodKlassRefAt(int which) {
        int refIndex = this.getFieldOrMethodAt(which);
        int klassIndex = ConstantPool.extractLowShortFromInt(refIndex);
        return (InstanceKlass)this.getKlassRefAt(klassIndex);
    }

    public Method getMethodRefAt(int which) {
        InstanceKlass klass = this.getFieldOrMethodKlassRefAt(which);
        if (klass == null) {
            return null;
        }
        Symbol name = this.getNameRefAt(which);
        Symbol sig = this.getSignatureRefAt(which);
        return klass.findMethod(name, sig);
    }

    public Field getFieldRefAt(int which) {
        InstanceKlass klass = this.getFieldOrMethodKlassRefAt(which);
        if (klass == null) {
            return null;
        }
        Symbol name = this.getNameRefAt(which);
        Symbol sig = this.getSignatureRefAt(which);
        return klass.findField(name, sig);
    }

    public int getNameAndTypeRefIndexAt(int index) {
        int refIndex = this.getFieldOrMethodAt(index);
        int i = ConstantPool.extractHighShortFromInt(refIndex);
        return i;
    }

    public int getNameRefIndexAt(int index) {
        int[] refIndex = this.getNameAndTypeAt(index);
        int i = refIndex[0];
        return i;
    }

    public int getSignatureRefIndexAt(int index) {
        int[] refIndex = this.getNameAndTypeAt(index);
        int i = refIndex[1];
        return i;
    }

    public int getMethodHandleIndexAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isMethodHandle(), "Corrupted constant pool");
        }
        int res = ConstantPool.extractHighShortFromInt(this.getIntAt(i));
        return res;
    }

    public int getMethodHandleRefKindAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isMethodHandle(), "Corrupted constant pool");
        }
        int res = ConstantPool.extractLowShortFromInt(this.getIntAt(i));
        return res;
    }

    public int getMethodTypeIndexAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isMethodType(), "Corrupted constant pool");
        }
        int res = this.getIntAt(i);
        return res;
    }

    public short[] getBootstrapSpecifierAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getTagAt(i).isInvokeDynamic(), "Corrupted constant pool");
        }
        int bsmSpec = ConstantPool.extractLowShortFromInt(this.getIntAt(i));
        TypeArray operands = this.getOperands();
        if (operands == null) {
            return null;
        }
        int basePos = VM.getVM().buildIntFromShorts(operands.getShortAt(bsmSpec * 2 + 0), operands.getShortAt(bsmSpec * 2 + 1));
        int argv = basePos + INDY_ARGV_OFFSET;
        short argc = operands.getShortAt(basePos + INDY_ARGC_OFFSET);
        int endPos = argv + argc;
        short[] values = new short[endPos - basePos];
        for (int j = 0; j < values.length; ++j) {
            values[j] = operands.getShortAt(basePos + j);
        }
        return values;
    }

    private String nameForTag(int tag) {
        switch (tag) {
            case 1: {
                return "JVM_CONSTANT_Utf8";
            }
            case 2: {
                return "JVM_CONSTANT_Unicode";
            }
            case 3: {
                return "JVM_CONSTANT_Integer";
            }
            case 4: {
                return "JVM_CONSTANT_Float";
            }
            case 5: {
                return "JVM_CONSTANT_Long";
            }
            case 6: {
                return "JVM_CONSTANT_Double";
            }
            case 7: {
                return "JVM_CONSTANT_Class";
            }
            case 8: {
                return "JVM_CONSTANT_String";
            }
            case 9: {
                return "JVM_CONSTANT_Fieldref";
            }
            case 10: {
                return "JVM_CONSTANT_Methodref";
            }
            case 11: {
                return "JVM_CONSTANT_InterfaceMethodref";
            }
            case 12: {
                return "JVM_CONSTANT_NameAndType";
            }
            case 15: {
                return "JVM_CONSTANT_MethodHandle";
            }
            case 16: {
                return "JVM_CONSTANT_MethodType";
            }
            case 18: {
                return "JVM_CONSTANT_InvokeDynamic";
            }
            case 0: {
                return "JVM_CONSTANT_Invalid";
            }
            case 100: {
                return "JVM_CONSTANT_UnresolvedClass";
            }
            case 104: {
                return "JVM_CONSTANT_UnresolvedClassInError";
            }
            case 101: {
                return "JVM_CONSTANT_ClassIndex";
            }
            case 102: {
                return "JVM_CONSTANT_UnresolvedString";
            }
            case 103: {
                return "JVM_CONSTANT_StringIndex";
            }
        }
        throw new InternalError("Unknown tag: " + tag);
    }

    @Override
    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(tags, true);
            visitor.doOop(cache, true);
            visitor.doOop(poolHolder, true);
            int length = this.getLength();
            block8: for (int index = 1; index < length; ++index) {
                byte ctag = this.getTags().getByteAt(index);
                switch (ctag) {
                    case 3: 
                    case 101: 
                    case 103: {
                        visitor.doInt(new IntField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        continue block8;
                    }
                    case 4: {
                        visitor.doFloat(new FloatField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        continue block8;
                    }
                    case 5: {
                        visitor.doLong(new LongField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        ++index;
                        continue block8;
                    }
                    case 6: {
                        visitor.doDouble(new DoubleField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        ++index;
                        continue block8;
                    }
                    case 1: 
                    case 7: 
                    case 100: 
                    case 102: 
                    case 104: {
                        visitor.doOop(new OopField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        continue block8;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 18: {
                        visitor.doInt(new IntField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                    }
                }
            }
        }
    }

    public void writeBytes(OutputStream os) throws IOException {
        byte cpConstType;
        HashMap<String, Short> utf8ToIndex = new HashMap<String, Short>();
        DataOutputStream dos = new DataOutputStream(os);
        TypeArray tags = this.getTags();
        int len = this.getLength();
        int ci = 0;
        for (ci = 1; ci < len; ++ci) {
            cpConstType = tags.getByteAt(ci);
            if (cpConstType == 1) {
                Symbol sym = this.getSymbolAt(ci);
                utf8ToIndex.put(sym.asString(), new Short((short)ci));
                continue;
            }
            if (cpConstType != 5 && cpConstType != 6) continue;
            ++ci;
        }
        block17: for (ci = 1; ci < len; ++ci) {
            cpConstType = tags.getByteAt(ci);
            switch (cpConstType) {
                case 1: {
                    dos.writeByte(cpConstType);
                    Symbol sym = this.getSymbolAt(ci);
                    dos.writeShort((short)sym.getLength());
                    dos.write(sym.asByteArray());
                    continue block17;
                }
                case 2: {
                    throw new IllegalArgumentException("Unicode constant!");
                }
                case 3: {
                    dos.writeByte(cpConstType);
                    dos.writeInt(this.getIntAt(ci));
                    continue block17;
                }
                case 4: {
                    dos.writeByte(cpConstType);
                    dos.writeFloat(this.getFloatAt(ci));
                    continue block17;
                }
                case 5: {
                    dos.writeByte(cpConstType);
                    long l = this.getLongAt(ci);
                    ++ci;
                    dos.writeLong(l);
                    continue block17;
                }
                case 6: {
                    dos.writeByte(cpConstType);
                    dos.writeDouble(this.getDoubleAt(ci));
                    ++ci;
                    continue block17;
                }
                case 7: {
                    dos.writeByte(cpConstType);
                    Klass refKls = (Klass)this.getObjAtRaw(ci);
                    String klassName = refKls.getName().asString();
                    Short s = (Short)utf8ToIndex.get(klassName);
                    dos.writeShort(s.shortValue());
                    continue block17;
                }
                case 100: 
                case 104: {
                    dos.writeByte(7);
                    String klassName = this.getSymbolAt(ci).asString();
                    Short s = (Short)utf8ToIndex.get(klassName);
                    dos.writeShort(s.shortValue());
                    continue block17;
                }
                case 8: {
                    dos.writeByte(cpConstType);
                    String str = OopUtilities.stringOopToString(this.getObjAtRaw(ci));
                    Short s = (Short)utf8ToIndex.get(str);
                    dos.writeShort(s.shortValue());
                    continue block17;
                }
                case 102: {
                    dos.writeByte(8);
                    String val = this.getSymbolAt(ci).asString();
                    Short s = (Short)utf8ToIndex.get(val);
                    dos.writeShort(s.shortValue());
                    continue block17;
                }
                case 9: 
                case 10: 
                case 11: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    short klassIndex = (short)ConstantPool.extractLowShortFromInt(value);
                    short nameAndTypeIndex = (short)ConstantPool.extractHighShortFromInt(value);
                    dos.writeShort(klassIndex);
                    dos.writeShort(nameAndTypeIndex);
                    continue block17;
                }
                case 12: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    short nameIndex = (short)ConstantPool.extractLowShortFromInt(value);
                    short signatureIndex = (short)ConstantPool.extractHighShortFromInt(value);
                    dos.writeShort(nameIndex);
                    dos.writeShort(signatureIndex);
                    continue block17;
                }
                case 15: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    short nameIndex = (short)ConstantPool.extractLowShortFromInt(value);
                    short signatureIndex = (short)ConstantPool.extractHighShortFromInt(value);
                    dos.writeShort(nameIndex);
                    dos.writeShort(signatureIndex);
                    continue block17;
                }
                case 18: {
                    dos.writeByte(cpConstType);
                    int value = this.getIntAt(ci);
                    short bsmIndex = (short)ConstantPool.extractLowShortFromInt(value);
                    short nameAndTypeIndex = (short)ConstantPool.extractHighShortFromInt(value);
                    dos.writeShort(bsmIndex);
                    dos.writeShort(nameAndTypeIndex);
                    continue block17;
                }
                default: {
                    throw new InternalError("unknown tag: " + cpConstType);
                }
            }
        }
        dos.flush();
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("ConstantPool for " + this.getPoolHolder().getName().asString());
    }

    @Override
    public long getObjectSize() {
        return ConstantPool.alignObjectSize(headerSize + (long)this.getLength() * this.getElementSize());
    }

    private static int extractHighShortFromInt(int val) {
        return val >> 16 & 0xFFFF;
    }

    private static int extractLowShortFromInt(int val) {
        return val & 0xFFFF;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ConstantPool.initialize(VM.getVM().getTypeDataBase());
            }
        });
        nameForTag = new String[0];
    }

    public class CPSlot {
        private Address ptr;

        CPSlot(Address ptr) {
            this.ptr = ptr;
        }

        CPSlot(Symbol sym) {
            this.ptr = sym.getAddress().orWithMask(1L);
        }

        public boolean isOop() {
            return (this.ptr.minus(null) & 1L) == 0L;
        }

        public boolean isMetaData() {
            return (this.ptr.minus(null) & 1L) == 1L;
        }

        public Symbol getSymbol() {
            if (this.isMetaData()) {
                return Symbol.create(this.ptr.xorWithMask(1L));
            }
            throw new InternalError("not a symbol");
        }

        public Oop getOop() {
            if (this.isOop()) {
                return VM.getVM().getObjectHeap().newOop(this.ptr.addOffsetToAsOopHandle(0L));
            }
            throw new InternalError("not an oop");
        }
    }
}

