/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux.sparc;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;

public final class LinuxSPARCCFrame
extends BasicCFrame {
    public static int SPARC_STACK_BIAS;
    private static int address_size;
    private Address pc;
    private Address sp;
    private LinuxDebugger dbg;

    public LinuxSPARCCFrame(LinuxDebugger dbg, Address sp, Address pc, int address_size) {
        super(dbg.getCDebugger());
        this.sp = sp;
        this.pc = pc;
        this.dbg = dbg;
        LinuxSPARCCFrame.address_size = address_size;
        SPARC_STACK_BIAS = address_size == 8 ? 2047 : 0;
    }

    @Override
    public ClosestSymbol closestSymbolToPC() {
        return this.dbg.lookup(this.dbg.getAddressValue(this.pc()));
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.sp;
    }

    @Override
    public CFrame sender() {
        if (this.sp == null) {
            return null;
        }
        Address nextSP = this.sp.getAddressAt(14 * address_size + SPARC_STACK_BIAS);
        if (nextSP == null) {
            return null;
        }
        Address nextPC = this.sp.getAddressAt(15 * address_size + SPARC_STACK_BIAS);
        if (nextPC == null) {
            return null;
        }
        return new LinuxSPARCCFrame(this.dbg, nextSP, nextPC, address_size);
    }
}

