/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.TableSheetCell;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TableSheet
extends JScrollPane {
    protected transient JTable table;
    private transient NodeTableModel tableModel;
    private transient TableSheetCell tableCell;

    public TableSheet() {
        this.tableModel = new NodeTableModel();
        this.initializeView();
    }

    public TableSheet(NodeTableModel nodeTableModel) {
        this.tableModel = nodeTableModel;
        this.initializeView();
    }

    private void initializeView() {
        this.table = this.createTable();
        this.initializeTable();
        this.setViewportView(this.table);
        this.setRequestFocusEnabled(false);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getBundle(TableSheet.class).getString("ACS_TableSheet"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(TableSheet.class).getString("ACSD_TableSheet"));
    }

    public void setNodes(Node[] nodeArray) {
        this.tableModel.setNodes(nodeArray);
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.tableModel.setProperties(propertyArray);
    }

    public final void setAutoResizeMode(int n) {
        this.table.setAutoResizeMode(n);
    }

    public final int getAutoResizeMode() {
        return this.table.getAutoResizeMode();
    }

    public final void setColumnPreferredWidth(int n, int n2) {
        this.table.getColumnModel().getColumn(n).setPreferredWidth(n2);
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
    }

    public final int getColumnPreferredWidth(int n) {
        return this.table.getColumnModel().getColumn(n).getPreferredWidth();
    }

    JTable createTable() {
        return new JTable();
    }

    private void initializeTable() {
        this.table.setModel(this.tableModel);
        this.tableCell = new TableSheetCell(this.tableModel);
        this.table.setDefaultRenderer(Node.Property.class, this.tableCell);
        this.table.setDefaultEditor(Node.Property.class, this.tableCell);
        this.table.getTableHeader().setDefaultRenderer(this.tableCell);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        if (UIManager.getColor("Panel.background") != null) {
            this.table.setBackground(UIManager.getColor("Panel.background"));
            this.table.setSelectionBackground(UIManager.getColor("Panel.background"));
        }
    }

    private static String getString(String string) {
        return NbBundle.getBundle(TableSheet.class).getString(string);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (null != this.tableCell) {
            this.tableCell.updateUI();
        }
    }

    private static final class EnablingScrollPaneLayout
    extends ScrollPaneLayout {
        JScrollPane dependentScrollPane;

        public EnablingScrollPaneLayout(JScrollPane jScrollPane) {
            this.dependentScrollPane = jScrollPane;
        }

        @Override
        public void layoutContainer(Container container) {
            JScrollPane jScrollPane;
            boolean bl;
            super.layoutContainer(container);
            Component component = this.viewport != null ? this.viewport.getView() : null;
            Dimension dimension = component != null ? component.getPreferredSize() : new Dimension(0, 0);
            Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(this.viewport.getSize()) : new Dimension(0, 0);
            boolean bl2 = component instanceof Scrollable && ((Scrollable)((Object)component)).getScrollableTracksViewportWidth();
            boolean bl3 = bl = !bl2 && dimension.width > dimension2.width;
            if (this.hsb != null) {
                this.hsb.setEnabled(bl);
            }
            if ((jScrollPane = (JScrollPane)container).getHorizontalScrollBarPolicy() != 32) {
                int n;
                int n2 = n = bl ? 32 : 30;
                if (n != this.dependentScrollPane.getHorizontalScrollBarPolicy()) {
                    this.dependentScrollPane.setHorizontalScrollBarPolicy(n);
                    this.dependentScrollPane.getViewport().invalidate();
                }
            }
        }
    }

    private static class CompoundScrollPane
    extends JPanel
    implements Scrollable {
        CompoundScrollPane() {
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }
    }

    static class ControlledTableView
    extends TableSheet {
        JScrollPane controllingView;
        Component header;
        JPanel compoundScrollPane;

        ControlledTableView(JScrollPane jScrollPane) {
            this.controllingView = jScrollPane;
            this.initializeView();
        }

        ControlledTableView(JScrollPane jScrollPane, NodeTableModel nodeTableModel) {
            super(nodeTableModel);
            this.controllingView = jScrollPane;
            this.initializeView();
        }

        @Override
        public boolean isValidateRoot() {
            return false;
        }

        @Override
        private void initializeView() {
            Component component = this.controllingView.getViewport().getView();
            this.controllingView.setViewportView(component);
            if (UIManager.getColor("Table.background") != null) {
                this.getViewport().setBackground(UIManager.getColor("Table.background"));
            }
            this.setVerticalScrollBar(this.controllingView.getVerticalScrollBar());
            EnablingScrollPaneLayout enablingScrollPaneLayout = new EnablingScrollPaneLayout(this.controllingView);
            this.setLayout(enablingScrollPaneLayout);
            enablingScrollPaneLayout.syncWithScrollPane(this);
            enablingScrollPaneLayout = new EnablingScrollPaneLayout(this);
            this.controllingView.setLayout(enablingScrollPaneLayout);
            enablingScrollPaneLayout.syncWithScrollPane(this.controllingView);
            this.table.setBorder(null);
            this.header = new JTable().getTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, " ", false, false, 0, 0);
            MouseDragHandler mouseDragHandler = new MouseDragHandler();
            this.header.addMouseListener(mouseDragHandler);
            this.header.addMouseMotionListener(mouseDragHandler);
        }

        @Override
        JTable createTable() {
            return new ATable();
        }

        JTable getTable() {
            return this.table;
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(null);
        }

        void setRowHeight(int n) {
            this.table.setRowHeight(n);
            this.getVerticalScrollBar().setUnitIncrement(n);
        }

        void setHeaderText(String string) {
            if (this.header instanceof JLabel) {
                ((JLabel)this.header).setText(string);
            }
        }

        void setControllingViewWidth(int n) {
            this.controllingView.setPreferredSize(new Dimension(n, 0));
        }

        int getControllingViewWidth() {
            return this.controllingView.getPreferredSize().width;
        }

        JComponent compoundScrollPane() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.header, "North");
            jPanel.add((Component)this.controllingView, "Center");
            this.compoundScrollPane = new CompoundScrollPane();
            this.compoundScrollPane.setLayout(new BorderLayout());
            this.compoundScrollPane.add((Component)jPanel, "Center");
            this.compoundScrollPane.add((Component)this, "East");
            return this.compoundScrollPane;
        }

        private class MouseDragHandler
        extends MouseInputAdapter {
            boolean dragging = false;
            int lastMouseX;

            MouseDragHandler() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                this.dragging = this.canResize(point);
                this.lastMouseX = point.x;
            }

            private void setCursor(Cursor cursor) {
                if (ControlledTableView.this.header.getCursor() != cursor) {
                    ControlledTableView.this.header.setCursor(cursor);
                }
            }

            private boolean canResize(Point point) {
                return point.x >= ControlledTableView.this.header.getSize().width - 3;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (this.canResize(mouseEvent.getPoint()) || this.dragging) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = this.lastMouseX - n;
                if (n2 == 0) {
                    return;
                }
                if (this.dragging) {
                    Dimension dimension = ControlledTableView.this.table.getPreferredScrollableViewportSize();
                    int n3 = ControlledTableView.this.compoundScrollPane.getWidth();
                    int n4 = ControlledTableView.this.table.getMinimumSize().width;
                    int n5 = dimension.width + n2 > n3 - 20 ? n3 - 20 : (dimension.width + n2 < n4 ? n4 : dimension.width + n2);
                    ControlledTableView.this.table.setPreferredScrollableViewportSize(new Dimension(n5, dimension.height));
                    this.lastMouseX -= n5 - dimension.width;
                    ControlledTableView.this.table.revalidate();
                    ControlledTableView.this.table.repaint();
                } else {
                    this.lastMouseX = n;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.dragging = false;
            }
        }

        private class ATable
        extends JTable {
            private boolean trytorevalidate = true;

            public ATable() {
                this.getActionMap().put("cancel", new OurCancelEditingAction());
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                if (this.getAutoResizeMode() != 0 && this.getParent() != null) {
                    Insets insets = this.getParent().getInsets();
                    Dimension dimension2 = this.getParent().getSize();
                    dimension.height = dimension2.height - insets.top - insets.bottom;
                }
                return dimension;
            }

            @Override
            public void setBounds(int n, int n2, int n3, int n4) {
                super.setBounds(n, n2, n3, n4);
                if (this.getAutoResizeMode() == 0) {
                    return;
                }
                if (this.trytorevalidate && n3 != this.getPreferredScrollableViewportSize().width) {
                    this.trytorevalidate = false;
                    ControlledTableView.this.compoundScrollPane.validate();
                    this.trytorevalidate = true;
                }
            }

            private class OurCancelEditingAction
            extends AbstractAction {
                OurCancelEditingAction() {
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    jTable.removeEditor();
                }

                @Override
                public boolean isEnabled() {
                    return ATable.this.isEditing();
                }
            }
        }
    }
}

