/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.CustomControlsContext;
import java2d.Java2Demo;
import java2d.Surface;
import java2d.Tools;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;

public class DemoPanel
extends JPanel {
    public Surface surface;
    public CustomControlsContext ccc;
    public Tools tools;
    public String className;

    public DemoPanel(Object object) {
        this.setLayout(new BorderLayout());
        try {
            if (object instanceof String) {
                this.className = (String)object;
                object = Class.forName(this.className).newInstance();
            }
            if (object instanceof Component) {
                this.add((Component)object);
            }
            if (object instanceof Surface) {
                this.surface = (Surface)object;
                this.tools = new Tools(this.surface);
                this.add("South", this.tools);
            }
            if (object instanceof CustomControlsContext) {
                this.ccc = (CustomControlsContext)object;
                Component[] componentArray = this.ccc.getControls();
                String[] stringArray = this.ccc.getConstraints();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.add(componentArray[i], stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(DemoPanel.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void start() {
        if (this.surface != null) {
            this.surface.startClock();
        }
        if (this.tools != null && this.surface != null && this.tools.startStopB != null && this.tools.startStopB.isSelected()) {
            this.surface.animating.start();
        }
        if (this.ccc != null && Java2Demo.ccthreadCB != null && Java2Demo.ccthreadCB.isSelected()) {
            this.ccc.handleThread(CustomControlsContext.State.START);
        }
    }

    public void stop() {
        if (this.surface != null) {
            if (this.surface.animating != null) {
                this.surface.animating.stop();
            }
            this.surface.bimg = null;
        }
        if (this.ccc != null) {
            this.ccc.handleThread(CustomControlsContext.State.STOP);
        }
    }

    public void setDemoBorder(JPanel jPanel) {
        int n = jPanel.getComponentCount() + 1 >= 3 ? 0 : 5;
        int n2 = (jPanel.getComponentCount() + 1) % 2 == 0 ? 0 : 5;
        EmptyBorder emptyBorder = new EmptyBorder(n, n2, 5, 5);
        SoftBevelBorder softBevelBorder = new SoftBevelBorder(0);
        this.setBorder(new CompoundBorder(emptyBorder, softBevelBorder));
    }
}

