/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ResetResultsAction
extends AbstractAction {
    public ResetResultsAction() {
        this.putValue("Name", NbBundle.getMessage(ResetResultsAction.class, (String)"LBL_ResetResultsAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(ResetResultsAction.class, (String)"HINT_ResetResultsAction"));
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/resetResults.png", (boolean)false));
        this.putValue("iconBase", "org/netbeans/modules/profiler/actions/resources/resetResults.png");
        this.updateEnabledState();
        ResultsManager.getDefault().addResultsListener(new ResultsListener(){

            @Override
            public void resultsAvailable() {
                ResetResultsAction.this.updateEnabledState();
            }

            @Override
            public void resultsReset() {
                ResetResultsAction.this.updateEnabledState();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            @Override
            public void run() {
                ResultsManager.getDefault().reset();
                try {
                    TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
                    if (targetAppRunner.targetJVMIsAlive()) {
                        targetAppRunner.resetTimers();
                    } else {
                        targetAppRunner.getProfilerClient().resetClientData();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
            }
        });
    }

    private void updateEnabledState() {
        this.setEnabled(ResultsManager.getDefault().resultsAvailable());
    }
}

