/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Arcs_Curves;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class BezierAnim
extends AnimatingControlsSurface {
    private static final int NUMPTS = 6;
    protected BasicStroke solid = new BasicStroke(10.0f, 0, 1);
    protected BasicStroke dashed = new BasicStroke(10.0f, 0, 1, 10.0f, new float[]{5.0f}, 0.0f);
    private float[] animpts = new float[12];
    private float[] deltas = new float[12];
    protected Paint fillPaint;
    protected Paint drawPaint;
    protected boolean doFill = true;
    protected boolean doDraw = true;
    protected GradientPaint gradient;
    protected BasicStroke stroke;

    public BezierAnim() {
        this.setBackground(Color.WHITE);
        this.gradient = new GradientPaint(0.0f, 0.0f, Color.RED, 200.0f, 200.0f, Color.YELLOW);
        this.fillPaint = this.gradient;
        this.drawPaint = Color.BLUE;
        this.stroke = this.solid;
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void animate(float[] fArray, float[] fArray2, int n, int n2) {
        float f = fArray[n] + fArray2[n];
        if (f <= 0.0f) {
            f = -f;
            fArray2[n] = (float)(Math.random() * 4.0 + 2.0);
        } else if (f >= (float)n2) {
            f = 2.0f * (float)n2 - f;
            fArray2[n] = -((float)(Math.random() * 4.0 + 2.0));
        }
        fArray[n] = f;
    }

    @Override
    public void reset(int n, int n2) {
        for (int i = 0; i < this.animpts.length; i += 2) {
            this.animpts[i + 0] = (float)(Math.random() * (double)n);
            this.animpts[i + 1] = (float)(Math.random() * (double)n2);
            this.deltas[i + 0] = (float)(Math.random() * 6.0 + 4.0);
            this.deltas[i + 1] = (float)(Math.random() * 6.0 + 4.0);
            if (this.animpts[i + 0] > (float)n / 2.0f) {
                this.deltas[i + 0] = -this.deltas[i + 0];
            }
            if (!(this.animpts[i + 1] > (float)n2 / 2.0f)) continue;
            this.deltas[i + 1] = -this.deltas[i + 1];
        }
        this.gradient = new GradientPaint(0.0f, 0.0f, Color.RED, (float)n * 0.7f, (float)n2 * 0.7f, Color.YELLOW);
    }

    @Override
    public void step(int n, int n2) {
        for (int i = 0; i < this.animpts.length; i += 2) {
            this.animate(this.animpts, this.deltas, i + 0, n);
            this.animate(this.animpts, this.deltas, i + 1, n2);
        }
    }

    @Override
    public void render(int n, int n2, Graphics2D graphics2D) {
        float[] fArray = this.animpts;
        int n3 = fArray.length;
        float f = fArray[n3 - 2];
        float f2 = fArray[n3 - 1];
        float f3 = fArray[0];
        float f4 = fArray[1];
        float f5 = (f3 + f) / 2.0f;
        float f6 = (f4 + f2) / 2.0f;
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo(f5, f6);
        for (int i = 2; i <= fArray.length; i += 2) {
            float f7 = (f5 + f3) / 2.0f;
            float f8 = (f6 + f4) / 2.0f;
            f = f3;
            f2 = f4;
            if (i < fArray.length) {
                f3 = fArray[i + 0];
                f4 = fArray[i + 1];
            } else {
                f3 = fArray[0];
                f4 = fArray[1];
            }
            f5 = (f3 + f) / 2.0f;
            f6 = (f4 + f2) / 2.0f;
            float f9 = (f + f5) / 2.0f;
            float f10 = (f2 + f6) / 2.0f;
            generalPath.curveTo(f7, f8, f9, f10, f5, f6);
        }
        generalPath.closePath();
        if (this.doDraw) {
            graphics2D.setPaint(this.drawPaint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(generalPath);
        }
        if (this.doFill) {
            if (this.fillPaint instanceof GradientPaint) {
                this.fillPaint = this.gradient;
            }
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(generalPath);
        }
    }

    public static void main(String[] stringArray) {
        BezierAnim.createDemoFrame(new BezierAnim());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        static final TexturePaint tp1;
        static final TexturePaint tp2;
        BezierAnim demo;
        static Paint[] drawPaints;
        static String[] drawName;
        static Paint[] fillPaints;
        String[] fillName = new String[]{"No Fill", "Green", "Green w/ Alpha", "Texture", "Gradient"};
        JMenu fillMenu;
        JMenu drawMenu;
        JMenuItem[] fillMI = new JMenuItem[fillPaints.length];
        JMenuItem[] drawMI = new JMenuItem[drawPaints.length];
        PaintedIcon[] fillIcons = new PaintedIcon[fillPaints.length];
        PaintedIcon[] drawIcons = new PaintedIcon[drawPaints.length];
        Font font = new Font("serif", 0, 10);

        public DemoControls(BezierAnim bezierAnim) {
            super(bezierAnim.name);
            int n;
            this.demo = bezierAnim;
            JMenuBar jMenuBar = new JMenuBar();
            this.add(jMenuBar);
            JMenuBar jMenuBar2 = new JMenuBar();
            this.add(jMenuBar2);
            this.drawMenu = jMenuBar.add(new JMenu("Draw Choice"));
            this.drawMenu.setFont(this.font);
            for (n = 0; n < drawPaints.length; ++n) {
                this.drawIcons[n] = new PaintedIcon(drawPaints[n]);
                this.drawMI[n] = this.drawMenu.add(new JMenuItem(drawName[n]));
                this.drawMI[n].setFont(this.font);
                this.drawMI[n].setIcon(this.drawIcons[n]);
                this.drawMI[n].addActionListener(this);
            }
            this.drawMenu.setIcon(this.drawIcons[1]);
            this.fillMenu = jMenuBar2.add(new JMenu("Fill Choice"));
            this.fillMenu.setFont(this.font);
            for (n = 0; n < fillPaints.length; ++n) {
                this.fillIcons[n] = new PaintedIcon(fillPaints[n]);
                this.fillMI[n] = this.fillMenu.add(new JMenuItem(this.fillName[n]));
                this.fillMI[n].setFont(this.font);
                this.fillMI[n].setIcon(this.fillIcons[n]);
                this.fillMI[n].addActionListener(this);
            }
            this.fillMenu.setIcon(this.fillIcons[fillPaints.length - 1]);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            for (n = 0; n < fillPaints.length; ++n) {
                if (!object.equals(this.fillMI[n])) continue;
                this.demo.doFill = true;
                this.demo.fillPaint = fillPaints[n];
                this.fillMenu.setIcon(this.fillIcons[n]);
                break;
            }
            for (n = 0; n < drawPaints.length; ++n) {
                if (!object.equals(this.drawMI[n])) continue;
                this.demo.doDraw = true;
                this.demo.drawPaint = drawPaints[n];
                this.demo.stroke = ((JMenuItem)object).getText().endsWith("Dash") ? this.demo.dashed : this.demo.solid;
                this.drawMenu.setIcon(this.drawIcons[n]);
                break;
            }
            if (object.equals(this.fillMI[0])) {
                this.demo.doFill = false;
            } else if (object.equals(this.drawMI[0])) {
                this.demo.doDraw = false;
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 36);
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                block3: for (JMenuItem jMenuItem : this.drawMI) {
                    jMenuItem.doClick();
                    for (JMenuItem jMenuItem2 : this.fillMI) {
                        jMenuItem2.doClick();
                        try {
                            Thread.sleep(3000L + (long)(Math.random() * 3000.0));
                        }
                        catch (InterruptedException interruptedException) {
                            continue block3;
                        }
                    }
                }
            }
            this.thread = null;
        }

        static {
            BufferedImage bufferedImage = new BufferedImage(2, 1, 1);
            bufferedImage.setRGB(0, 0, -16711936);
            bufferedImage.setRGB(1, 0, -65536);
            tp1 = new TexturePaint(bufferedImage, new Rectangle(0, 0, 2, 1));
            bufferedImage = new BufferedImage(2, 1, 1);
            bufferedImage.setRGB(0, 0, -16776961);
            bufferedImage.setRGB(1, 0, -65536);
            tp2 = new TexturePaint(bufferedImage, new Rectangle(0, 0, 2, 1));
            drawPaints = new Paint[]{new Color(0, 0, 0, 0), Color.BLUE, new Color(0, 0, 255, 126), Color.BLUE, tp2};
            drawName = new String[]{"No Draw", "Blue", "Blue w/ Alpha", "Blue Dash", "Texture"};
            fillPaints = new Paint[]{new Color(0, 0, 0, 0), Color.GREEN, new Color(0, 255, 0, 126), tp1, new GradientPaint(0.0f, 0.0f, Color.RED, 30.0f, 30.0f, Color.YELLOW)};
        }

        static class PaintedIcon
        implements Icon {
            Paint paint;

            public PaintedIcon(Paint paint) {
                this.paint = paint;
            }

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(this.paint);
                graphics2D.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
                graphics2D.setColor(Color.GRAY);
                graphics2D.draw3DRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1, true);
            }

            @Override
            public int getIconWidth() {
                return 12;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }
        }
    }
}

