/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.IdFunctionObject;
import sun.org.mozilla.javascript.internal.IdScriptableObject;
import sun.org.mozilla.javascript.internal.RhinoException;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.Undefined;

final class NativeError
extends IdScriptableObject {
    static final long serialVersionUID = -5338413581437645187L;
    private static final Object ERROR_TAG = "Error";
    private RhinoException stackProvider;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;

    NativeError() {
    }

    static void init(Scriptable scriptable, boolean bl) {
        NativeError nativeError = new NativeError();
        ScriptableObject.putProperty((Scriptable)nativeError, "name", (Object)"Error");
        ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "fileName", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)0);
        nativeError.exportAsJSClass(3, scriptable, bl);
    }

    static NativeError make(Context context, Scriptable scriptable, IdFunctionObject idFunctionObject, Object[] objectArray) {
        Scriptable scriptable2 = (Scriptable)idFunctionObject.get("prototype", (Scriptable)idFunctionObject);
        NativeError nativeError = new NativeError();
        nativeError.setPrototype(scriptable2);
        nativeError.setParentScope(scriptable);
        int n = objectArray.length;
        if (n >= 1) {
            ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)ScriptRuntime.toString(objectArray[0]));
            if (n >= 2) {
                ScriptableObject.putProperty((Scriptable)nativeError, "fileName", objectArray[1]);
                if (n >= 3) {
                    int n2 = ScriptRuntime.toInt32(objectArray[2]);
                    ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)n2);
                }
            }
        }
        return nativeError;
    }

    @Override
    public String getClassName() {
        return "Error";
    }

    public String toString() {
        Object object = NativeError.js_toString(this);
        return object instanceof String ? (String)object : super.toString();
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(ERROR_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ERROR_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return NativeError.make(context, scriptable, idFunctionObject, objectArray);
            }
            case 2: {
                return NativeError.js_toString(scriptable2);
            }
            case 3: {
                return NativeError.js_toSource(context, scriptable, scriptable2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public void setStackProvider(RhinoException rhinoException) {
        if (this.stackProvider == null) {
            this.stackProvider = rhinoException;
            try {
                this.defineProperty("stack", null, NativeError.class.getMethod("getStack", new Class[0]), NativeError.class.getMethod("setStack", Object.class), 0);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
        }
    }

    public Object getStack() {
        Object object = this.stackProvider == null ? NOT_FOUND : this.stackProvider.getScriptStackTrace();
        this.setStack(object);
        return object;
    }

    public void setStack(Object object) {
        if (this.stackProvider != null) {
            this.stackProvider = null;
            this.delete("stack");
        }
        this.put("stack", (Scriptable)this, object);
    }

    private static Object js_toString(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty(scriptable, "name");
        object = object == NOT_FOUND || object == Undefined.instance ? "Error" : ScriptRuntime.toString(object);
        Object object2 = ScriptableObject.getProperty(scriptable, "message");
        Object object3 = object2 == NOT_FOUND || object2 == Undefined.instance ? Undefined.instance : (String)object + ": " + ScriptRuntime.toString(object2);
        return object3;
    }

    private static String js_toSource(Context context, Scriptable scriptable, Scriptable scriptable2) {
        Object object = ScriptableObject.getProperty(scriptable2, "name");
        Object object2 = ScriptableObject.getProperty(scriptable2, "message");
        Object object3 = ScriptableObject.getProperty(scriptable2, "fileName");
        Object object4 = ScriptableObject.getProperty(scriptable2, "lineNumber");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(new ");
        if (object == NOT_FOUND) {
            object = Undefined.instance;
        }
        stringBuffer.append(ScriptRuntime.toString(object));
        stringBuffer.append("(");
        if (object2 != NOT_FOUND || object3 != NOT_FOUND || object4 != NOT_FOUND) {
            if (object2 == NOT_FOUND) {
                object2 = "";
            }
            stringBuffer.append(ScriptRuntime.uneval(context, scriptable, object2));
            if (object3 != NOT_FOUND || object4 != NOT_FOUND) {
                int n;
                stringBuffer.append(", ");
                if (object3 == NOT_FOUND) {
                    object3 = "";
                }
                stringBuffer.append(ScriptRuntime.uneval(context, scriptable, object3));
                if (object4 != NOT_FOUND && (n = ScriptRuntime.toInt32(object4)) != 0) {
                    stringBuffer.append(", ");
                    stringBuffer.append(ScriptRuntime.toString(n));
                }
            }
        }
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    private static String getString(Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object == NOT_FOUND) {
            return "";
        }
        return ScriptRuntime.toString(object);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block6: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 8) {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 3;
                } else if (c == 't') {
                    string2 = "toString";
                    n = 2;
                }
            } else if (n2 == 11) {
                string2 = "constructor";
                n = 1;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block6;
            n = 0;
        }
        return n;
    }
}

