/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.TrustedLibrariesSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;
import sun.security.action.OpenFileInputStreamAction;

public final class TrustedLibraries {
    private static TrustedLibraries INSTANCE = null;
    private static final String DIGEST_MANIFEST = "-DIGEST-MANIFEST";
    private final HashMap entries = new HashMap();
    private static long lastModified = 0L;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$jar$Attributes;

    public static TrustedLibraries getInstance() {
        return INSTANCE;
    }

    public static TrustedLibraries getInstance(File file) {
        return new TrustedLibraries(file);
    }

    private TrustedLibraries() {
        try {
            String string = Config.getUserTrustedLibrariesFile();
            String string2 = Config.getSystemTrustedLibrariesFile();
            File file = new File(string);
            File file2 = new File(string2);
            if (file.exists()) {
                this.setup(file);
                lastModified = file.lastModified();
            }
            if (file2.exists()) {
                this.setup(file2);
                long l = file2.lastModified();
                if (l > lastModified) {
                    lastModified = l;
                }
            }
        }
        catch (IOException iOException) {
            throw new TrustedLibrariesSyntaxException(iOException);
        }
    }

    private TrustedLibraries(File file) {
        try {
            this.setup(file);
        }
        catch (IOException iOException) {
            throw new TrustedLibrariesSyntaxException(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setup(File file) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            try {
                FileInputStream fileInputStream = AccessController.doPrivileged(new OpenFileInputStreamAction(file));
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                this.parse(bufferedReader);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            Object var5_5 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    private void setupTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(47, 47);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(35);
        streamTokenizer.eolIsSignificant(true);
    }

    private void parse(Reader reader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        this.setupTokenizer(streamTokenizer);
        while ((n = streamTokenizer.nextToken()) != -1) {
            if (n == 10) continue;
            if (n != -3) {
                throw new IOException("Unexpected token: " + streamTokenizer);
            }
            String string = streamTokenizer.sval;
            if (string.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST)) {
                this.parseJarEntry(streamTokenizer);
                continue;
            }
            throw new IOException("Unknown attribute `" + string + "', line " + streamTokenizer.lineno());
        }
    }

    private void parseColon(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        if (n != 58) {
            throw new IOException("Expected ':', read " + streamTokenizer);
        }
    }

    private void parseJarEntry(StreamTokenizer streamTokenizer) throws IOException {
        String string = streamTokenizer.sval;
        this.parseColon(streamTokenizer);
        String string2 = null;
        streamTokenizer.wordChars(61, 61);
        int n = streamTokenizer.nextToken();
        if (n != -3) {
            throw new IOException("Unexpected value: " + streamTokenizer);
        }
        streamTokenizer.ordinaryChar(61);
        string2 = streamTokenizer.sval;
        if (string2 == null) {
            throw new IOException("hash must be specified");
        }
        this.entries.put(string.toUpperCase(Locale.ENGLISH) + string2, null);
    }

    public boolean contains(String string, String string2) {
        return this.entries.containsKey(string.toUpperCase(Locale.ENGLISH) + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes readAttributes(JarFile jarFile, JarEntry jarEntry) throws IOException {
        Attributes attributes;
        final InputStream inputStream = jarFile.getInputStream(jarEntry);
        try {
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object;
                    Attributes attributes = new Attributes();
                    Class<?> clazz = Class.forName("java.util.jar.Manifest$FastInputStream");
                    Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                    Constructor<?> constructor = null;
                    for (int i = 0; i < constructorArray.length; ++i) {
                        object = constructorArray[i].getParameterTypes();
                        if (((Class<?>[])object).length != 1 || object[0] != (class$java$io$InputStream == null ? TrustedLibraries.class$("java.io.InputStream") : class$java$io$InputStream)) continue;
                        constructor = constructorArray[i];
                        break;
                    }
                    if (constructor == null) {
                        throw new Exception("Failed to find stream constructor");
                    }
                    constructor.setAccessible(true);
                    Object[] objectArray = new Object[]{inputStream};
                    object = constructor.newInstance(objectArray);
                    byte[] byArray = new byte[512];
                    Class[] classArray = new Class[]{clazz, byArray.getClass()};
                    Method method = (class$java$util$jar$Attributes == null ? (class$java$util$jar$Attributes = TrustedLibraries.class$("java.util.jar.Attributes")) : class$java$util$jar$Attributes).getDeclaredMethod("read", classArray);
                    if (method != null) {
                        method.setAccessible(true);
                        Object[] objectArray2 = new Object[]{object, byArray};
                        method.invoke((Object)attributes, objectArray2);
                    }
                    return attributes;
                }
            });
            attributes = (Attributes)t;
            Object var6_7 = null;
        }
        catch (Exception exception) {
            Attributes attributes2;
            try {
                attributes2 = jarEntry.getAttributes();
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return attributes2;
        }
        inputStream.close();
        return attributes;
    }

    public static boolean checkJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, GeneralSecurityException {
        if (INSTANCE == null || INSTANCE.isEmpty()) {
            return true;
        }
        if (!jarEntry.getName().toUpperCase(Locale.ENGLISH).endsWith(".SF")) {
            return false;
        }
        Attributes attributes = TrustedLibraries.readAttributes(jarFile, jarEntry);
        if (attributes == null) {
            return false;
        }
        Iterator<Object> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Attributes.Name name;
            String string;
            String string2 = iterator.next().toString();
            if (!string2.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST) || !INSTANCE.contains(string2, string = attributes.getValue(name = new Attributes.Name(string2)))) continue;
            Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.found");
            throw new GeneralSecurityException("trusted libraries list entry!");
        }
        Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.notfound");
        return false;
    }

    public static boolean checkJarFile(JarFile jarFile) throws IOException {
        if (INSTANCE == null || INSTANCE.isEmpty()) {
            Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.notexist");
            return false;
        }
        List list = TrustedLibraries.getManifestDigests(jarFile);
        if (list != null) {
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    if (!INSTANCE.contains(string2, string = (String)iterator.next())) continue;
                    Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.found");
                    return true;
                }
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName().toUpperCase(Locale.ENGLISH);
            if (!string.startsWith("META-INF/") && !string.startsWith("/META-INF/")) continue;
            try {
                if (!TrustedLibraries.checkJarEntry(jarFile, jarEntry)) continue;
                return false;
            }
            catch (GeneralSecurityException generalSecurityException) {
                return true;
            }
        }
        Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.notsigned");
        return false;
    }

    public static boolean hasBeenModifiedSince(long l) {
        return INSTANCE != null && lastModified >= l;
    }

    private static List getManifestDigests(JarFile jarFile) {
        try {
            JavaUtilJarAccess javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
            return javaUtilJarAccess.getManifestDigests(jarFile);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (Config.getBooleanProperty("deployment.security.blacklist.check") && Config.checkClassName("sun.security.action.OpenFileInputStreamAction")) {
            Trace.msgSecurityPrintln("downloadengine.check.trustedlibraries.enabled");
            INSTANCE = new TrustedLibraries();
        }
    }
}

