/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.autoupdate.ui.HTMLEditorKitEx;
import org.netbeans.modules.autoupdate.ui.HeaderPanel;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;

public class DetailsPanel
extends JTextPane {
    private JScrollPane scrollPane;
    private HeaderPanel header;
    private JLabel title;
    private JButton button;
    private JButton button2;
    private JPanel rightCornerHeader;
    private HyperlinkListener hyperlinkListener;

    public DetailsPanel() {
        this.initComponents2();
        HTMLEditorKitEx hTMLEditorKitEx = new HTMLEditorKitEx();
        StyleSheet styleSheet = hTMLEditorKitEx.getStyleSheet();
        if (styleSheet.getStyleSheets() == null) {
            StyleSheet styleSheet2 = new StyleSheet();
            Font font = new JList().getFont();
            int n = font.getSize();
            styleSheet2.addRule(new StringBuffer("body { font-size: ").append(n).append("; font-family: ").append(font.getName()).append("; }").toString());
            styleSheet2.addStyleSheet(styleSheet);
            hTMLEditorKitEx.setStyleSheet(styleSheet2);
        }
        this.setEditorKit(hTMLEditorKitEx);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (HyperlinkEvent.EventType.ACTIVATED == hyperlinkEvent.getEventType() && hyperlinkEvent.getURL() != null) {
                    Utilities.showURL(hyperlinkEvent.getURL());
                }
            }
        });
        this.setEditable(false);
        this.setPreferredSize(new Dimension(300, 80));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetailsPanel.class, (String)"ACN_DetailsPanel"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getScrollPane();
    }

    @Override
    public void removeNotify() {
        this.setEditorKit(new StyledEditorKit());
        if (this.hyperlinkListener != null) {
            this.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.scrollPane = null;
        super.removeNotify();
    }

    JScrollPane getScrollPane() {
        Container container;
        Container container2;
        if (this.scrollPane == null && (container2 = this.getParent()) instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            this.scrollPane = (JScrollPane)container;
        }
        return this.scrollPane;
    }

    public void setTitle(String string) {
        this.getScrollPane().setColumnHeaderView(string != null ? this.header : null);
        this.getScrollPane().setCorner("UPPER_RIGHT_CORNER", string != null ? this.rightCornerHeader : null);
        if (string != null) {
            this.title.setText("<html><h3>" + string + "</h3></html>");
        }
    }

    public void setActionListener(Action action) {
        this.button.setVisible(action != null);
        this.button.setEnabled(action != null);
        if (action != null) {
            this.button.setAction(action);
            this.button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailsPanel.class, (String)"ACN_DetailsPanel_Button", (Object)this.button.getName()));
        }
    }

    public void setActionListener2(Action action) {
        this.button2.setVisible(action != null);
        this.button2.setEnabled(action != null);
        if (action != null) {
            this.button2.setAction(action);
            this.button2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailsPanel.class, (String)"ACN_DetailsPanel_Button", (Object)this.button2.getName()));
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.title.setEnabled(bl);
        this.button.setEnabled(bl);
    }

    JEditorPane getDetails() {
        return this;
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.validate();
    }

    HeaderPanel getHeader() {
        return this.header;
    }

    private void initComponents2() {
        this.header = new HeaderPanel();
        this.title = this.header.getTitle();
        this.button = this.header.getButton();
        this.button2 = this.header.getButton2();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray);
        Border border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(matteBorder, border);
        this.header.setBorder(compoundBorder);
        this.button.setVisible(false);
        this.button2.setVisible(false);
        this.rightCornerHeader = new JPanel();
        this.rightCornerHeader.setBorder(compoundBorder);
        Color color = UnitTable.getDarkerColor(this.getBackground());
        this.header.setBackground(color);
        if (this.button != null) {
            this.button.setOpaque(false);
        }
        if (this.button2 != null) {
            this.button2.setOpaque(false);
        }
        this.rightCornerHeader.setBackground(color);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 0));
    }
}

