/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.ExtTreeWillExpandListener;
import org.netbeans.swing.outline.TreePathSupport;

final class EventBroadcaster
implements TableModelListener,
TreeModelListener,
ExtTreeWillExpandListener,
TreeExpansionListener {
    static boolean log = false;
    private int logcount = 0;
    private DefaultOutlineModel model;
    private TreeExpansionEvent inProgressEvent = null;
    private TableModelEvent pendingExpansionEvent = null;
    private boolean inMultiEvent = false;
    private static final int NODES_CHANGED = 0;
    private static final int NODES_INSERTED = 1;
    private static final int NODES_REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;
    private static final String[] types = new String[]{"nodesChanged", "nodesInserted", "nodesRemoved", "structureChanged"};
    private List<TableModelListener> tableListeners = new ArrayList<TableModelListener>();
    private List<TreeModelListener> treeListeners = new ArrayList<TreeModelListener>();

    public EventBroadcaster(DefaultOutlineModel defaultOutlineModel) {
        this.setModel(defaultOutlineModel);
    }

    private void log(String string, Object object) {
        if (log) {
            if (object instanceof TableModelEvent) {
                object = EventBroadcaster.tableModelEventToString((TableModelEvent)object);
            }
            System.err.println("EB-" + this.logcount++ + " " + string + ":" + (object instanceof String ? (String)object : object.toString()));
        }
    }

    public boolean areMoreEventsPending() {
        return this.inMultiEvent;
    }

    private DefaultOutlineModel getModel() {
        return this.model;
    }

    private void setModel(DefaultOutlineModel defaultOutlineModel) {
        this.model = defaultOutlineModel;
    }

    private AbstractLayoutCache getLayout() {
        return this.getModel().getLayout();
    }

    private TreePathSupport getTreePathSupport() {
        return this.getModel().getTreePathSupport();
    }

    private TreeModel getTreeModel() {
        return this.getModel().getTreeModel();
    }

    private TableModel getTableModel() {
        return this.getModel().getTableModel();
    }

    public synchronized void addTableModelListener(TableModelListener tableModelListener) {
        this.tableListeners.add(tableModelListener);
    }

    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeListeners.add(treeModelListener);
    }

    public synchronized void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableListeners.remove(tableModelListener);
    }

    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeListeners.remove(treeModelListener);
    }

    private void fireTableChange(TableModelEvent tableModelEvent, TableModelListener[] tableModelListenerArray) {
        if (tableModelEvent == null) {
            return;
        }
        assert (tableModelEvent.getSource() == this.getModel());
        this.log("fireTableChange", tableModelEvent);
        for (int i = 0; i < tableModelListenerArray.length; ++i) {
            tableModelListenerArray[i].tableChanged(tableModelEvent);
        }
    }

    void fireTableChange(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null) {
            return;
        }
        this.inMultiEvent = false;
        this.fireTableChange(tableModelEvent, this.getTableModelListeners());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableChange(TableModelEvent[] tableModelEventArray) {
        if (tableModelEventArray == null || tableModelEventArray.length == 0) {
            return;
        }
        TableModelListener[] tableModelListenerArray = this.getTableModelListeners();
        this.inMultiEvent = tableModelEventArray.length > 1;
        try {
            for (int i = 0; i < tableModelEventArray.length; ++i) {
                this.fireTableChange(tableModelEventArray[i], tableModelListenerArray);
                if (i != tableModelEventArray.length - 1) continue;
                this.inMultiEvent = false;
            }
        }
        finally {
            this.inMultiEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableModelListener[] getTableModelListeners() {
        TableModelListener[] tableModelListenerArray = null;
        EventBroadcaster eventBroadcaster = this;
        synchronized (eventBroadcaster) {
            tableModelListenerArray = new TableModelListener[this.tableListeners.size()];
            tableModelListenerArray = this.tableListeners.toArray(tableModelListenerArray);
        }
        return tableModelListenerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireTreeChange(TreeModelEvent treeModelEvent, int n) {
        if (treeModelEvent == null) {
            return;
        }
        assert (treeModelEvent.getSource() == this.getModel());
        TreeModelListener[] treeModelListenerArray = null;
        EventBroadcaster eventBroadcaster = this;
        synchronized (eventBroadcaster) {
            treeModelListenerArray = new TreeModelListener[this.treeListeners.size()];
            treeModelListenerArray = this.treeListeners.toArray(treeModelListenerArray);
        }
        this.log("fireTreeChange-" + types[n], treeModelEvent);
        block9: for (int i = 0; i < treeModelListenerArray.length; ++i) {
            switch (n) {
                case 0: {
                    treeModelListenerArray[i].treeNodesChanged(treeModelEvent);
                    continue block9;
                }
                case 1: {
                    treeModelListenerArray[i].treeNodesInserted(treeModelEvent);
                    continue block9;
                }
                case 2: {
                    treeModelListenerArray[i].treeNodesRemoved(treeModelEvent);
                    continue block9;
                }
                case 3: {
                    treeModelListenerArray[i].treeStructureChanged(treeModelEvent);
                    continue block9;
                }
                default: {
                    assert (false);
                    continue block9;
                }
            }
        }
    }

    @Override
    public void tableChanged(final TableModelEvent tableModelEvent) {
        assert (tableModelEvent.getType() == 0) : "Table model should only fire updates, never structural changes";
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireTableChange(this.translateEvent(tableModelEvent));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventBroadcaster.this.tableChanged(tableModelEvent);
                }
            });
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fireTreeChange(this.translateEvent(treeModelEvent), 0);
        TableModelEvent[] tableModelEventArray = this.translateEvent(treeModelEvent, 0);
        this.getLayout().treeNodesChanged(treeModelEvent);
        this.fireTableChange(tableModelEventArray);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fireTreeChange(this.translateEvent(treeModelEvent), 1);
        TableModelEvent[] tableModelEventArray = this.translateEvent(treeModelEvent, 1);
        this.getLayout().treeNodesInserted(treeModelEvent);
        this.fireTableChange(tableModelEventArray);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fireTreeChange(this.translateEvent(treeModelEvent), 2);
        TableModelEvent[] tableModelEventArray = this.translateEvent(treeModelEvent, 2);
        this.getLayout().treeNodesRemoved(treeModelEvent);
        this.fireTableChange(tableModelEventArray);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        this.getLayout().treeStructureChanged(treeModelEvent);
        this.fireTreeChange(this.translateEvent(treeModelEvent), 3);
        this.getTreePathSupport().clear();
        this.fireTableChange(new TableModelEvent(this.getModel()));
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeWillCollapse", treeExpansionEvent);
        this.pendingExpansionEvent = this.translateEvent(treeExpansionEvent, false);
        this.log("treeWillCollapse generated ", this.pendingExpansionEvent);
        this.inProgressEvent = treeExpansionEvent;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeWillExpand", treeExpansionEvent);
        this.pendingExpansionEvent = this.translateEvent(treeExpansionEvent, true);
        this.log("treeWillExpand generated", this.pendingExpansionEvent);
        this.inProgressEvent = treeExpansionEvent;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath;
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeCollapsed", treeExpansionEvent);
        if (treeExpansionEvent != null && (treePath = treeExpansionEvent.getPath()) != null && this.getTreePathSupport().isVisible(treePath)) {
            this.getLayout().setExpandedState(treePath, false);
        }
        this.log("about to fire", this.pendingExpansionEvent);
        treePath = treeExpansionEvent.getPath();
        int n = this.getLayout().getRowForPath(treePath);
        TableModelEvent tableModelEvent = new TableModelEvent(this.getModel(), n, n, 0, 0);
        this.fireTableChange(new TableModelEvent[]{tableModelEvent, this.pendingExpansionEvent});
        this.pendingExpansionEvent = null;
        this.inProgressEvent = null;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeExpanded", treeExpansionEvent);
        if (treeExpansionEvent != null) {
            this.updateExpandedDescendants(treeExpansionEvent.getPath());
        }
        this.log("about to fire", this.pendingExpansionEvent);
        TreePath treePath = treeExpansionEvent.getPath();
        int n = this.getLayout().getRowForPath(treePath);
        TableModelEvent tableModelEvent = new TableModelEvent(this.getModel(), n, n, 0, 0);
        if (n == -1) {
            tableModelEvent = new TableModelEvent(this.getModel());
        }
        this.fireTableChange(new TableModelEvent[]{tableModelEvent, this.pendingExpansionEvent});
        this.pendingExpansionEvent = null;
        this.inProgressEvent = null;
    }

    @Override
    public void treeExpansionVetoed(TreeExpansionEvent treeExpansionEvent, ExpandVetoException expandVetoException) {
        assert (SwingUtilities.isEventDispatchThread());
        this.log("treeExpansionVetoed", expandVetoException);
        if (treeExpansionEvent == this.inProgressEvent) {
            this.pendingExpansionEvent = null;
            this.inProgressEvent = null;
        }
    }

    private void updateExpandedDescendants(TreePath treePath) {
        this.getLayout().setExpandedState(treePath, true);
        TreePath[] treePathArray = this.getTreePathSupport().getExpandedDescendants(treePath);
        if (treePathArray.length > 0) {
            for (int i = 0; i < treePathArray.length; ++i) {
                this.getLayout().setExpandedState(treePathArray[i], true);
            }
        }
    }

    private TableModelEvent translateEvent(TableModelEvent tableModelEvent) {
        TableModelEvent tableModelEvent2 = new TableModelEvent(this.getModel(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn() + 1, tableModelEvent.getType());
        return tableModelEvent2;
    }

    private TreeModelEvent translateEvent(TreeModelEvent treeModelEvent) {
        TreeModelEvent treeModelEvent2 = new TreeModelEvent((Object)this.getModel(), treeModelEvent.getPath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        return treeModelEvent2;
    }

    private TableModelEvent[] translateEvent(TreeModelEvent treeModelEvent, int n) {
        int n2;
        Object[] objectArray;
        boolean bl;
        TreePath treePath = treeModelEvent.getTreePath();
        int n3 = this.getLayout().getRowForPath(treePath);
        boolean bl2 = bl = !this.getLayout().isExpanded(treePath);
        if (bl) {
            if (n3 != -1) {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return new TableModelEvent[]{new TableModelEvent(this.getModel(), n3, n3, 0, 0)};
                    }
                }
                assert (false) : "Unknown event type " + n;
            }
            return new TableModelEvent[0];
        }
        boolean bl3 = EventBroadcaster.isDiscontiguous(treeModelEvent);
        if (bl3) {
            objectArray = EventBroadcaster.getContiguousIndexBlocks(treeModelEvent, n == 2);
            this.log("discontiguous " + types[n] + " event", objectArray.length + " blocks");
        } else {
            objectArray = new Object[]{treeModelEvent.getChildIndices()};
        }
        TableModelEvent[] tableModelEventArray = new TableModelEvent[objectArray.length];
        block8: for (n2 = 0; n2 < objectArray.length; ++n2) {
            int[] nArray = (int[])objectArray[n2];
            switch (n) {
                case 0: {
                    tableModelEventArray[n2] = this.createTableChangeEvent(treeModelEvent, nArray);
                    continue block8;
                }
                case 1: {
                    tableModelEventArray[n2] = this.createTableInsertionEvent(treeModelEvent, nArray);
                    continue block8;
                }
                case 2: {
                    tableModelEventArray[n2] = this.createTableDeletionEvent(treeModelEvent, nArray);
                    continue block8;
                }
                default: {
                    assert (false) : "Unknown event type: " + n;
                    continue block8;
                }
            }
        }
        this.log("translateEvent", treeModelEvent);
        this.log("generated table events", new Integer(tableModelEventArray.length));
        if (log) {
            for (n2 = 0; n2 < tableModelEventArray.length; ++n2) {
                this.log("  Event " + n2, tableModelEventArray[n2]);
            }
        }
        return tableModelEventArray;
    }

    private TableModelEvent translateEvent(TreeExpansionEvent treeExpansionEvent, boolean bl) {
        int n;
        TreePath treePath = treeExpansionEvent.getPath();
        int n2 = this.getLayout().getRowForPath(treePath) + 1;
        if (n2 == -1) {
            return null;
        }
        TreePath[] treePathArray = this.getTreePathSupport().getExpandedDescendants(treePath);
        int n3 = this.getTreeModel().getChildCount(treePath.getLastPathComponent());
        for (n = 0; n < treePathArray.length; ++n) {
            n3 += this.getTreeModel().getChildCount(treePathArray[n].getLastPathComponent());
        }
        n = n2 + n3 - 1;
        TableModelEvent tableModelEvent = new TableModelEvent(this.getModel(), n2, n, -1, bl ? 1 : -1);
        return tableModelEvent;
    }

    private TableModelEvent createTableChangeEvent(TreeModelEvent treeModelEvent, int[] nArray) {
        TableModelEvent tableModelEvent = null;
        TreePath treePath = treeModelEvent.getTreePath();
        int n = this.getLayout().getRowForPath(treePath);
        int n2 = null == nArray ? n : nArray[0];
        int n3 = null == nArray ? n : nArray[nArray.length - 1];
        tableModelEvent = new TableModelEvent(this.getModel(), n2, n3, -1, 0);
        return tableModelEvent;
    }

    private TableModelEvent createTableInsertionEvent(TreeModelEvent treeModelEvent, int[] nArray) {
        TableModelEvent tableModelEvent = null;
        this.log("createTableInsertionEvent", treeModelEvent);
        TreePath treePath = treeModelEvent.getTreePath();
        int n = this.getLayout().getRowForPath(treePath);
        boolean bl = this.getLayout().isExpanded(treePath);
        if (bl) {
            if (nArray.length == 1) {
                int n2 = n + nArray[0] + 1;
                tableModelEvent = new TableModelEvent(this.getModel(), n2, n2, -1, 1);
            } else {
                int n3 = nArray[0] + 1;
                int n4 = nArray[nArray.length - 1] + 1;
                tableModelEvent = new TableModelEvent(this.getModel(), n + n3, n + n4, -1, 1);
            }
        } else {
            tableModelEvent = new TableModelEvent(this.getModel(), n, n, -1);
        }
        return tableModelEvent;
    }

    private TableModelEvent createTableDeletionEvent(TreeModelEvent treeModelEvent, int[] nArray) {
        int n;
        TableModelEvent tableModelEvent = null;
        this.log("createTableDeletionEvent " + Arrays.asList(EventBroadcaster.toArrayOfInteger(nArray)), treeModelEvent);
        TreePath treePath = treeModelEvent.getTreePath();
        int n2 = this.getLayout().getRowForPath(treePath);
        if (n2 == -1) {
            // empty if block
        }
        int n3 = nArray.length;
        Object[] objectArray = this.getChildrenForIndices(treeModelEvent, nArray);
        for (n = 0; n < objectArray.length; ++n) {
            TreePath treePath2 = treePath.pathByAddingChild(objectArray[n]);
            if (this.getTreePathSupport().isExpanded(treePath2)) {
                int n4 = this.getLayout().getVisibleChildCount(treePath2);
                if (log) {
                    this.log(treePath2 + " has ", new Integer(n4));
                }
                n3 += n4;
            }
            this.getTreePathSupport().removePath(treePath2);
        }
        n = n2 + nArray[0] + 1;
        this.log("firstRow", new Integer(n));
        this.log("Count removed is ", new Integer(n3));
        int n5 = n + (n3 - 1);
        this.log("TableModelEvent: fromRow: ", new Integer(n));
        this.log(" toRow: ", new Integer(n5));
        tableModelEvent = new TableModelEvent(this.getModel(), n, n5, -1, -1);
        return tableModelEvent;
    }

    private static boolean isDiscontiguous(TreeModelEvent treeModelEvent) {
        int[] nArray = treeModelEvent.getChildIndices();
        if (nArray == null || nArray.length == 1) {
            return false;
        }
        Arrays.sort(nArray);
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] != n + 1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static Object[] getContiguousIndexBlocks(TreeModelEvent treeModelEvent, boolean bl) {
        int n;
        int[] nArray = treeModelEvent.getChildIndices();
        if (nArray.length == 1) {
            return new Object[]{nArray};
        }
        ArrayList arrayList = new ArrayList();
        if (bl) {
            EventBroadcaster.inverseSort(nArray);
        } else {
            Arrays.sort(nArray);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(nArray.length / 2);
        arrayList.add(arrayList2);
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0) {
                int n3 = bl ? (nArray[i] != n2 - 1 ? 1 : 0) : (n = nArray[i] != n2 + 1 ? 1 : 0);
                if (n != 0) {
                    arrayList2 = new ArrayList(nArray.length - 1);
                    arrayList.add(arrayList2);
                }
            }
            arrayList2.add(new Integer(nArray[i]));
            n2 = nArray[i];
        }
        ArrayList<int[]> arrayList3 = new ArrayList<int[]>(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            ArrayList arrayList4 = (ArrayList)arrayList.get(n);
            Integer[] integerArray = arrayList4.toArray(new Integer[0]);
            arrayList3.add(EventBroadcaster.toArrayOfInt(integerArray));
        }
        return arrayList3.toArray();
    }

    private Object[] getChildrenForIndices(TreeModelEvent treeModelEvent, int[] nArray) {
        Object[] objectArray = treeModelEvent.getChildren();
        int[] nArray2 = treeModelEvent.getChildIndices();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = Arrays.binarySearch(nArray2, nArray[i]);
            if (n > -1) {
                arrayList.add(objectArray[n]);
            }
            if (arrayList.size() == nArray.length) break;
        }
        return arrayList.toArray();
    }

    private static int[] toArrayOfInt(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    private static Integer[] toArrayOfInteger(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        return integerArray;
    }

    private static void inverseSort(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] * -1;
        }
        Arrays.sort(nArray);
        n = 0;
        while (n < nArray.length) {
            int n3 = n++;
            nArray[n3] = nArray[n3] * -1;
        }
    }

    private static String tableModelEventToString(TableModelEvent tableModelEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TableModelEvent ");
        switch (tableModelEvent.getType()) {
            case 1: {
                stringBuffer.append("insert ");
                break;
            }
            case -1: {
                stringBuffer.append("delete ");
                break;
            }
            case 0: {
                stringBuffer.append("update ");
                break;
            }
            default: {
                stringBuffer.append("Unknown type " + tableModelEvent.getType());
            }
        }
        stringBuffer.append("from ");
        switch (tableModelEvent.getFirstRow()) {
            case -1: {
                stringBuffer.append("header row ");
                break;
            }
            default: {
                stringBuffer.append(tableModelEvent.getFirstRow());
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append("to ");
        stringBuffer.append(tableModelEvent.getLastRow());
        stringBuffer.append(" column ");
        switch (tableModelEvent.getColumn()) {
            case -1: {
                stringBuffer.append("ALL_COLUMNS");
                break;
            }
            default: {
                stringBuffer.append(tableModelEvent.getColumn());
            }
        }
        return stringBuffer.toString();
    }
}

