/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;

public class DependencyAggregator {
    private static final Map<DependencyDecoratorKey, DependencyAggregator> key2dependency = new HashMap<DependencyDecoratorKey, DependencyAggregator>(11, 11.0f);
    private Collection<ModuleInfo> depending = new CopyOnWriteArraySet<ModuleInfo>();
    private final DependencyDecoratorKey key;

    private DependencyAggregator(DependencyDecoratorKey dependencyDecoratorKey) {
        this.key = dependencyDecoratorKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyAggregator getAggregator(Dependency dependency) {
        DependencyDecoratorKey dependencyDecoratorKey = new DependencyDecoratorKey(dependency.getName(), dependency.getType(), dependency.getComparison());
        Map<DependencyDecoratorKey, DependencyAggregator> map = key2dependency;
        synchronized (map) {
            DependencyAggregator dependencyAggregator = key2dependency.get(dependencyDecoratorKey);
            if (dependencyAggregator == null) {
                dependencyAggregator = new DependencyAggregator(dependencyDecoratorKey);
                key2dependency.put(dependencyDecoratorKey, dependencyAggregator);
            }
            return dependencyAggregator;
        }
    }

    public int getType() {
        return this.key.type;
    }

    public String getName() {
        return this.key.name;
    }

    public boolean addDependee(ModuleInfo moduleInfo) {
        return this.depending.add(moduleInfo);
    }

    public Collection<ModuleInfo> getDependening() {
        return this.depending;
    }

    public String toString() {
        return "DependencyDecorator[" + this.key.toString() + "]";
    }

    public static UpdateUnit getRequested(Dependency dependency) {
        switch (dependency.getType()) {
            case 1: {
                return UpdateManagerImpl.getInstance().getUpdateUnit(dependency.getName());
            }
            case 5: 
            case 6: 
            case 7: {
                Collection<ModuleInfo> collection = UpdateManagerImpl.getInstance().getInstalledProviders(dependency.getName());
                if (collection.isEmpty()) {
                    Collection<ModuleInfo> collection2 = UpdateManagerImpl.getInstance().getAvailableProviders(dependency.getName());
                    if (collection2.isEmpty()) {
                        return null;
                    }
                    ModuleInfo moduleInfo = collection2.iterator().next();
                    return UpdateManagerImpl.getInstance().getUpdateUnit(moduleInfo.getCodeNameBase());
                }
                ModuleInfo moduleInfo = collection.iterator().next();
                return UpdateManagerImpl.getInstance().getUpdateUnit(moduleInfo.getCodeNameBase());
            }
        }
        return null;
    }

    public static class DependencyDecoratorKey {
        private final String name;
        private final int type;
        private final int hashCode;

        public DependencyDecoratorKey(String string, int n, int n2) {
            this.name = string;
            this.type = n;
            this.hashCode = 0xBC7E3 ^ this.type ^ string.hashCode();
        }

        public boolean equals(Object object) {
            if (object.getClass() != DependencyDecoratorKey.class) {
                return false;
            }
            DependencyDecoratorKey dependencyDecoratorKey = (DependencyDecoratorKey)object;
            return this.type == dependencyDecoratorKey.type && this.name.equals(dependencyDecoratorKey.name);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("Key[");
            if (this.type == 1) {
                stringBuffer.append("module ");
            } else if (this.type == 2) {
                stringBuffer.append("package ");
            } else if (this.type == 5) {
                stringBuffer.append("requires ");
            } else if (this.type == 6) {
                stringBuffer.append("needs ");
            } else if (this.type == 7) {
                stringBuffer.append("recommends ");
            }
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

