/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;

public class Stylepad
extends Notepad {
    private static ResourceBundle resources;

    public static void main(String[] stringArray) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrame jFrame = new JFrame();
                    jFrame.setTitle(resources.getString("Title"));
                    jFrame.setBackground(Color.lightGray);
                    jFrame.getContentPane().setLayout(new BorderLayout());
                    Stylepad stylepad = new Stylepad();
                    jFrame.getContentPane().add("Center", stylepad);
                    jFrame.setJMenuBar(stylepad.createMenubar());
                    jFrame.addWindowListener(new Notepad.AppCloser());
                    jFrame.pack();
                    jFrame.setSize(600, 480);
                    jFrame.setVisible(true);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(Stylepad.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(Stylepad.class.getName()).log(Level.SEVERE, null, invocationTargetException);
        }
    }

    @Override
    public Action[] getActions() {
        Action[] actionArray = new Action[]{new NewAction(), new OpenAction(), new SaveAction(), new StyledEditorKit.FontFamilyAction("font-family-LucidaSans", "Lucida Sans")};
        Action[] actionArray2 = TextAction.augmentList(super.getActions(), actionArray);
        return actionArray2;
    }

    @Override
    protected String getResourceString(String string) {
        String string2;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = super.getResourceString(string);
        }
        return string2;
    }

    @Override
    protected JTextComponent createEditor() {
        StyleContext styleContext = new StyleContext();
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(styleContext);
        this.initDocument(defaultStyledDocument, styleContext);
        JTextPane jTextPane = new JTextPane(defaultStyledDocument);
        jTextPane.setDragEnabled(true);
        return jTextPane;
    }

    @Override
    protected JMenu createMenu(String string) {
        if (string.equals("color")) {
            return this.createColorMenu();
        }
        return super.createMenu(string);
    }

    JMenu createColorMenu() {
        JMenu jMenu = new JMenu(this.getResourceString("colorLabel"));
        JMenuItem jMenuItem = new JMenuItem(resources.getString("Red"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setIcon(new ColoredSquare(Color.red));
        StyledEditorKit.ForegroundAction foregroundAction = new StyledEditorKit.ForegroundAction("set-foreground-red", Color.red);
        jMenuItem.addActionListener(foregroundAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resources.getString("Green"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setIcon(new ColoredSquare(Color.green));
        foregroundAction = new StyledEditorKit.ForegroundAction("set-foreground-green", Color.green);
        jMenuItem.addActionListener(foregroundAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resources.getString("Blue"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setIcon(new ColoredSquare(Color.blue));
        foregroundAction = new StyledEditorKit.ForegroundAction("set-foreground-blue", Color.blue);
        jMenuItem.addActionListener(foregroundAction);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    void initDocument(DefaultStyledDocument defaultStyledDocument, StyleContext styleContext) {
        Wonderland wonderland = new Wonderland(defaultStyledDocument, styleContext);
        wonderland.loadDocument();
    }

    JComboBox createFamilyChoices() {
        String[] stringArray;
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            jComboBox.addItem(string);
        }
        return jComboBox;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("resources.Stylepad");
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Stylepad.properties not found");
            System.exit(0);
        }
    }

    class ColoredSquare
    implements Icon {
        Color color;

        public ColoredSquare(Color color) {
            this.color = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(this.color);
            graphics.fill3DRect(n, n2, this.getIconWidth(), this.getIconHeight(), true);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super("new");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Stylepad.this.getEditor().getDocument() != null) {
                Stylepad.this.getEditor().getDocument().removeUndoableEditListener(Stylepad.this.undoHandler);
            }
            Stylepad.this.getEditor().setDocument(new DefaultStyledDocument());
            Stylepad.this.getEditor().getDocument().addUndoableEditListener(Stylepad.this.undoHandler);
            Stylepad.this.resetUndoManager();
            Stylepad.this.getFrame().setTitle(resources.getString("Title"));
            Stylepad.this.validate();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("save");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = Stylepad.this.getFrame();
            if (Stylepad.this.fileDialog == null) {
                Stylepad.this.fileDialog = new FileDialog(frame);
            }
            Stylepad.this.fileDialog.setMode(1);
            Stylepad.this.fileDialog.setVisible(true);
            String string = Stylepad.this.fileDialog.getFile();
            if (string == null) {
                return;
            }
            String string2 = Stylepad.this.fileDialog.getDirectory();
            File file = new File(string2, string);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(Stylepad.this.getEditor().getDocument());
                objectOutputStream.flush();
                frame.setTitle(file.getName());
            }
            catch (IOException iOException) {
                System.err.println("IOException: " + iOException.getMessage());
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("open");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = Stylepad.this.getFrame();
            if (Stylepad.this.fileDialog == null) {
                Stylepad.this.fileDialog = new FileDialog(frame);
            }
            Stylepad.this.fileDialog.setMode(0);
            Stylepad.this.fileDialog.setVisible(true);
            String string = Stylepad.this.fileDialog.getFile();
            if (string == null) {
                return;
            }
            String string2 = Stylepad.this.fileDialog.getDirectory();
            File file = new File(string2, string);
            if (file.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    Document document = (Document)objectInputStream.readObject();
                    if (Stylepad.this.getEditor().getDocument() != null) {
                        Stylepad.this.getEditor().getDocument().removeUndoableEditListener(Stylepad.this.undoHandler);
                    }
                    Stylepad.this.getEditor().setDocument(document);
                    document.addUndoableEditListener(Stylepad.this.undoHandler);
                    Stylepad.this.resetUndoManager();
                    frame.setTitle(string);
                    Stylepad.this.validate();
                }
                catch (IOException iOException) {
                    System.err.println("IOException: " + iOException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Class not found: " + classNotFoundException.getMessage());
                }
            } else {
                System.err.println("No such file: " + file);
            }
        }
    }
}

