/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUFullInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUSampledInstr;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.InternalStatsResponse;

class ProfilerCalibrator
extends ProfilerRuntime {
    private static String CANNOT_SAVE_CALIBRATION_DATA_MSG = "Performed calibration successfully, but could not save calibration data:\n{0}";
    private static String CALIBRATION_SUCCESS_MSG = "Calibration performed successfully";
    private static String CALIBRATION_RESULTS_PREFIX = "For your reference, obtained results are as follows:";
    private static String CALIBRATION_RESULTS_MSG = "Approximate time in one methodEntry()/methodExit() call pair:\nWhen getting absolute timestamp only: {0} microseconds\nWhen getting thread CPU timestamp only: {1} microseconds\nWhen getting both timestamps: {2} microseconds\n\nApproximate time in one methodEntry()/methodExit() call pair\nin sampled instrumentation mode: {3} microseconds\n";
    private static String STARTING_CALIBRATION_MSG = "Starting calibration...";
    private static String TIMER_COUNTS_MSG = "*** timerCountsInSecond = {0}";
    private static String TIMER_VALUE_MSG = "*** sample value returned by timer = {0}";
    private static String INJECTION_CALIBRATION_MSG = "----------- Injected profiler code calibration -----------";
    private static String TIME_getCurrentTimeInCounts_MSG = "Time per each getCurrentTimeInCounts() call";
    private static String TIME_getThreadCPUTimeInNanos_MSG = "Time per each getThreadCPUTimeInNanos() call";
    private static String TIME_COUNTS_MCS_MSG = "{0} counts, {1} mcs";
    private static String TIME_SUCCESS_PAIRS_MSG = "Time per each successful methodEntry()/methodExit() pair of calls ({0}, {1})";
    private static String MINIMUM_TIME_MSG = "Minimum time: {0} counts, or {1} mcs.";
    private static String INNER_OUTER_TIME_MSG = "Inner/outer time for a successful methodEntry()/methodExit() pair of calls";
    private static String INNER_TIME_MCS_MSG = "Inner time: {0} mcs.";
    private static String OUTER_TIME_MCS_MSG = "Outer time: {0} mcs.";
    private static String SAMPLED_TIME_MSG = "Time per each sampled instrumentation methodEntry()/methodExit() pair of calls";
    private static String REGION_TIME_MSG = "Time per each codeRegionEntry()/codeRegionExit() pair of calls";
    private static ProfilingSessionStatus status;
    private static boolean printResults;
    private static byte[] buf;
    private static double minTimePerMethodEntryExitCallInCounts;
    private static double minTimePerMethodEntryExitCallInMCS;
    private static double innerTimeInCounts;
    private static double outerTimeInCounts;
    private static long cntInSecond;
    private static int nCall;
    private static int cycleWhenMinResultDetected;

    ProfilerCalibrator() {
    }

    public static void init(ProfilingSessionStatus profilingSessionStatus) {
        status = profilingSessionStatus;
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl;
        if (stringArray.length > 0 && stringArray[0].equals("-develmode")) {
            bl = true;
            System.out.println("Loader for this class is " + ProfilerCalibrator.class.getClassLoader());
        } else {
            bl = false;
            object = new ProfilingSessionStatus();
            ((ProfilingSessionStatus)object).targetJDKVersionString = Platform.getJDKVersionString();
            ((ProfilingSessionStatus)object).remoteProfiling = true;
            ProfilerCalibrator.init((ProfilingSessionStatus)object);
        }
        if (Platform.getJDKVersionNumber() == 5) {
            System.loadLibrary("profilerinterface");
        }
        Timers.initialize();
        ProfilerCalibrator.measureBCIOverhead(bl);
        if (!bl) {
            if (!CalibrationDataFileIO.saveCalibrationData(status)) {
                System.err.println(MessageFormat.format(CANNOT_SAVE_CALIBRATION_DATA_MSG, CalibrationDataFileIO.getErrorMessage()));
                System.exit(-1);
            }
            System.out.println(CALIBRATION_SUCCESS_MSG);
            System.out.println(CALIBRATION_RESULTS_PREFIX);
            object = NumberFormat.getInstance();
            ((NumberFormat)object).setMaximumFractionDigits(4);
            long l = ProfilerCalibrator.status.timerCountsInSecond[0];
            double d = ProfilerCalibrator.status.methodEntryExitCallTime[0] * 1000000.0 / (double)l;
            double d2 = ProfilerCalibrator.status.methodEntryExitCallTime[1] * 1000000.0 / (double)l;
            double d3 = ProfilerCalibrator.status.methodEntryExitCallTime[2] * 1000000.0 / (double)l;
            double d4 = ProfilerCalibrator.status.methodEntryExitCallTime[4] * 1000000.0 / (double)l;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(MessageFormat.format(CALIBRATION_RESULTS_MSG, ((NumberFormat)object).format(d), ((NumberFormat)object).format(d2), ((NumberFormat)object).format(d3), ((NumberFormat)object).format(d4)));
            System.out.println(stringBuffer.toString());
        }
    }

    public static void measureBCIOverhead(boolean bl) {
        printResults = bl;
        System.out.println(STARTING_CALIBRATION_MSG);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cntInSecond = Timers.getNoOfCountsInSecond();
        ProfilerCalibrator.printResults(MessageFormat.format(TIMER_COUNTS_MSG, "" + cntInSecond));
        ProfilerCalibrator.printResults(MessageFormat.format(TIMER_VALUE_MSG, "" + Timers.getCurrentTimeInCounts()));
        if (status != null) {
            ProfilerCalibrator.status.timerCountsInSecond = new long[2];
            ProfilerCalibrator.status.timerCountsInSecond[0] = cntInSecond;
            ProfilerCalibrator.status.timerCountsInSecond[1] = 1000000000L;
        }
        ProfilerRuntime.resetProfilerCollectors(2);
        ProfilerRuntimeCPU.setNProfiledThreadsLimit(1);
        ProfilerRuntimeCPU.setInstrMethodsInvoked(new boolean[]{true, true, true, true});
        ProfilerRuntimeCPU.createThreadInfoForCurrentThread();
        ProfilerCalibrator.printResults(INJECTION_CALIBRATION_MSG + "\n");
        if (printResults) {
            ProfilerCalibrator.measureTimerCall(true);
            ProfilerCalibrator.measureTimerCall(false);
        }
        nCall = -1;
        ProfilerCalibrator.measureMethodEntryExitCalls();
        for (nCall = 0; nCall < 4; ++nCall) {
            ProfilerCalibrator.measureMethodEntryExitCalls();
            if (status == null) continue;
            ProfilerCalibrator.status.methodEntryExitCallTime[ProfilerCalibrator.nCall] = minTimePerMethodEntryExitCallInCounts;
            ProfilerCalibrator.status.methodEntryExitInnerTime[ProfilerCalibrator.nCall] = innerTimeInCounts;
            ProfilerCalibrator.status.methodEntryExitOuterTime[ProfilerCalibrator.nCall] = outerTimeInCounts;
        }
        nCall = -1;
        ProfilerCalibrator.measureSampledMethodEntryExitCalls();
        nCall = 0;
        ProfilerCalibrator.measureSampledMethodEntryExitCalls();
        if (status != null) {
            ProfilerCalibrator.status.methodEntryExitCallTime[4] = minTimePerMethodEntryExitCallInCounts;
            ProfilerCalibrator.status.methodEntryExitInnerTime[4] = innerTimeInCounts;
            ProfilerCalibrator.status.methodEntryExitOuterTime[4] = outerTimeInCounts;
        }
        ProfilerCalibrator.measureCodeRegionCalls();
        ProfilerCalibrator.printResults("----------------------------------------------------------\n");
        buf = null;
        ProfilerRuntimeCPUCodeRegion.setCPUResBufSize(0);
        ThreadInfo.setDefaultEvBufParams();
        ProfilerRuntime.resetProfilerCollectors(2);
        ProfilerRuntime.resetProfilerCollectors(3);
    }

    static InternalStatsResponse getInternalStats() {
        InternalStatsResponse internalStatsResponse = new InternalStatsResponse();
        internalStatsResponse.nTotalInstrMethods = ProfilerInterface.nTotalInstrMethods;
        internalStatsResponse.nClassLoads = ProfilerInterface.nClassLoads;
        internalStatsResponse.nFirstMethodInvocations = ProfilerInterface.nFirstMethodInvocations;
        internalStatsResponse.nNonEmptyInstrMethodGroupResponses = ProfilerInterface.nNonEmptyInstrMethodGroupResponses;
        internalStatsResponse.nEmptyInstrMethodGroupResponses = ProfilerInterface.nEmptyInstrMethodGroupResponses;
        internalStatsResponse.nSingleMethodInstrMethodGroupResponses = ProfilerInterface.nSingleMethodInstrMethodGroupResponses;
        long l = Timers.getNoOfCountsInSecond();
        internalStatsResponse.clientInstrTime = (double)ProfilerInterface.clientInstrTime * 1000.0 / (double)l;
        internalStatsResponse.clientDataProcTime = (double)ProfilerInterface.clientDataProcTime * 1000.0 / (double)l;
        if (internalStatsResponse.nNonEmptyInstrMethodGroupResponses > 0) {
            internalStatsResponse.totalHotswappingTime = (double)ProfilerInterface.totalHotswappingTime * 1000.0 / (double)l;
            internalStatsResponse.averageHotswappingTime = (double)ProfilerInterface.totalHotswappingTime * 1000.0 / (double)l / (double)ProfilerInterface.nNonEmptyInstrMethodGroupResponses;
            internalStatsResponse.minHotswappingTime = (double)ProfilerInterface.minHotswappingTime * 1000.0 / (double)l;
            internalStatsResponse.maxHotswappingTime = (double)ProfilerInterface.maxHotswappingTime * 1000.0 / (double)l;
        }
        internalStatsResponse.methodEntryExitCallTime0 = ProfilerCalibrator.status.methodEntryExitCallTime[0] * 1000000.0 / (double)l;
        internalStatsResponse.methodEntryExitCallTime1 = ProfilerCalibrator.status.methodEntryExitCallTime[1] * 1000000.0 / (double)l;
        internalStatsResponse.methodEntryExitCallTime2 = ProfilerCalibrator.status.methodEntryExitCallTime[2] * 1000000.0 / (double)l;
        return internalStatsResponse;
    }

    static void resetInternalStatsCollectors() {
        ProfilerInterface.totalHotswappingTime = 0L;
        ProfilerInterface.clientInstrTime = 0L;
        ProfilerInterface.clientDataProcTime = 0L;
    }

    private static void measureCodeRegionCalls() {
        ProfilerCalibrator.printResults("\n" + REGION_TIME_MSG);
        ProfilerRuntimeCPUCodeRegion.setCPUResBufSize(100);
        ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
        int n = 50;
        for (int i = 0; i < 50; ++i) {
            long l = Timers.getCurrentTimeInCounts();
            for (int j = 0; j < n; ++j) {
                ProfilerRuntimeCPUCodeRegion.codeRegionEntry();
                ProfilerRuntimeCPUCodeRegion.codeRegionExit();
                ProfilerRuntimeCPUCodeRegion.codeRegionEntry();
                ProfilerRuntimeCPUCodeRegion.codeRegionExit();
            }
            l = Timers.getCurrentTimeInCounts() - l;
            if (!printResults || i % 5 != 0) continue;
            double d = (double)l / (double)(n * 2);
            double d2 = (double)l * 1000000.0 / (double)cntInSecond / (double)(n * 2);
            ProfilerCalibrator.printResults(MessageFormat.format(TIME_COUNTS_MCS_MSG, "" + d, "" + d2));
        }
    }

    private static void measureMethodEntryExitCalls() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        switch (nCall) {
            case -1: 
            case 0: {
                bl = true;
                bl2 = false;
                break;
            }
            case 1: {
                bl = false;
                bl2 = true;
                break;
            }
            case 2: 
            case 3: {
                bl = true;
                bl2 = true;
            }
        }
        ProfilerCalibrator.printResults("\n" + MessageFormat.format(TIME_SUCCESS_PAIRS_MSG, "" + bl, "" + bl2));
        ProfilerRuntimeCPU.setTimerTypes(bl, bl2);
        int n2 = 300;
        int n3 = 200;
        int n4 = 17 * (n3 * 4 + 2) * 5 / 4;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (nCall == -1) {
            buf = new byte[2 * n4];
        }
        threadInfo.setEvBuf(buf);
        ProfilerRuntime.eventBuffer = buf;
        ProfilerRuntime.globalEvBufPosThreshold = buf.length;
        if (nCall != 3) {
            minTimePerMethodEntryExitCallInMCS = 100000.0;
            minTimePerMethodEntryExitCallInCounts = 1000000.0;
            cycleWhenMinResultDetected = 1;
            for (n = 0; n < n2; ++n) {
                threadInfo.evBufPos = (cycleWhenMinResultDetected + 1) % 2 * n4;
                ProfilerRuntimeCPUFullInstr.rootMethodEntry('\u0001');
                long l = Timers.getCurrentTimeInCounts();
                for (int i = 0; i < n3; ++i) {
                    ProfilerRuntimeCPUFullInstr.methodEntry('\u0002');
                    ProfilerRuntimeCPUFullInstr.methodExit('\u0002');
                    ProfilerRuntimeCPUFullInstr.methodEntry('\u0003');
                    ProfilerRuntimeCPUFullInstr.methodExit('\u0003');
                }
                l = Timers.getCurrentTimeInCounts() - l;
                ProfilerRuntimeCPUFullInstr.methodExit('\u0001');
                double d = (double)l / (double)(n3 * 2);
                double d2 = (double)l * 1000000.0 / (double)cntInSecond / (double)(n3 * 2);
                if (d < minTimePerMethodEntryExitCallInCounts) {
                    minTimePerMethodEntryExitCallInCounts = d;
                    minTimePerMethodEntryExitCallInMCS = d2;
                    cycleWhenMinResultDetected = (cycleWhenMinResultDetected + 1) % 2;
                }
                if (!printResults || n % 5 != 0) continue;
                ProfilerCalibrator.printResults(MessageFormat.format(TIME_COUNTS_MCS_MSG, "" + d, "" + d2));
            }
            ProfilerCalibrator.printResults(MessageFormat.format(MINIMUM_TIME_MSG, "" + minTimePerMethodEntryExitCallInCounts, "" + minTimePerMethodEntryExitCallInMCS));
        }
        ProfilerCalibrator.printResults("\n" + INNER_OUTER_TIME_MSG);
        if (nCall != 1 && nCall != 3) {
            n = 10 + (nCall >= 2 ? 7 : 0);
            int n5 = cycleWhenMinResultDetected * n4 + 1 * n;
            int n6 = n3 * 4;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            boolean bl3 = false;
            int n7 = 3 + (nCall == 3 ? 7 : 0);
            int n8 = nCall == 2 ? 7 : 0;
            for (int i = 0; i < n6; ++i) {
                long l4;
                byte by = buf[n5];
                if (bl3 && by != 7) {
                    System.out.println("Problem with inner! " + by + ", curPos = " + n5);
                } else if (!bl3 && by != 6) {
                    System.out.println("Problem with outer! " + by + ", curPos = " + n5);
                }
                n5 += n7;
                long l5 = ((long)buf[n5++] & 0xFFL) << 48 | ((long)buf[n5++] & 0xFFL) << 40 | ((long)buf[n5++] & 0xFFL) << 32 | ((long)buf[n5++] & 0xFFL) << 24 | ((long)buf[n5++] & 0xFFL) << 16 | ((long)buf[n5++] & 0xFFL) << 8 | (long)buf[n5++] & 0xFFL;
                long l6 = l4 = i > 0 ? l5 - l3 : 0L;
                if (bl3) {
                    l += l4;
                } else {
                    l2 += l4;
                }
                bl3 = !bl3;
                l3 = l5;
                n5 += n8;
            }
            innerTimeInCounts = (double)l / (double)(n6 / 2);
            outerTimeInCounts = (double)l2 / (double)(n6 / 2 - 1);
        } else {
            innerTimeInCounts = outerTimeInCounts = minTimePerMethodEntryExitCallInCounts / 2.0;
        }
        double d = innerTimeInCounts * 1000000.0 / (double)cntInSecond;
        double d3 = outerTimeInCounts * 1000000.0 / (double)cntInSecond;
        ProfilerCalibrator.printResults(MessageFormat.format(INNER_TIME_MCS_MSG, "" + d));
        ProfilerCalibrator.printResults(MessageFormat.format(OUTER_TIME_MCS_MSG, "" + d3));
    }

    private static void measureSampledMethodEntryExitCalls() {
        ProfilerCalibrator.printResults("\n" + SAMPLED_TIME_MSG);
        int n = nCall == -1 ? 200 : 80;
        int n2 = 200;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        threadInfo.setEvBuf(buf);
        minTimePerMethodEntryExitCallInMCS = 100000.0;
        minTimePerMethodEntryExitCallInCounts = 1000000.0;
        for (int i = 0; i < n; ++i) {
            threadInfo.evBufPos = 0;
            ProfilerRuntimeCPUSampledInstr.rootMethodEntry('\u0001');
            long l = Timers.getCurrentTimeInCounts();
            for (int j = 0; j < n2; ++j) {
                ProfilerRuntimeCPUSampledInstr.methodEntry('\u0002');
                ProfilerRuntimeCPUSampledInstr.methodExit('\u0002');
                ProfilerRuntimeCPUSampledInstr.methodEntry('\u0003');
                ProfilerRuntimeCPUSampledInstr.methodExit('\u0003');
                ProfilerRuntimeCPUSampledInstr.methodEntry('\u0002');
                ProfilerRuntimeCPUSampledInstr.methodExit('\u0002');
                ProfilerRuntimeCPUSampledInstr.methodEntry('\u0003');
                ProfilerRuntimeCPUSampledInstr.methodExit('\u0003');
            }
            l = Timers.getCurrentTimeInCounts() - l;
            ProfilerRuntimeCPUSampledInstr.methodExit('\u0001');
            double d = (double)l / (double)(n2 * 4);
            double d2 = (double)l * 1000000.0 / (double)cntInSecond / (double)(n2 * 4);
            if (d < minTimePerMethodEntryExitCallInCounts) {
                minTimePerMethodEntryExitCallInCounts = d;
                minTimePerMethodEntryExitCallInMCS = d2;
            }
            if (!printResults || i % 5 != 0) continue;
            System.out.println(MessageFormat.format(TIME_COUNTS_MCS_MSG, "" + d, "" + d2));
        }
        innerTimeInCounts = outerTimeInCounts = minTimePerMethodEntryExitCallInCounts / 2.0;
    }

    private static void measureTimerCall(boolean bl) {
        if (bl) {
            ProfilerCalibrator.printResults(TIME_getCurrentTimeInCounts_MSG);
        } else {
            ProfilerCalibrator.printResults(TIME_getThreadCPUTimeInNanos_MSG);
        }
        int n = 1000;
        for (int i = 0; i < 50; ++i) {
            long l = Timers.getCurrentTimeInCounts();
            for (int j = 0; j < n; ++j) {
                long l2 = bl ? Timers.getCurrentTimeInCounts() : Timers.getThreadCPUTimeInNanos();
            }
            l = Timers.getCurrentTimeInCounts() - l;
            if (!printResults || i % 5 != 0) continue;
            double d = (double)l / (double)(n + 2);
            double d2 = (double)l * 1000000.0 / (double)cntInSecond / (double)(n + 2);
            ProfilerCalibrator.printResults(MessageFormat.format(TIME_COUNTS_MCS_MSG, "" + d, "" + d2));
        }
    }

    private static void printResults(String string) {
        if (printResults) {
            System.out.println(string);
        }
    }

    static {
        ResourceBundle resourceBundle = ProfilerServer.getProfilerServerResourceBundle();
        if (resourceBundle != null) {
            CANNOT_SAVE_CALIBRATION_DATA_MSG = resourceBundle.getString("ProfilerCalibrator_CannotSaveCalibrationDataMsg");
            CALIBRATION_SUCCESS_MSG = resourceBundle.getString("ProfilerCalibrator_CalibrationSuccessMsg");
            CALIBRATION_RESULTS_PREFIX = resourceBundle.getString("ProfilerCalibrator_CalibrationResultsPrefix");
            CALIBRATION_RESULTS_MSG = resourceBundle.getString("ProfilerCalibrator_CalibrationResultsMsg");
            STARTING_CALIBRATION_MSG = resourceBundle.getString("ProfilerCalibrator_StartingCalibrationMsg");
            TIMER_COUNTS_MSG = resourceBundle.getString("ProfilerCalibrator_TimerCountsMsg");
            TIMER_VALUE_MSG = resourceBundle.getString("ProfilerCalibrator_TimerValueMsg");
            INJECTION_CALIBRATION_MSG = resourceBundle.getString("ProfilerCalibrator_InjectionCalibrationMsg");
            TIME_getCurrentTimeInCounts_MSG = resourceBundle.getString("ProfilerCalibrator_TimeGetCurrentTimeInCountsMsg");
            TIME_getThreadCPUTimeInNanos_MSG = resourceBundle.getString("ProfilerCalibrator_TimeGetThreadCPUTimeInNanosMsg");
            TIME_COUNTS_MCS_MSG = resourceBundle.getString("ProfilerCalibrator_TimeCountsMcsMsg");
            TIME_SUCCESS_PAIRS_MSG = resourceBundle.getString("ProfilerCalibrator_TimeSuccessPairsMsg");
            MINIMUM_TIME_MSG = resourceBundle.getString("ProfilerCalibrator_MinimumTimeMsg");
            INNER_OUTER_TIME_MSG = resourceBundle.getString("ProfilerCalibrator_InnerOuterTimeMsg");
            INNER_TIME_MCS_MSG = resourceBundle.getString("ProfilerCalibrator_InnerTimeMcsMsg");
            OUTER_TIME_MCS_MSG = resourceBundle.getString("ProfilerCalibrator_OuterTimeMcsMsg");
            SAMPLED_TIME_MSG = resourceBundle.getString("ProfilerCalibrator_SampledTimeMsg");
            REGION_TIME_MSG = resourceBundle.getString("ProfilerCalibrator_RegionTimeMsg");
        }
    }
}

