#ifndef _SESSION_LIMIT_H_
#define _SESSION_LIMIT_H_

#include <linux/types.h>

#define MAX_SESSION_LIMIT_BY_IP_ITEM 768

struct session_limit_by_IP {
	u_int32_t ip;
	u_int32_t max_session;
	u_int32_t session_count;
	struct session_limit_by_IP *next;
};

#define MAX_SESSION_LIMIT_RANGE_ITEM 10

struct session_limit_range {
	u_int32_t start_ip;
	u_int32_t end_ip;
	u_int32_t max_session;	
};

struct session_limit_head {
	struct session_limit_by_IP *ptr;
};

#define INI_DEFAULT_MAX_SESSION 100;

struct session_limit_data {
	int enable;
	int default_max;
	struct session_limit_range range[MAX_SESSION_LIMIT_RANGE_ITEM];
};

struct session_monitor_data {
	int enable;
	int data_num;
	int total_session;
	struct session_limit_by_IP data[MAX_SESSION_LIMIT_BY_IP_ITEM];
};

#endif	/* _SESSION_RATE_LIMIT_H */
