#include "stdhead.h"
#include "solicit.h"
#include "clilib.h"
#include "parse.h"

struct DHCP_MESSAGE * create_solicit_message (char *interface_name)
{
    struct DHCP_MESSAGE * dhcp_message_ptr = malloc (sizeof (struct DHCP_MESSAGE));
    struct OPTIONS *opt_ptr;
    struct interface *interface_details;

    interface_details = get_interface_details (interface_name);
#if DEBUG == 2    
    print_interface_details (interface_details);
#endif
    dhcp_message_ptr -> u_msg_type.msg_type = SOLICIT;
    generate_trans_id (&dhcp_message_ptr -> u_trans_id.trans_id);
    dhcp_message_ptr -> opt = add_client_id_option (interface_details);
    
    opt_ptr = (struct OPTIONS *) dhcp_message_ptr -> opt;
    ((struct DUID *) opt_ptr -> opt_data) -> opt = add_ia_option (interface_details);
    return dhcp_message_ptr;
}

struct OPTIONS * add_ia_option (struct interface *interface_details)
{
    struct OPTIONS *options, *iaaddr_options;
    struct IA *ia_ptr;
    int i;
    
    options = (struct OPTIONS *) malloc (sizeof (struct OPTIONS));
    options -> u_opt_code.opt_code = OPTION_IA;   //ia mode
    
    ia_ptr = (struct IA *) malloc (sizeof (struct IA));
    options -> opt_data = ia_ptr;
    
    // IAID is derived from the lower 4 bytes of the hardware address (unique)
    for (i = 0; i < 4; i++){
	    ia_ptr -> u_iaid.buffer[i] = interface_details -> haddr[interface_details -> haddr_len - i - 1];
    }

    //follow dibbler, i set T1 and T2 = infinity...   bruce
    //ia_ptr -> u_t1.t1 = ia_ptr -> u_t2.t2 = ia_ptr -> status = 0;
    ia_ptr ->u_t1.t1=0xffffffff;
    ia_ptr ->u_t2.t2=0xffffffff;

    //iaaddr_options = add_ia_addr_option (interface_details);
    //ia_ptr -> opt = iaaddr_options;
    ia_ptr -> opt=NULL;
    
    //	IAID = 4 octets
    // 	T1 = 4 octets
    //	T2 = 4 octets
    //	Status = 1 octet    
    //options -> u_opt_len.opt_len = iaaddr_options -> u_opt_len.opt_len + 4 + 4 + 4 + 1;
    //i don't know what is state, and what is iaaddr????
    //but i know the length is wrong, i change it to 4+4+4
    options -> u_opt_len.opt_len = 4 + 4 + 4; 
    printf("\nLen2: %d",options -> u_opt_len.opt_len);
    return options;
}

struct OPTIONS * add_ia_addr_option (struct interface *interface_details)
{
    struct OPTIONS *options;
    struct IA_ADDRESS *ia_addr_ptr;
    int i;
    
    options = (struct OPTIONS *) malloc (sizeof (struct OPTIONS));
    options -> u_opt_code.opt_code = OPTION_IAADDR;
    
    // Temporary bit + address status = 1 octet
    // Prefix length = 1 octet
    // IPv6 address = 16 octets
    // Preferred lifetime = 4 octets
    // Valid lifetime = 4 octets
    options -> u_opt_len.opt_len = 1 + 1 + 16 + 4 + 4;
    ia_addr_ptr = (struct IA_ADDRESS *) malloc (sizeof (struct IA_ADDRESS));
    options -> opt_data = ia_addr_ptr;
    
    ia_addr_ptr -> t_bit = ia_addr_ptr -> addr_status = ia_addr_ptr -> prefix_length = 0;
    ia_addr_ptr -> u_pref_lifetime.pref_lifetime = interface_details -> pref_lifetime;
    ia_addr_ptr -> u_valid_lifetime.valid_lifetime = interface_details -> valid_lifetime;
    ia_addr_ptr -> ia_addr_opt = ia_addr_ptr -> opt = 0;
    
    for (i = 0; i < 16; i++)
    {
	if (interface_details -> pref_ipv6_addr)
	    ia_addr_ptr -> addr[i] = interface_details -> pref_ipv6_addr -> s6_addr[i];
	else
	    ia_addr_ptr -> addr[i] = 0;
    }
    
    return options;
}

struct DUID * add_duid (u_int16_t *option_len, struct interface *interface_details)
{
    struct DUID *duid_ptr;
    struct DUID1 *duid1_ptr;
    struct DUID2 *duid2_ptr;
    struct DUID3 *duid3_ptr;
    int i;
    int j=0, k=0;
    
    duid_ptr = (struct DUID *) malloc (sizeof (struct DUID));
    duid_ptr -> u_duid_type.duid_type = interface_details -> duid_type;
    
    if (interface_details -> duid_type == 1)
    {
	duid1_ptr = (struct DUID1 *) malloc (sizeof (struct DUID1));
	duid_ptr -> duid_type = duid1_ptr;
	
	duid1_ptr -> u_haddr_type.haddr_type = interface_details -> haddr_type;
	duid1_ptr -> u_time.time = interface_details -> time;
	duid1_ptr -> haddr_len = interface_details -> haddr_len;
	
	duid1_ptr -> link_layer_address = (u_int8_t *) malloc (interface_details -> haddr_len * sizeof (u_int8_t));
    printf("\nlen11: %d",interface_details -> haddr_len);
    for (i = 0; i < interface_details -> haddr_len; i++){
	    duid1_ptr -> link_layer_address[i] = interface_details -> haddr[i];
    }

    printf("\n111111mac:");
    for(j=0;j<6;j++){
        printf("%x ", interface_details->haddr[j]);
    }
    printf("\n33333mac:");
    for(k=0;k<6;k++){
        printf("%x ", duid1_ptr->link_layer_address[k]);
    }
    printf("\n");
	// Hardware type = 2 octets
	// Time = 4 octets
	// Link layer address = variable
	*option_len = 2 + 4 + interface_details -> haddr_len;
    }
    else if (interface_details -> duid_type == 2)
    {
	duid2_ptr = (struct DUID2 *) malloc (sizeof (struct DUID2));
	duid_ptr -> duid_type = duid2_ptr;
	
	duid2_ptr -> u_identifier_length.identifier_length = interface_details -> identifier_length;
	duid2_ptr -> identifier = (u_int8_t *) malloc (interface_details -> identifier_length * sizeof (u_int8_t));
	for (i = 0; i < interface_details -> identifier_length; i++)
	    duid2_ptr -> identifier[i] = interface_details -> identifier[i];
	
	duid2_ptr -> domain_name_len = interface_details -> domain_name_len;
	duid2_ptr -> domain_name = (char *) malloc (interface_details -> domain_name_len * sizeof (char));
	for (i = 0; i < interface_details -> domain_name_len; i++)
	    duid2_ptr -> domain_name[i] = interface_details -> domain_name[i];
	    
	// Identifier length = 2 octets
	// Identifier = variable
	// Domain name = variable
	*option_len = 2 + interface_details -> identifier_length + interface_details -> domain_name_len;
    }
    else if (interface_details -> duid_type == 3)
    {
	duid3_ptr = (struct DUID3 *) malloc (sizeof (struct DUID3));
	duid_ptr -> duid_type = duid3_ptr;
	
	duid3_ptr -> u_haddr_type.haddr_type = interface_details -> haddr_type;
	duid3_ptr -> link_layer_address = (u_int8_t *) malloc (interface_details -> haddr_len * sizeof (u_int8_t));
	duid3_ptr -> haddr_len = interface_details -> haddr_len;
	for (i = 0; i < interface_details -> haddr_len; i++){
	    duid3_ptr -> link_layer_address[i] = interface_details -> haddr[i];
    }
    printf("\n111111mac:");
    for(i=0;i<6;i++){
        printf("%x ", interface_details -> haddr[i]);
    }
    printf("\n22222mac:");
    for(i=0;i<6;i++){
        printf("%x ", duid3_ptr -> link_layer_address[i]);
    }
	// Hardware type = 2 octets
	// Link layer address = variable
	*option_len = 2 + interface_details -> haddr_len;
    }
    
    return duid_ptr;
}

struct OPTIONS * add_client_id_option (struct interface *interface_details)
{
    struct OPTIONS *options;
    
    options = (struct OPTIONS *) malloc (sizeof (struct OPTIONS));
    options -> u_opt_code.opt_code = OPTION_CLIENTID;
    options -> opt_data = add_duid (&options -> u_opt_len.opt_len, interface_details);
    
    // Type of DUID = 2
    options -> u_opt_len.opt_len += 2;
    return options;
}
