#!/bin/sh
append DRIVERS "rt2880r"

read_rt2880r_var() {
CFG_FILE=/etc/Wireless/RT2880/iNIC_RGMII_ap.dat
APD=rt2880rapd
CHIPID=
RT_TYPE=rt2880r
RT_DRIVER=rt2880_iNIC_rgmii
RT_IFNAME=ra_r0
}

modify_rt2880r_ralink_cfgfile() {
	read_rt2880r_var
	
	cat $CFG_FILE | grep -q "$1=$2" && return 0
	
	local str=$(cat $CFG_FILE | grep "$1=")
	sed 's/'"$str"'/'"$1=$2"'/' $CFG_FILE > /tmp/cfg.dat
	cp /tmp/cfg.dat $CFG_FILE
}

check_rt2860() {
    local devid
    devid=$(cat /proc/bus/pci/devices | cut -f2)
    echo "$devid" | grep -q 18140601 && return 0
    retun 1
}

check_rt2880() {
    local devid
    devid=$(cat /proc/bus/pci/devices | cut -f2)
    echo "$devid" | grep -q 18140801 && return 0
    retun 1
}

scan_rt2880r() {
	local device="$1"
	local wds
	local adhoc sta ap
	
	config_get vifs "$device" vifs
	for vif in $vifs; do
	
		config_get ifname "$vif" ifname
		config_set "$vif" ifname "${ifname:-ra}"
		
		config_get mode "$vif" mode
		case "$mode" in
			ap)
				append $mode "$vif"
			;;
			*) echo "$device($vif): Invalid mode, ignored."; continue;;
		esac
	done

	config_set "$device" vifs "${ap:+$ap }${adhoc:+$adhoc }${ahdemo:+$ahdemo }${sta:+$sta }${wds:+$wds }"
}

disable_rt2880r() (
    read_rt2880r_var

	local device="$1"

	killall $APD

	set_wifi_down "$device"
	include /lib/network
	ifconfig $RT_IFNAME down
	#unbridge $RT_IFNAME

	return 0
)

enable_rt2880r() {
    read_rt2880r_var

	local device="$1"
	config_get channel "$device" channel
	config_get vifs "$device" vifs
	config_get radio "$device" radio
	config_get mode "$device" mode
	config_get region "$device" region

	lsmod | grep -q $RT_DRIVER || insmod $RT_DRIVER mode=ap

	local first=1
	for vif in $vifs; do
		local up=0
		if [ -f /var/state/wireless ]; then
			up=$(uci get /var/state/wireless.$vif.up)
			up="${up:-0}"
		fi

		config_get enc "$vif" encryption
		config_get wpamode "$vif" wpamode
		config_get wpa_crypto "$vif" wpa_crypto
		config_get ssid "$vif" ssid
		config_get disabled "$vif" disabled
		config_get drivermode "$vif" mode
		config_get hidden "$vif" hidden
		
		ifname=$RT_IFNAME
		
		config_set "$vif" ifname "$ifname"

		case "$mode" in
			11bgn)
				modify_rt2880r_ralink_cfgfile "CountryRegion" "$region"
				modify_rt2880r_ralink_cfgfile "WirelessMode" "9"
			;;
			11an)
				modify_rt2880r_ralink_cfgfile "CountryRegionABand" "$region"
				modify_rt2880r_ralink_cfgfile "WirelessMode" "8"
			;;
		esac

		if [ $channel == "0" ]; then
			modify_rt2880r_ralink_cfgfile "AutoChannelSelect" "1"
		else
			modify_rt2880r_ralink_cfgfile "AutoChannelSelect" "0"
		fi

		/* something must be done before interface up */
		case "$enc" in
			WPA|wpa|WPA2|wpa2|WPA1WPA2|wpa1wpa2)
				config_get wpa_crypto "$vif" wpa_crypto
				config_get key "$vif" key
				config_get server "$vif" server
				config_get port "$vif" port
				config_get timeout "$vif" timeout
				
				modify_rt2880r_ralink_cfgfile "RADIUS_Server" "$server"
				modify_rt2880r_ralink_cfgfile "RADIUS_Port" "$port"
				modify_rt2880r_ralink_cfgfile "RADIUS_Key" "$key"
				
				if check_rt2860 || check_rt2880; then
					modify_rt2880r_ralink_cfgfile "EAPifname" "br-lan"
					modify_rt2880r_ralink_cfgfile "PreAuthifname" "br-lan"
				else
					modify_rt2880r_ralink_cfgfile "EAPifname" "eth0"
					modify_rt2880r_ralink_cfgfile "PreAuthifname" "eth0"
				fi
				modify_rt2880r_ralink_cfgfile "own_ip_addr" "$(uci get network.lan.ipaddr)"
			;;
		esac

		ifconfig "$ifname" up

		#if [ $up == "0" ]; then
		#	local net_cfg bridge
		#	net_cfg="$(find_net_config "$vif")"
		#	[ -z "$net_cfg" ] || {
		#		bridge="$(bridge_interface "$net_cfg")"
		#		config_set "$vif" bridge "$bridge"
		#		start_net "$ifname" "$net_cfg"
		#	}
		#fi

		case "$enc" in
			NONE|none)
				iwpriv "$ifname" set AuthMode=OPEN
				iwpriv "$ifname" set EncrypType=NONE
				iwpriv "$ifname" set IEEE8021X=0
				iwpriv "$ifname" set SSID=$ssid
			;;
			WEP|wep)
				config_get wepauth "$vif" wepauth
				case "$wepauth" in
					OPEN|open) iwpriv "$ifname" set AuthMode=OPEN;;
				        SHARED|shared) iwpriv "$ifname" set AuthMode=SHARED;;
				esac
				iwpriv "$ifname" set EncrypType=WEP
				iwpriv "$ifname" set IEEE8021X=0
				for idx in 1 2 3 4; do
					config_get key "$vif" "key${idx}"
					config_get keytype "$vif" "key${idx}type"
					key="${key:-1}"
					iwpriv "$ifname" set "Key$idx"=$key
				done
				config_get key "$vif" key
				key="${key:-1}"
				case "$key" in
					[1234]) iwpriv "$ifname" set DefaultKeyID=$key;;
					*) iwpriv "$ifname" set DefaultKeyID=1;;
				esac
				iwpriv "$ifname" set SSID=$ssid
			;;
			PSK|psk|PSK2|psk2|PSKPSK2|pskpsk2)
				config_get wpa_crypto "$vif" wpa_crypto
				config_get key "$vif" key

				case "$enc" in
					PSK|psk)	iwpriv "$ifname" set AuthMode=WPAPSK;;
					PSK2|psk2)	iwpriv "$ifname" set AuthMode=WPA2PSK;;
					psk_auto|psk_auto)	iwpriv "$ifname" set AuthMode=WPAPSKWPA2PSK;;
				esac
				
				case "$wpa_crypto" in
					TKIP|tkip)
						iwpriv "$ifname" set EncrypType=TKIP
						iwpriv "$ifname" set IEEE8021X=0
						iwpriv "$ifname" set SSID=$ssid
						iwpriv "$ifname" set WPAPSK="$key"
						iwpriv "$ifname" set DefaultKeyID=2
						iwpriv "$ifname" set SSID=$ssid
					;;
					AES|aes)
						iwpriv "$ifname" set EncrypType=AES
						iwpriv "$ifname" set IEEE8021X=0
						iwpriv "$ifname" set WPAPSK="$key"
						iwpriv "$ifname" set DefaultKeyID=2
						iwpriv "$ifname" set SSID=$ssid
					;;
					TKIPAES|tkipaes)
						iwpriv "$ifname" set EncrypType=TKIPAES
						iwpriv "$ifname" set IEEE8021X=0
						iwpriv "$ifname" set SSID=$ssid
						iwpriv "$ifname" set WPAPSK="$key"
						iwpriv "$ifname" set DefaultKeyID=2
						iwpriv "$ifname" set SSID=$ssid
					;;
				esac
			;;
			WPA|wpa|WPA2|wpa2|WPA1WPA2|wpa1wpa2)

				case "$enc" in
					WPA|wpa)    iwpriv "$ifname" set AuthMode=WPA;;
					WPA2|wpa2)  iwpriv "$ifname" set AuthMode=WPA2;;
					WPA1WPA2|wpa1wpa2) iwpriv "$ifname" set AuthMode=WPA1WPA2;;
				esac

				case "$wpa_crypto" in
					TKIP|tkip) iwpriv "$ifname" set EncrypType=TKIP;;
					AES|aes) iwpriv "$ifname" set EncrypType=AES;;
					TKIPAES|tkipaes) iwpriv "$ifname" set EncrypType=TKIPAES;;
				esac

				iwpriv "$ifname" set IEEE8021X=0
				/usr/sbin/$APD

				iwpriv "$ifname" set SSID=$ssid
			;;
		esac

	if [ $channel -ne 0 ]; then
		case "$mode" in
			11bgn)
				iwpriv "$ifname" set WirelessMode=9
				#iwpriv "$ifname" set CountryRegion=$region
			;;
			11an)
				iwpriv "$ifname" set WirelessMode=8
				#iwpriv "$ifname" set CountryRegionABand=$region
			;;
		esac
		iwpriv "$ifname" set Channel=$channel
	fi
	iwpriv "$ifname" set HideSSID=$hidden
	iwpriv "$ifname" set RadioOn=$radio
	iwpriv "$ifname" set SSID="$ssid"
		
	if [ $up == "0" ]; then
		set_wifi_up "$vif" "$ifname"
	fi

	first=0
	done
}

detect_rt2880r() {
	read_rt2880r_var

	[ $(/usr/sbin/rt2880_rgmii_check) = "yes" ] || return
	config_get type $RT_IFNAME type
	[ "$type" = $RT_TYPE ] && return
	#uci set network.lan.type=bridge 
	#uci commit network
	local wifi_mode
	local wifi_channel
	wifi_mode=11bgn
	wifi_channel=11
	check_rt2860 && wifi_mode=11an && wifi_channel=36
	check_rt2880 && wifi_mode=11an && wifi_channel=36
		cat <<EOF
config wifi-device  $RT_IFNAME
	option type     $RT_TYPE
	option channel  $wifi_channel
	option radio    1
	option mode     $wifi_mode
	option region   0
	option disabled 0
config wifi-iface
	option device	$RT_IFNAME
	option mode	ap
	option ssid	GROCX
	option hidden	0
	option encryption none
EOF

}
