# This script will be invoke to check WAN IP for HNAT

local shnat_mode=$(uci get router.shnat.enable)
local rtn=1
local cnt=0
MAXCOUNT=20

if [ $shnat_mode = 1 ] ; then

while [ $rtn == 1 -a "$cnt" -le $MAXCOUNT ]
do
	sleep 6
	let "cnt += 1"
	local wantype=$(uci get network.wan.proto)

	if [ "$wantype" = "static" ] ; then
		local wanip=$(uci get network.wan.ipaddr)
		echo "wanip list" | shnat_cli | grep -q "$wanip" > /dev/null && return || /bin/echo "wanip set ip:"$wanip"" | shnat_cli > /dev/null
		echo "wanip list" | shnat_cli | grep -q "$wanip" > /dev/null
		rtn=$?
	elif [ "$wantype" = "pppoe" ] ; then
		local LIP=$(ifconfig ppp0 | grep inet | cut -d : -f 2 | cut -d " " -f 1)
		echo "pppoe list" | shnat_cli | grep -q "$LIP" > /dev/null && return || sh /etc/setup_shnat_pppoe.sh > /tmp/re
		echo "pppoe list" | shnat_cli | grep -q "$LIP" > /dev/null
		rtn=$?
	elif [ "$wantype" = "dhcp" ] ; then
		local WIP=$(ifconfig eth1 | grep inet | cut -d : -f 2 | cut -d " " -f 1)
		echo "wanip list" | shnat_cli | grep -q "$WIP" > /dev/null && return || /bin/echo "wanip set ip:"$WIP"" | shnat_cli > /dev/null
		echo "wanip list" | shnat_cli | grep -q "$WIP" > /dev/null
		rtn=$?		
	else
		return
	fi
	logger "set wan ip for HNAT...retry: $cnt"
	if [ $rtn == 0 ]; then
		return
	fi
	
done
	logger "set wan ip for HNAT failed..."
fi
