#!/bin/sh

awk -f /usr/lib/common.awk -f - $* <<EOF
BEGIN {
        ipsplit(ARGV[1],ipaddr)
	ipsplit(ARGV[2],netmask)
	ipsplit(ARGV[3],starts)
	num=ARGV[4] - 1

	ipand(ipaddr,netmask,network)
	ipcompl(netmask,complement)
	ipor(network,complement,broadcast)

	ipand(starts,complement,temp)
	ipor(network,temp,start)
	ipadd(network,1,limit)
	if (ipgt(limit,start) == 1) start=limit;

	ipadd(start,num,end)
	ipor(network,complement,temp)
	ipadd(temp,-1,limit)
	if (ipgt(end,limit) == 1) {
		ipadd(limit,0,end)
	}

	print "IP="ipunsplit(ipaddr)
	print "NETMASK="ipunsplit(netmask)
	print "BROADCAST="ipunsplit(broadcast)
	print "NETWORK="ipunsplit(network)
	# print "PREFIX="ipunsplit(prefix)

	# range calculations:
	# ipcalc <ip> <netmask> <start> <num>

	if (ARGC > 3) {
		print "START="ipunsplit(start)
		print "END="ipunsplit(end)
	}
}
EOF
