#!/bin/sh

#####====MAIL/SMS ALERT CODE====#####
#WAN_UP					1			#
#WAN_DOWN				2			#
#VOIP_WAN_UP			3			#
#VOIP_WAN_DOWN			4			#
#IPTV_WAN_UP			5			#
#IPTV_WAN_DOWN			6			#
#MANAGEMENT_WAN_UP		7			#
#MANAGEMENT_WAN_DOWN	8			#
#v3G_BACKUP_WAN_UP		9			#
#v3G_BACKUP_WAN_DOWN	10			#
#####################################

module=$(uci -q get system.@system[0].hostname)

WAN_UP_MSG="$module WAN UP."
WAN_DOWN_MSG="$module WAN DOWN."
VOIP_WAN_UP_MSG="$module VoIP WAN UP."
VOIP_WAN_DOWN_MSG="$module VoIP WAN DOWN."
IPTV_WAN_UP_MSG="$module IPTV WAN UP."
IPTV_WAN_DOWN_MSG="$module IPTV WAN DOWN."
MANAGEMENT_WAN_UP_MSG="$module Management WAN UP."
MANAGEMENT_WAN_DOWN_MSG="$module Management WAN DOWN."
v3G_BACKUP_WAN_UP_MSG="$module 3G Backup WAN UP."
v3G_BACKUP_WAN_DOWN_MSG="$module 3G Backup WAN DOWN."

SUBJECT="DrayTek Mail Alert."  #Subject for mail alert use

ALERTTYPE=$1
EVENT=$2
SMSINDEX=$3
current_time=$(date +"%b-%d %T")
SMS_ALERT_LOG=/tmp/sms_alert.log
case $EVENT in
	"1")
		MSG="$WAN_UP_MSG"
	;;
	"2")
		MSG="$WAN_DOWN_MSG"
	;;
	"3")
		MSG="$VOIP_WAN_UP_MSG"
	;;
	"4")
		MSG="$VOIP_WAN_DOWN_MSG"
	;;
	"5")
		MSG="$IPTV_WAN_UP_MSG"
	;;
	"6")
		MSG="$IPTV_WAN_DOWN_MSG"
	;;
	"7")
		MSG="$MANAGEMENT_WAN_UP_MSG"
	;;
	"8")
		MSG="$MANAGEMENT_WAN_DOWN_MSG"
	;;
	"9")
		MSG="$v3G_BACKUP_WAN_UP_MSG"
	;;
	"10")
		MSG="$v3G_BACKUP_WAN_DOWN_MSG"
	;;
	*)
		return 0
	;;
esac

send_mail(){
	logger -p 160.5 "prepare to send mail. $MSG."
	sh /sbin/mail-alert.sh 'Draytek' '2130' '1' "$SUBJECT" "$MSG" 2>/dev/console
}

send_SMS(){
	if [ -n $SMSINDEX ]; then
			echo "$current_time" > /tmp/current_time
			current_time=$(sed 's/ /+/g' /tmp/current_time) #change space to URI encode
			rm /tmp/current_time
			
			echo "$MSG" > /tmp/MSG
			MSG=$(sed 's/ /+/g' /tmp/MSG) #change space to URI encode
			rm /tmp/MSG
			
			if [ -f $SMS_ALERT_LOG ];then
				#if there has a same event smslog, cancel this sequence.
				resend_status=$(cat $SMS_ALERT_LOG | awk 'FS="|" {print $4}')
				[ "$resend_status" == "$MSG" ] && return 0
			fi
			DEFAULT_MSG=`uci -q get sms.s$SMSINDEX.ascii_encode`
			logger -p 160.5 "prepare to send SMS. EVENT:$EVENT."
			if [ -z $DEFAULT_MSG ]; then
				DEFAULT_MSG=$MSG
			fi
			DEFAULT_MSG="$DEFAULT_MSG($current_time)"
			
			#$1=sms profile index,$2=default msg, $3=flag for retry
			sh /usr/lib/ddns/sms_updater.sh "$SMSINDEX" "$DEFAULT_MSG" "$MSG" >/dev/console 
	else
		return 0
	fi
}

case $ALERTTYPE in
	"MAIL")
		send_mail
	;;
	"SMS")
		send_SMS
	;;
	"ALL")
		send_mail
		send_SMS
	;;
	*)
		return 0
	;;
esac

return 0