/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkManager;
import com.android.sdklib.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ImportTask;
import org.apache.tools.ant.types.Path;
import org.xml.sax.InputSource;

public final class SetupTask
extends ImportTask {
    private static final String ANDROID_RULES = "android_rules.xml";
    private static final String PROPERTY_ANDROID_JAR = "android-jar";
    private static final String PROPERTY_ANDROID_AIDL = "android-aidl";
    private static final String PROPERTY_AAPT = "aapt";
    private static final String PROPERTY_AIDL = "aidl";
    private static final String PROPERTY_DX = "dx";
    private static final String REF_CLASSPATH = "android.target.classpath";
    private boolean mDoImport = true;

    public void execute() throws BuildException {
        Project antProject = this.getProject();
        String sdkLocation = antProject.getProperty("sdk-location");
        if (sdkLocation == null || sdkLocation.length() == 0) {
            throw new BuildException("SDK Location is not set.");
        }
        File sdk = new File(sdkLocation);
        if (!sdk.isDirectory()) {
            throw new BuildException(String.format("SDK Location '%s' is not valid.", sdkLocation));
        }
        String targetHashString = antProject.getProperty("target");
        if (targetHashString == null) {
            throw new BuildException("Android Target is not set.");
        }
        final ArrayList messages = new ArrayList();
        SdkManager manager = SdkManager.createManager((String)sdkLocation, (ISdkLog)new ISdkLog(){

            public void error(Throwable t, String errorFormat, Object ... args) {
                if (errorFormat != null) {
                    messages.add(String.format("Error: " + errorFormat, args));
                }
                if (t != null) {
                    messages.add("Error: " + t.getMessage());
                }
            }

            public void printf(String msgFormat, Object ... args) {
                messages.add(String.format(msgFormat, args));
            }

            public void warning(String warningFormat, Object ... args) {
                messages.add(String.format("Warning: " + warningFormat, args));
            }
        });
        if (manager == null) {
            for (String msg : messages) {
                System.out.println(msg);
            }
            throw new BuildException("Failed to parse SDK content.");
        }
        IAndroidTarget androidTarget = manager.getTargetFromHashString(targetHashString);
        if (androidTarget == null) {
            throw new BuildException(String.format("Unable to resolve target '%s'", targetHashString));
        }
        System.out.println("Project Target: " + androidTarget.getName());
        if (!androidTarget.isPlatform()) {
            System.out.println("Vendor: " + androidTarget.getVendor());
            System.out.println("Platform Version: " + androidTarget.getVersionName());
        }
        System.out.println("API level: " + androidTarget.getVersion().getApiString());
        if (androidTarget.getVersion().isPreview()) {
            this.checkManifest(antProject, androidTarget.getVersion().getCodename());
        }
        String androidJar = androidTarget.getPath(1);
        antProject.setProperty(PROPERTY_ANDROID_JAR, androidJar);
        antProject.setProperty(PROPERTY_ANDROID_AIDL, androidTarget.getPath(2));
        antProject.setProperty(PROPERTY_AAPT, androidTarget.getPath(20));
        antProject.setProperty(PROPERTY_AIDL, androidTarget.getPath(21));
        antProject.setProperty(PROPERTY_DX, androidTarget.getPath(22));
        Path bootclasspath = new Path(antProject);
        Path.PathElement element = bootclasspath.createPathElement();
        element.setPath(androidJar);
        IAndroidTarget.IOptionalLibrary[] libraries = androidTarget.getOptionalLibraries();
        if (libraries != null) {
            HashSet<String> visitedJars = new HashSet<String>();
            for (IAndroidTarget.IOptionalLibrary library : libraries) {
                String jarPath = library.getJarPath();
                if (visitedJars.contains(jarPath)) continue;
                visitedJars.add(jarPath);
                element = bootclasspath.createPathElement();
                element.setPath(library.getJarPath());
            }
        }
        antProject.addReference(REF_CLASSPATH, (Object)bootclasspath);
        String templateFolder = androidTarget.getPath(6);
        if (this.mDoImport) {
            File templates = new File(templateFolder);
            if (!templates.isDirectory()) {
                throw new BuildException(String.format("Template directory '%s' is missing.", templateFolder));
            }
            File rules = new File(templateFolder, ANDROID_RULES);
            if (!rules.isFile()) {
                throw new BuildException(String.format("Build rules file '%s' is missing.", templateFolder));
            }
            this.setFile(rules.getAbsolutePath());
            super.execute();
        }
    }

    public void setImport(boolean value) {
        this.mDoImport = value;
    }

    private void checkManifest(Project antProject, String codename) {
        try {
            File manifest = new File(antProject.getBaseDir(), "AndroidManifest.xml");
            XPath xPath = AndroidXPathFactory.newXPath();
            String value = xPath.evaluate("/manifest/uses-sdk/@android:minSdkVersion", new InputSource(new FileInputStream(manifest)));
            if (!codename.equals(value)) {
                throw new BuildException(String.format("For '%1$s' SDK Preview, application manifest must declare minSdkVersion to '%1$s'", codename));
            }
        }
        catch (XPathExpressionException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

