/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.IImageLoader;
import com.android.ddmuilib.ITableFocusListener;
import com.android.ddmuilib.SelectionDependentPanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.logcat.EditFilterDialog;
import com.android.ddmuilib.logcat.LogColors;
import com.android.ddmuilib.logcat.LogFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LogPanel
extends SelectionDependentPanel {
    private static final int STRING_BUFFER_LENGTH = 10000;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_MANUAL = 1;
    public static final int FILTER_AUTO_PID = 2;
    public static final int FILTER_AUTO_TAG = 3;
    public static final int FILTER_DEBUG = 4;
    public static final int COLUMN_MODE_MANUAL = 0;
    public static final int COLUMN_MODE_AUTO = 1;
    public static String PREFS_TIME;
    public static String PREFS_LEVEL;
    public static String PREFS_PID;
    public static String PREFS_TAG;
    public static String PREFS_MESSAGE;
    private static Pattern sLogPattern;
    private Composite mParent;
    private IPreferenceStore mStore;
    private TabFolder mFolders;
    private LogColors mColors;
    private ILogFilterStorageManager mFilterStorage;
    private LogCatOuputReceiver mCurrentLogCat;
    private LogMessage[] mBuffer = new LogMessage[10000];
    private int mBufferStart = -1;
    private int mBufferEnd = -1;
    private LogFilter[] mFilters;
    private LogFilter mDefaultFilter;
    private LogFilter mCurrentFilter;
    private int mFilterMode = 0;
    private IDevice mCurrentLoggedDevice = null;
    private ICommonAction mDeleteFilterAction;
    private ICommonAction mEditFilterAction;
    private ICommonAction[] mLogLevelActions;
    private LogMessageInfo mLastMessageInfo = null;
    private boolean mPendingAsyncRefresh = false;
    private IImageLoader mImageLoader;
    private String mDefaultLogSave;
    private int mColumnMode = 0;
    private Font mDisplayFont;
    private ITableFocusListener mGlobalListener;

    public LogPanel(IImageLoader imageLoader, LogColors colors, ILogFilterStorageManager filterStorage, int mode) {
        this.mImageLoader = imageLoader;
        this.mColors = colors;
        this.mFilterMode = mode;
        this.mFilterStorage = filterStorage;
        this.mStore = DdmUiPreferences.getStore();
    }

    public void setActions(ICommonAction deleteAction, ICommonAction editAction, ICommonAction[] logLevelActions) {
        this.mDeleteFilterAction = deleteAction;
        this.mEditFilterAction = editAction;
        this.mLogLevelActions = logLevelActions;
    }

    public void setColumnMode(int mode) {
        this.mColumnMode = mode;
    }

    public void setFont(Font font) {
        Table table;
        this.mDisplayFont = font;
        if (this.mFilters != null) {
            for (LogFilter f : this.mFilters) {
                Table table2 = f.getTable();
                if (table2 == null) continue;
                table2.setFont(font);
            }
        }
        if (this.mDefaultFilter != null && (table = this.mDefaultFilter.getTable()) != null) {
            table.setFont(font);
        }
    }

    public void deviceSelected() {
        this.startLogCat(this.getCurrentDevice());
    }

    public void clientSelected() {
    }

    protected Control createControl(Composite parent) {
        this.mParent = parent;
        Composite top = new Composite(parent, 0);
        top.setLayoutData((Object)new GridData(1808));
        top.setLayout((Layout)new GridLayout(1, false));
        this.mFolders = new TabFolder(top, 0);
        this.mFolders.setLayoutData((Object)new GridData(1808));
        this.mFolders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LogPanel.this.mCurrentFilter != null) {
                    LogPanel.this.mCurrentFilter.setSelectedState(false);
                }
                LogPanel.this.mCurrentFilter = LogPanel.this.getCurrentFilter();
                LogPanel.this.mCurrentFilter.setSelectedState(true);
                LogPanel.this.updateColumns(LogPanel.this.mCurrentFilter.getTable());
                if (LogPanel.this.mCurrentFilter.getTempFilterStatus()) {
                    LogPanel.this.initFilter(LogPanel.this.mCurrentFilter);
                }
                LogPanel.this.selectionChanged(LogPanel.this.mCurrentFilter);
            }
        });
        Composite bottom = new Composite(top, 0);
        bottom.setLayoutData((Object)new GridData(768));
        bottom.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(bottom, 0);
        label.setText("Filter:");
        final Text filterText = new Text(bottom, 2052);
        filterText.setLayoutData((Object)new GridData(768));
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogPanel.this.updateFilteringWith(filterText.getText());
            }
        });
        this.createFilters();
        int index = 0;
        if (this.mDefaultFilter != null) {
            this.createTab(this.mDefaultFilter, index++, false);
        }
        if (this.mFilters != null) {
            for (LogFilter f : this.mFilters) {
                this.createTab(f, index++, false);
            }
        }
        return top;
    }

    protected void postCreation() {
    }

    public void setFocus() {
        this.mFolders.setFocus();
    }

    public void startLogCat(final IDevice device) {
        if (device == this.mCurrentLoggedDevice) {
            return;
        }
        if (this.mCurrentLoggedDevice != null) {
            this.stopLogCat(false);
            this.mCurrentLoggedDevice = null;
        }
        this.resetUI(false);
        if (device != null) {
            this.mCurrentLogCat = new LogCatOuputReceiver();
            new Thread("Logcat"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!device.isOnline() && LogPanel.this.mCurrentLogCat != null && !((LogPanel)LogPanel.this).mCurrentLogCat.isCancelled) {
                        try {
                            3.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    if (LogPanel.this.mCurrentLogCat == null || ((LogPanel)LogPanel.this).mCurrentLogCat.isCancelled) {
                        return;
                    }
                    try {
                        LogPanel.this.mCurrentLoggedDevice = device;
                        device.executeShellCommand("logcat -v long", (IShellOutputReceiver)LogPanel.this.mCurrentLogCat);
                    }
                    catch (Exception e) {
                        Log.e((String)"Logcat", (Throwable)e);
                    }
                    finally {
                        LogPanel.this.mCurrentLogCat = null;
                        LogPanel.this.mCurrentLoggedDevice = null;
                    }
                }
            }.start();
        }
    }

    public void stopLogCat(boolean inUiThread) {
        if (this.mCurrentLogCat != null) {
            this.mCurrentLogCat.isCancelled = true;
            this.mCurrentLogCat = null;
            for (int i = 0; i < 10000; ++i) {
                this.mBuffer[i] = null;
            }
            this.mBufferStart = -1;
            this.mBufferEnd = -1;
            this.resetFilters();
            this.resetUI(inUiThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFilter() {
        EditFilterDialog dlg = new EditFilterDialog(this.mImageLoader, this.mFolders.getShell());
        if (!dlg.open()) return;
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            LogFilter filter = dlg.getFilter();
            this.addFilterToArray(filter);
            int index = this.mFilters.length - 1;
            if (this.mDefaultFilter != null) {
                ++index;
            }
            this.createTab(filter, index, true);
            if (this.mDefaultFilter != null) {
                this.initDefaultFilter();
            }
            if (this.mCurrentFilter != null) {
                this.mCurrentFilter.setSelectedState(false);
            }
            this.mFolders.setSelection(index);
            filter.setSelectedState(true);
            this.mCurrentFilter = filter;
            this.selectionChanged(filter);
            if (this.mFilterMode == 0) {
                this.mFilterMode = 1;
            }
            this.mFilterStorage.saveFilters(this.mFilters);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void editFilter() {
        EditFilterDialog dlg;
        if (this.mCurrentFilter == null || this.mCurrentFilter == this.mDefaultFilter || !(dlg = new EditFilterDialog(this.mImageLoader, this.mFolders.getShell(), this.mCurrentFilter)).open()) return;
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            this.initFilter(this.mCurrentFilter);
            if (this.mDefaultFilter != null) {
                this.initDefaultFilter();
            }
            this.mFilterStorage.saveFilters(this.mFilters);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFilter() {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            if (this.mCurrentFilter != null && this.mCurrentFilter != this.mDefaultFilter) {
                this.removeFilterFromArray(this.mCurrentFilter);
                this.mCurrentFilter.dispose();
                this.mFolders.setSelection(0);
                this.mCurrentFilter = this.mFilters.length > 0 ? this.mFilters[0] : this.mDefaultFilter;
                this.selectionChanged(this.mCurrentFilter);
                if (this.mDefaultFilter != null) {
                    this.initDefaultFilter();
                }
                this.mFilterStorage.saveFilters(this.mFilters);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            FileDialog dlg = new FileDialog(this.mParent.getShell(), 8192);
            dlg.setText("Save log...");
            dlg.setFileName("log.txt");
            String defaultPath = this.mDefaultLogSave;
            if (defaultPath == null) {
                defaultPath = System.getProperty("user.home");
            }
            dlg.setFilterPath(defaultPath);
            dlg.setFilterNames(new String[]{"Text Files (*.txt)"});
            dlg.setFilterExtensions(new String[]{"*.txt"});
            String fileName = dlg.open();
            if (fileName != null) {
                this.mDefaultLogSave = dlg.getFilterPath();
                Table currentTable = this.mCurrentFilter.getTable();
                int[] selection = currentTable.getSelectionIndices();
                Arrays.sort(selection);
                try {
                    FileWriter writer = new FileWriter(fileName);
                    for (int i : selection) {
                        TableItem item = currentTable.getItem(i);
                        LogMessage msg = (LogMessage)item.getData();
                        String line = msg.toString();
                        writer.write(line);
                        writer.write(10);
                    }
                    writer.flush();
                }
                catch (IOException e) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            for (int i = 0; i < 10000; ++i) {
                this.mBuffer[i] = null;
            }
            this.mBufferStart = -1;
            this.mBufferEnd = -1;
            for (LogFilter filter : this.mFilters) {
                filter.clear();
            }
            if (this.mDefaultFilter != null) {
                this.mDefaultFilter.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void copy(Clipboard clipboard) {
        Table currentTable = this.mCurrentFilter.getTable();
        LogPanel.copyTable(clipboard, currentTable);
    }

    public void selectAll() {
        Table currentTable = this.mCurrentFilter.getTable();
        currentTable.selectAll();
    }

    public void setTableFocusListener(ITableFocusListener listener) {
        this.mGlobalListener = listener;
        for (LogFilter filter : this.mFilters) {
            Table table = filter.getTable();
            this.addTableToFocusListener(table);
        }
        if (this.mDefaultFilter != null) {
            this.addTableToFocusListener(this.mDefaultFilter.getTable());
        }
    }

    private void addTableToFocusListener(final Table table) {
        final ITableFocusListener.IFocusedTableActivator activator = new ITableFocusListener.IFocusedTableActivator(){

            public void copy(Clipboard clipboard) {
                LogPanel.copyTable(clipboard, table);
            }

            public void selectAll() {
                table.selectAll();
            }
        };
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                LogPanel.this.mGlobalListener.focusGained(activator);
            }

            public void focusLost(FocusEvent e) {
                LogPanel.this.mGlobalListener.focusLost(activator);
            }
        });
    }

    private static void copyTable(Clipboard clipboard, Table table) {
        int[] selection = table.getSelectionIndices();
        Arrays.sort(selection);
        StringBuilder sb = new StringBuilder();
        for (int i : selection) {
            TableItem item = table.getItem(i);
            LogMessage msg = (LogMessage)item.getData();
            String line = msg.toString();
            sb.append(line);
            sb.append('\n');
        }
        clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void setCurrentFilterLogLevel(int i) {
        LogFilter filter = this.getCurrentFilter();
        filter.setLogLevel(i);
        this.initFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TabItem createTab(LogFilter filter, int index, boolean fillTable) {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            TabItem item = null;
            item = index != -1 ? new TabItem(this.mFolders, 0, index) : new TabItem(this.mFolders, 0);
            item.setText(filter.getName());
            Composite top = new Composite((Composite)this.mFolders, 0);
            item.setControl((Control)top);
            top.setLayout((Layout)new FillLayout());
            final Table t = new Table(top, 65538);
            if (this.mDisplayFont != null) {
                t.setFont(this.mDisplayFont);
            }
            filter.setWidgets(item, t);
            t.setHeaderVisible(true);
            t.setLinesVisible(false);
            if (this.mGlobalListener != null) {
                this.addTableToFocusListener(t);
            }
            ControlListener listener = null;
            if (this.mColumnMode == 1) {
                listener = new ControlListener(){

                    public void controlMoved(ControlEvent e) {
                    }

                    public void controlResized(ControlEvent e) {
                        Rectangle r = t.getClientArea();
                        int total = t.getColumn(0).getWidth();
                        total += t.getColumn(1).getWidth();
                        total += t.getColumn(2).getWidth();
                        if (r.width > (total += t.getColumn(3).getWidth())) {
                            t.getColumn(4).setWidth(r.width - total);
                        }
                    }
                };
                t.addControlListener(listener);
            }
            TableColumn col = TableHelper.createTableColumn(t, "Time", 16384, "00-00 00:00:00", PREFS_TIME, this.mStore);
            if (this.mColumnMode == 1) {
                col.addControlListener(listener);
            }
            col = TableHelper.createTableColumn(t, "", 0x1000000, "D", PREFS_LEVEL, this.mStore);
            if (this.mColumnMode == 1) {
                col.addControlListener(listener);
            }
            col = TableHelper.createTableColumn(t, "pid", 16384, "9999", PREFS_PID, this.mStore);
            if (this.mColumnMode == 1) {
                col.addControlListener(listener);
            }
            col = TableHelper.createTableColumn(t, "tag", 16384, "abcdefgh", PREFS_TAG, this.mStore);
            if (this.mColumnMode == 1) {
                col.addControlListener(listener);
            }
            col = TableHelper.createTableColumn(t, "Message", 16384, "abcdefghijklmnopqrstuvwxyz0123456789", PREFS_MESSAGE, this.mStore);
            if (this.mColumnMode == 1) {
                col.setResizable(false);
            }
            if (fillTable) {
                this.initFilter(filter);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return item;
        }
    }

    protected void updateColumns(Table table) {
        if (table != null) {
            int index = 0;
            TableColumn col = table.getColumn(index++);
            col.setWidth(this.mStore.getInt(PREFS_TIME));
            col = table.getColumn(index++);
            col.setWidth(this.mStore.getInt(PREFS_LEVEL));
            col = table.getColumn(index++);
            col.setWidth(this.mStore.getInt(PREFS_PID));
            col = table.getColumn(index++);
            col.setWidth(this.mStore.getInt(PREFS_TAG));
            col = table.getColumn(index++);
            col.setWidth(this.mStore.getInt(PREFS_MESSAGE));
        }
    }

    public void resetUI(boolean inUiThread) {
        if (this.mFilterMode == 2 || this.mFilterMode == 3) {
            if (inUiThread) {
                this.mFolders.dispose();
                this.mParent.pack(true);
                this.createControl(this.mParent);
            } else {
                Display d = this.mFolders.getDisplay();
                d.syncExec(new Runnable(){

                    public void run() {
                        LogPanel.this.mFolders.dispose();
                        LogPanel.this.mParent.pack(true);
                        LogPanel.this.createControl(LogPanel.this.mParent);
                    }
                });
            }
        } else if (!this.mFolders.isDisposed()) {
            if (inUiThread) {
                this.emptyTables();
            } else {
                Display d = this.mFolders.getDisplay();
                d.syncExec(new Runnable(){

                    public void run() {
                        if (!LogPanel.this.mFolders.isDisposed()) {
                            LogPanel.this.emptyTables();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLogLines(String[] lines) {
        if (lines.length > 10000) {
            Log.e((String)"LogCat", (String)"Receiving more lines than STRING_BUFFER_LENGTH");
        }
        ArrayList<LogMessage> newMessages = new ArrayList<LogMessage>();
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            for (String line : lines) {
                if (line.length() <= 0) continue;
                Matcher matcher = sLogPattern.matcher(line);
                if (matcher.matches()) {
                    this.mLastMessageInfo = new LogMessageInfo();
                    this.mLastMessageInfo.time = matcher.group(1);
                    this.mLastMessageInfo.pidString = matcher.group(2);
                    this.mLastMessageInfo.pid = Integer.valueOf(this.mLastMessageInfo.pidString);
                    this.mLastMessageInfo.logLevel = Log.LogLevel.getByLetterString((String)matcher.group(4));
                    this.mLastMessageInfo.tag = matcher.group(5).trim();
                    continue;
                }
                LogMessage mc = new LogMessage();
                if (this.mLastMessageInfo == null) {
                    this.mLastMessageInfo = new LogMessageInfo();
                    this.mLastMessageInfo.time = "??-?? ??:??:??.???";
                    this.mLastMessageInfo.pidString = "<unknown>";
                    this.mLastMessageInfo.pid = 0;
                    this.mLastMessageInfo.logLevel = Log.LogLevel.INFO;
                    this.mLastMessageInfo.tag = "<unknown>";
                }
                mc.data = this.mLastMessageInfo;
                mc.msg = line.replaceAll("\t", "    ");
                this.processNewMessage(mc);
                newMessages.add(mc);
            }
            if (!this.mPendingAsyncRefresh) {
                this.mPendingAsyncRefresh = true;
                try {
                    Display display = this.mFolders.getDisplay();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            LogPanel.this.asyncRefresh();
                        }
                    });
                }
                catch (SWTException e) {
                    this.stopLogCat(false);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncRefresh() {
        if (!this.mFolders.isDisposed()) {
            LogMessage[] logMessageArray = this.mBuffer;
            synchronized (this.mBuffer) {
                try {
                    if (this.mFilters != null) {
                        for (LogFilter f : this.mFilters) {
                            f.flush();
                        }
                    }
                    if (this.mDefaultFilter != null) {
                        this.mDefaultFilter.flush();
                    }
                }
                finally {
                    this.mPendingAsyncRefresh = false;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        this.stopLogCat(true);
    }

    private void processNewMessage(LogMessage newMessage) {
        if (this.mFilterMode == 2 || this.mFilterMode == 3) {
            this.checkFilter(newMessage.data);
        }
        int messageIndex = -1;
        if (this.mBufferStart == -1) {
            this.mBufferStart = 0;
            messageIndex = 0;
            this.mBufferEnd = 1;
        } else {
            messageIndex = this.mBufferEnd;
            if (this.mBufferEnd == this.mBufferStart) {
                this.mBufferStart = (this.mBufferStart + 1) % 10000;
            }
            this.mBufferEnd = (this.mBufferEnd + 1) % 10000;
        }
        LogMessage oldMessage = null;
        if (this.mBuffer[messageIndex] != null) {
            oldMessage = this.mBuffer[messageIndex];
        }
        this.mBuffer[messageIndex] = newMessage;
        boolean filtered = false;
        if (this.mFilters != null) {
            for (LogFilter f : this.mFilters) {
                filtered |= f.addMessage(newMessage, oldMessage);
            }
        }
        if (!filtered && this.mDefaultFilter != null) {
            this.mDefaultFilter.addMessage(newMessage, oldMessage);
        }
    }

    private void createFilters() {
        if (this.mFilterMode == 4 || this.mFilterMode == 1) {
            this.mFilters = this.mFilterStorage.getFilterFromStore();
            if (this.mFilters != null) {
                for (LogFilter f : this.mFilters) {
                    f.setColors(this.mColors);
                }
            }
            if (this.mFilterStorage.requiresDefaultFilter()) {
                this.mDefaultFilter = new LogFilter("Log");
                this.mDefaultFilter.setColors(this.mColors);
                this.mDefaultFilter.setSupportsDelete(false);
                this.mDefaultFilter.setSupportsEdit(false);
            }
        } else if (this.mFilterMode == 0) {
            this.mDefaultFilter = new LogFilter("Log");
            this.mDefaultFilter.setColors(this.mColors);
            this.mDefaultFilter.setSupportsDelete(false);
            this.mDefaultFilter.setSupportsEdit(false);
        }
    }

    private boolean checkFilter(LogMessageInfo md) {
        return true;
    }

    private void addFilterToArray(LogFilter newFilter) {
        newFilter.setColors(this.mColors);
        if (this.mFilters != null && this.mFilters.length > 0) {
            LogFilter[] newFilters = new LogFilter[this.mFilters.length + 1];
            System.arraycopy(this.mFilters, 0, newFilters, 0, this.mFilters.length);
            newFilters[this.mFilters.length] = newFilter;
            this.mFilters = newFilters;
        } else {
            this.mFilters = new LogFilter[1];
            this.mFilters[0] = newFilter;
        }
    }

    private void removeFilterFromArray(LogFilter oldFilter) {
        int index = -1;
        for (int i = 0; i < this.mFilters.length; ++i) {
            if (this.mFilters[i] != oldFilter) continue;
            index = i;
            break;
        }
        if (index != -1) {
            LogFilter[] newFilters = new LogFilter[this.mFilters.length - 1];
            System.arraycopy(this.mFilters, 0, newFilters, 0, index);
            System.arraycopy(this.mFilters, index + 1, newFilters, index, newFilters.length - index);
            this.mFilters = newFilters;
        }
    }

    private void initFilter(LogFilter filter) {
        if (!filter.uiReady()) {
            return;
        }
        if (filter == this.mDefaultFilter) {
            this.initDefaultFilter();
            return;
        }
        filter.clear();
        if (this.mBufferStart != -1) {
            int max = this.mBufferEnd;
            if (this.mBufferEnd < this.mBufferStart) {
                max += 10000;
            }
            for (int i = this.mBufferStart; i < max; ++i) {
                int realItemIndex = i % 10000;
                filter.addMessage(this.mBuffer[realItemIndex], null);
            }
        }
        filter.flush();
        filter.resetTempFilteringStatus();
    }

    private void initDefaultFilter() {
        this.mDefaultFilter.clear();
        if (this.mBufferStart != -1) {
            int max = this.mBufferEnd;
            if (this.mBufferEnd < this.mBufferStart) {
                max += 10000;
            }
            for (int i = this.mBufferStart; i < max; ++i) {
                int realItemIndex = i % 10000;
                LogMessage msg = this.mBuffer[realItemIndex];
                boolean filtered = false;
                for (LogFilter f : this.mFilters) {
                    filtered |= f.accept(msg);
                }
                if (filtered) continue;
                this.mDefaultFilter.addMessage(msg, null);
            }
        }
        this.mDefaultFilter.flush();
        this.mDefaultFilter.resetTempFilteringStatus();
    }

    private void resetFilters() {
        if (this.mFilterMode == 2 || this.mFilterMode == 3) {
            this.mFilters = null;
            this.createFilters();
        }
    }

    private LogFilter getCurrentFilter() {
        int index = this.mFolders.getSelectionIndex();
        if (index == 0 || this.mFilters == null) {
            return this.mDefaultFilter;
        }
        return this.mFilters[index - 1];
    }

    private void emptyTables() {
        for (LogFilter f : this.mFilters) {
            f.getTable().removeAll();
        }
        if (this.mDefaultFilter != null) {
            this.mDefaultFilter.getTable().removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFilteringWith(String text) {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            for (LogFilter f : this.mFilters) {
                f.resetTempFiltering();
            }
            if (this.mDefaultFilter != null) {
                this.mDefaultFilter.resetTempFiltering();
            }
            String[] segments = text.split(" ");
            ArrayList<String> keywords = new ArrayList<String>(segments.length);
            int tempPid = -1;
            String tempTag = null;
            for (int i = 0; i < segments.length; ++i) {
                String[] seg;
                String s = segments[i];
                if (tempPid == -1 && s.startsWith("pid:")) {
                    seg = s.split(":");
                    if (seg.length != 2 || !seg[1].matches("^[0-9]*$")) continue;
                    tempPid = Integer.valueOf(seg[1]);
                    continue;
                }
                if (tempTag == null && s.startsWith("tag:")) {
                    seg = segments[i].split(":");
                    if (seg.length != 2) continue;
                    tempTag = seg[1];
                    continue;
                }
                keywords.add(s);
            }
            if (tempPid != -1 || tempTag != null || keywords.size() > 0) {
                String[] keywordsArray = keywords.toArray(new String[keywords.size()]);
                for (LogFilter f : this.mFilters) {
                    if (tempPid != -1) {
                        f.setTempPidFiltering(tempPid);
                    }
                    if (tempTag != null) {
                        f.setTempTagFiltering(tempTag);
                    }
                    f.setTempKeywordFiltering(keywordsArray);
                }
                if (this.mDefaultFilter != null) {
                    if (tempPid != -1) {
                        this.mDefaultFilter.setTempPidFiltering(tempPid);
                    }
                    if (tempTag != null) {
                        this.mDefaultFilter.setTempTagFiltering(tempTag);
                    }
                    this.mDefaultFilter.setTempKeywordFiltering(keywordsArray);
                }
            }
            this.initFilter(this.mCurrentFilter);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void selectionChanged(LogFilter selectedFilter) {
        if (this.mLogLevelActions != null) {
            int level = selectedFilter.getLogLevel();
            for (int i = 0; i < this.mLogLevelActions.length; ++i) {
                ICommonAction a = this.mLogLevelActions[i];
                if (i == level - 2) {
                    a.setChecked(true);
                    continue;
                }
                a.setChecked(false);
            }
        }
        if (this.mDeleteFilterAction != null) {
            this.mDeleteFilterAction.setEnabled(selectedFilter.supportsDelete());
        }
        if (this.mEditFilterAction != null) {
            this.mEditFilterAction.setEnabled(selectedFilter.supportsEdit());
        }
    }

    static /* synthetic */ IDevice access$700(LogPanel x0) {
        return x0.mCurrentLoggedDevice;
    }

    static {
        sLogPattern = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):(0x[0-9a-fA-F]+)\\s([VDIWE])/(.*)\\]$");
    }

    private class PsOutputReceiver
    extends MultiLineReceiver {
        private LogFilter mFilter;
        private TabItem mTabItem;
        private int mPid;
        private boolean mDone = false;

        PsOutputReceiver(int pid, LogFilter filter, TabItem tabItem) {
            this.mPid = pid;
            this.mFilter = filter;
            this.mTabItem = tabItem;
        }

        public boolean isCancelled() {
            return this.mDone;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                int index;
                if (line.startsWith("USER") || (index = line.indexOf(32)) == -1) continue;
                ++index;
                while (line.charAt(index) == ' ') {
                    ++index;
                }
                int index2 = line.indexOf(32, index);
                String pidStr = line.substring(index, index2);
                int pid = Integer.parseInt(pidStr);
                if (pid != this.mPid) continue;
                index = line.lastIndexOf(32);
                final String name = line.substring(index + 1);
                this.mFilter.setName(name);
                Display d = LogPanel.this.mFolders.getDisplay();
                d.asyncExec(new Runnable(){

                    public void run() {
                        PsOutputReceiver.this.mTabItem.setText(name);
                    }
                });
                this.mDone = true;
                return;
            }
        }
    }

    private final class LogCatOuputReceiver
    extends MultiLineReceiver {
        public boolean isCancelled = false;

        public LogCatOuputReceiver() {
            this.setTrimLine(false);
        }

        public void processNewLines(String[] lines) {
            if (!this.isCancelled) {
                LogPanel.this.processLogLines(lines);
            }
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }
    }

    protected static class LogMessage {
        public LogMessageInfo data;
        public String msg;

        protected LogMessage() {
        }

        public String toString() {
            return this.data.time + ": " + this.data.logLevel + "/" + this.data.tag + "(" + this.data.pidString + "): " + this.msg;
        }
    }

    protected static class LogMessageInfo {
        public Log.LogLevel logLevel;
        public int pid;
        public String pidString;
        public String tag;
        public String time;

        protected LogMessageInfo() {
        }
    }

    public static interface ILogFilterStorageManager {
        public LogFilter[] getFilterFromStore();

        public void saveFilters(LogFilter[] var1);

        public boolean requiresDefaultFilter();
    }
}

