/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.Log;
import com.android.ddmuilib.logcat.LogColors;
import com.android.ddmuilib.logcat.LogPanel;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogFilter {
    public static final int MODE_PID = 1;
    public static final int MODE_TAG = 2;
    public static final int MODE_LEVEL = 4;
    private String mName;
    private int mMode = 0;
    private int mPid;
    private int mLogLevel;
    private String mTag;
    private Table mTable;
    private TabItem mTabItem;
    private boolean mIsCurrentTabItem = false;
    private int mUnreadCount = 0;
    private String[] mTempKeywordFilters;
    private int mTempPid = -1;
    private String mTempTag;
    private int mTempLogLevel = -1;
    private LogColors mColors;
    private boolean mTempFilteringStatus = false;
    private final ArrayList<LogPanel.LogMessage> mMessages = new ArrayList();
    private final ArrayList<LogPanel.LogMessage> mNewMessages = new ArrayList();
    private boolean mSupportsDelete = true;
    private boolean mSupportsEdit = true;
    private int mRemovedMessageCount = 0;

    public LogFilter(String name) {
        this.mName = name;
    }

    public LogFilter() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.mName);
        sb.append(':');
        sb.append(this.mMode);
        if ((this.mMode & 1) == 1) {
            sb.append(':');
            sb.append(this.mPid);
        }
        if ((this.mMode & 4) == 4) {
            sb.append(':');
            sb.append(this.mLogLevel);
        }
        if ((this.mMode & 2) == 2) {
            sb.append(':');
            sb.append(this.mTag);
        }
        return sb.toString();
    }

    public boolean loadFromString(String string) {
        String[] segments = string.split(":");
        int index = 0;
        this.mName = segments[index++];
        this.mMode = Integer.parseInt(segments[index++]);
        if ((this.mMode & 1) == 1) {
            this.mPid = Integer.parseInt(segments[index++]);
        }
        if ((this.mMode & 4) == 4) {
            this.mLogLevel = Integer.parseInt(segments[index++]);
        }
        if ((this.mMode & 2) == 2) {
            this.mTag = segments[index++];
        }
        return true;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setWidgets(TabItem tabItem, Table table) {
        this.mTable = table;
        this.mTabItem = tabItem;
    }

    public boolean uiReady() {
        return this.mTable != null && this.mTabItem != null;
    }

    public Table getTable() {
        return this.mTable;
    }

    public void dispose() {
        this.mTable.dispose();
        this.mTabItem.dispose();
        this.mTable = null;
        this.mTabItem = null;
    }

    public void resetFilteringMode() {
        this.mMode = 0;
    }

    public int getFilteringMode() {
        return this.mMode;
    }

    public void setPidMode(int pid) {
        this.mMode = pid != -1 ? (this.mMode |= 1) : (this.mMode &= 0xFFFFFFFE);
        this.mPid = pid;
    }

    public int getPidFilter() {
        if ((this.mMode & 1) == 1) {
            return this.mPid;
        }
        return -1;
    }

    public void setTagMode(String tag) {
        this.mMode = tag != null && tag.length() > 0 ? (this.mMode |= 2) : (this.mMode &= 0xFFFFFFFD);
        this.mTag = tag;
    }

    public String getTagFilter() {
        if ((this.mMode & 2) == 2) {
            return this.mTag;
        }
        return null;
    }

    public void setLogLevel(int level) {
        if (level == -1) {
            this.mMode &= 0xFFFFFFFB;
        } else {
            this.mMode |= 4;
            this.mLogLevel = level;
        }
    }

    public int getLogLevel() {
        if ((this.mMode & 4) == 4) {
            return this.mLogLevel;
        }
        return -1;
    }

    public boolean supportsDelete() {
        return this.mSupportsDelete;
    }

    public boolean supportsEdit() {
        return this.mSupportsEdit;
    }

    public void setSelectedState(boolean selected) {
        if (selected) {
            if (this.mTabItem != null) {
                this.mTabItem.setText(this.mName);
            }
            this.mUnreadCount = 0;
        }
        this.mIsCurrentTabItem = selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessage(LogPanel.LogMessage newMessage, LogPanel.LogMessage oldMessage) {
        ArrayList<LogPanel.LogMessage> arrayList = this.mMessages;
        synchronized (arrayList) {
            boolean filter;
            if (oldMessage != null) {
                int index = this.mMessages.indexOf(oldMessage);
                if (index != -1) {
                    this.mMessages.remove(index);
                    ++this.mRemovedMessageCount;
                }
                if ((index = this.mNewMessages.indexOf(oldMessage)) != -1) {
                    this.mNewMessages.remove(index);
                }
            }
            if (filter = this.accept(newMessage)) {
                this.mMessages.add(newMessage);
                this.mNewMessages.add(newMessage);
            }
            return filter;
        }
    }

    public void clear() {
        this.mRemovedMessageCount = 0;
        this.mNewMessages.clear();
        this.mMessages.clear();
        this.mTable.removeAll();
    }

    boolean accept(LogPanel.LogMessage logMessage) {
        if ((this.mMode & 1) == 1 && this.mPid != logMessage.data.pid) {
            return false;
        }
        if (!((this.mMode & 2) != 2 || logMessage.data.tag != null && logMessage.data.tag.equals(this.mTag))) {
            return false;
        }
        int msgLogLevel = logMessage.data.logLevel.getPriority();
        if (this.mTempLogLevel != -1 ? this.mTempLogLevel > msgLogLevel : (this.mMode & 4) == 4 && this.mLogLevel > msgLogLevel) {
            return false;
        }
        if (this.mTempKeywordFilters != null) {
            String msg = logMessage.msg;
            for (String kw : this.mTempKeywordFilters) {
                try {
                    if (msg.contains(kw) || msg.matches(kw)) continue;
                    return false;
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
        }
        if (this.mTempPid != -1 && this.mTempPid != logMessage.data.pid) {
            return false;
        }
        return this.mTempTag == null || this.mTempTag.length() <= 0 || this.mTempTag.equals(logMessage.data.tag);
    }

    public void flush() {
        ScrollBar bar = this.mTable.getVerticalBar();
        boolean scroll = bar.getMaximum() == bar.getSelection() + bar.getThumb();
        int topIndex = this.mTable.getTopIndex();
        this.mTable.setRedraw(false);
        int totalCount = this.mNewMessages.size();
        try {
            int i;
            for (i = 0; i < this.mRemovedMessageCount && this.mTable.getItemCount() > 0; ++i) {
                this.mTable.remove(0);
            }
            if (this.mUnreadCount > this.mTable.getItemCount()) {
                this.mUnreadCount = this.mTable.getItemCount();
            }
            for (i = 0; i < totalCount; ++i) {
                LogPanel.LogMessage msg = this.mNewMessages.get(i);
                this.addTableItem(msg);
            }
        }
        catch (SWTException e) {
            Log.e((String)"LogFilter", (Throwable)e);
        }
        this.mTable.setRedraw(true);
        if (scroll) {
            totalCount = this.mTable.getItemCount();
            if (totalCount > 0) {
                this.mTable.showItem(this.mTable.getItem(totalCount - 1));
            }
        } else if (this.mRemovedMessageCount > 0) {
            if ((topIndex -= this.mRemovedMessageCount) < 0) {
                this.mTable.showItem(this.mTable.getItem(0));
            } else {
                this.mTable.showItem(this.mTable.getItem(topIndex));
            }
        }
        if (!this.mIsCurrentTabItem) {
            this.mUnreadCount += this.mNewMessages.size();
            totalCount = this.mTable.getItemCount();
            if (this.mUnreadCount > 0) {
                this.mTabItem.setText(this.mName + " (" + (this.mUnreadCount > totalCount ? totalCount : this.mUnreadCount) + ")");
            } else {
                this.mTabItem.setText(this.mName);
            }
        }
        this.mNewMessages.clear();
    }

    void setColors(LogColors colors) {
        this.mColors = colors;
    }

    int getUnreadCount() {
        return this.mUnreadCount;
    }

    void setUnreadCount(int unreadCount) {
        this.mUnreadCount = unreadCount;
    }

    void setSupportsDelete(boolean support) {
        this.mSupportsDelete = support;
    }

    void setSupportsEdit(boolean support) {
        this.mSupportsEdit = support;
    }

    void setTempKeywordFiltering(String[] segments) {
        this.mTempKeywordFilters = segments;
        this.mTempFilteringStatus = true;
    }

    void setTempPidFiltering(int pid) {
        this.mTempPid = pid;
        this.mTempFilteringStatus = true;
    }

    void setTempTagFiltering(String tag) {
        this.mTempTag = tag;
        this.mTempFilteringStatus = true;
    }

    void resetTempFiltering() {
        if (this.mTempPid != -1 || this.mTempTag != null || this.mTempKeywordFilters != null) {
            this.mTempFilteringStatus = true;
        }
        this.mTempPid = -1;
        this.mTempTag = null;
        this.mTempKeywordFilters = null;
    }

    void resetTempFilteringStatus() {
        this.mTempFilteringStatus = false;
    }

    boolean getTempFilterStatus() {
        return this.mTempFilteringStatus;
    }

    private void addTableItem(LogPanel.LogMessage msg) {
        TableItem item = new TableItem(this.mTable, 0);
        item.setText(0, msg.data.time);
        item.setText(1, new String(new char[]{msg.data.logLevel.getPriorityLetter()}));
        item.setText(2, msg.data.pidString);
        item.setText(3, msg.data.tag);
        item.setText(4, msg.msg);
        item.setData((Object)msg);
        if (msg.data.logLevel == Log.LogLevel.INFO) {
            item.setForeground(this.mColors.infoColor);
        } else if (msg.data.logLevel == Log.LogLevel.DEBUG) {
            item.setForeground(this.mColors.debugColor);
        } else if (msg.data.logLevel == Log.LogLevel.ERROR) {
            item.setForeground(this.mColors.errorColor);
        } else if (msg.data.logLevel == Log.LogLevel.WARN) {
            item.setForeground(this.mColors.warningColor);
        } else {
            item.setForeground(this.mColors.verboseColor);
        }
    }
}

