/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.explorer;

import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.SyncService;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.Panel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.console.DdmConsole;
import com.android.ddmuilib.explorer.DeviceContentProvider;
import com.android.ddmuilib.explorer.FileLabelProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DeviceExplorer
extends Panel {
    private static final String TRACE_KEY_EXT = ".key";
    private static final String TRACE_DATA_EXT = ".data";
    private static Pattern mKeyFilePattern = Pattern.compile("(.+)\\.key");
    private static Pattern mDataFilePattern = Pattern.compile("(.+)\\.data");
    public static String COLUMN_NAME = "android.explorer.name";
    public static String COLUMN_SIZE = "android.explorer.size";
    public static String COLUMN_DATE = "android.explorer.data";
    public static String COLUMN_TIME = "android.explorer.time";
    public static String COLUMN_PERMISSIONS = "android.explorer.permissions";
    public static String COLUMN_INFO = "android.explorer.info";
    private Composite mParent;
    private TreeViewer mTreeViewer;
    private Tree mTree;
    private DeviceContentProvider mContentProvider;
    private ICommonAction mPushAction;
    private ICommonAction mPullAction;
    private ICommonAction mDeleteAction;
    private Image mFileImage;
    private Image mFolderImage;
    private Image mPackageImage;
    private Image mOtherImage;
    private IDevice mCurrentDevice;
    private String mDefaultSave;

    public void setImages(Image fileImage, Image folderImage, Image packageImage, Image otherImage) {
        this.mFileImage = fileImage;
        this.mFolderImage = folderImage;
        this.mPackageImage = packageImage;
        this.mOtherImage = otherImage;
    }

    public void setActions(ICommonAction pushAction, ICommonAction pullAction, ICommonAction deleteAction) {
        this.mPushAction = pushAction;
        this.mPullAction = pullAction;
        this.mDeleteAction = deleteAction;
    }

    protected Control createControl(Composite parent) {
        this.mParent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.mTree = new Tree(parent, 0x10010002);
        this.mTree.setHeaderVisible(true);
        IPreferenceStore store = DdmUiPreferences.getStore();
        TableHelper.createTreeColumn(this.mTree, "Name", 16384, "0000drwxrwxrwx", COLUMN_NAME, store);
        TableHelper.createTreeColumn(this.mTree, "Size", 131072, "000000", COLUMN_SIZE, store);
        TableHelper.createTreeColumn(this.mTree, "Date", 16384, "2007-08-14", COLUMN_DATE, store);
        TableHelper.createTreeColumn(this.mTree, "Time", 16384, "20:54", COLUMN_TIME, store);
        TableHelper.createTreeColumn(this.mTree, "Permissions", 16384, "drwxrwxrwx", COLUMN_PERMISSIONS, store);
        TableHelper.createTreeColumn(this.mTree, "Info", 16384, "drwxrwxrwx", COLUMN_INFO, store);
        this.mTreeViewer = new TreeViewer(this.mTree);
        this.mContentProvider = new DeviceContentProvider();
        this.mTreeViewer.setContentProvider((IContentProvider)this.mContentProvider);
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new FileLabelProvider(this.mFileImage, this.mFolderImage, this.mPackageImage, this.mOtherImage));
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel.isEmpty()) {
                    DeviceExplorer.this.mPullAction.setEnabled(false);
                    DeviceExplorer.this.mPushAction.setEnabled(false);
                    DeviceExplorer.this.mDeleteAction.setEnabled(false);
                    return;
                }
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    Object element = selection.getFirstElement();
                    if (element == null) {
                        return;
                    }
                    if (element instanceof FileListingService.FileEntry) {
                        DeviceExplorer.this.mPullAction.setEnabled(true);
                        DeviceExplorer.this.mPushAction.setEnabled(selection.size() == 1);
                        if (selection.size() == 1) {
                            DeviceExplorer.this.setDeleteEnabledState((FileListingService.FileEntry)element);
                        } else {
                            DeviceExplorer.this.mDeleteAction.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection;
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection && (selection = (IStructuredSelection)sel).size() == 1) {
                    FileListingService.FileEntry entry = (FileListingService.FileEntry)selection.getFirstElement();
                    String name = entry.getName();
                    FileListingService.FileEntry parentEntry = entry.getParent();
                    if (parentEntry == null) {
                        return;
                    }
                    Matcher m = mKeyFilePattern.matcher(name);
                    if (m.matches()) {
                        String baseName = m.group(1);
                        String dataName = baseName + DeviceExplorer.TRACE_DATA_EXT;
                        FileListingService.FileEntry dataEntry = parentEntry.findChild(dataName);
                        DeviceExplorer.this.handleTraceDoubleClick(baseName, entry, dataEntry);
                    } else {
                        m = mDataFilePattern.matcher(name);
                        if (m.matches()) {
                            String baseName = m.group(1);
                            String keyName = baseName + DeviceExplorer.TRACE_KEY_EXT;
                            FileListingService.FileEntry keyEntry = parentEntry.findChild(keyName);
                            DeviceExplorer.this.handleTraceDoubleClick(baseName, keyEntry, entry);
                        }
                    }
                }
            }
        });
        this.mTreeViewer.addDropSupport(3, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.mTreeViewer){

            public boolean performDrop(Object data) {
                FileListingService.FileEntry target = (FileListingService.FileEntry)this.getCurrentTarget();
                if (target == null) {
                    return false;
                }
                if (!target.isDirectory()) {
                    target = target.getParent();
                }
                if (target == null) {
                    return false;
                }
                String[] files = (String[])data;
                DeviceExplorer.this.pushFiles(files, target);
                DeviceExplorer.this.refresh(target);
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null) {
                    return false;
                }
                FileListingService.FileEntry targetEntry = (FileListingService.FileEntry)target;
                if (!targetEntry.isDirectory()) {
                    target = targetEntry.getParent();
                }
                return target != null;
            }
        });
        new Thread("Device Ls refresher"){

            public void run() {
                block3: {
                    while (true) {
                        try {
                            4.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (DeviceExplorer.this.mTree == null || DeviceExplorer.this.mTree.isDisposed()) break block3;
                        Display display = DeviceExplorer.this.mTree.getDisplay();
                        if (display.isDisposed()) break;
                        display.asyncExec(new Runnable(){

                            public void run() {
                                if (!DeviceExplorer.this.mTree.isDisposed()) {
                                    DeviceExplorer.this.mTreeViewer.refresh(true);
                                }
                            }
                        });
                    }
                    return;
                }
            }
        }.start();
        return this.mTree;
    }

    protected void postCreation() {
    }

    public void setFocus() {
        this.mTree.setFocus();
    }

    private void handleTraceDoubleClick(String baseName, FileListingService.FileEntry keyEntry, FileListingService.FileEntry dataEntry) {
        File dataFile;
        File keyFile;
        String path;
        try {
            File f = File.createTempFile(baseName, ".trace");
            f.delete();
            f.mkdir();
            path = f.getAbsolutePath();
            keyFile = new File(path + File.separator + keyEntry.getName());
            dataFile = new File(path + File.separator + dataEntry.getName());
        }
        catch (IOException e) {
            return;
        }
        try {
            SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                SyncService.ISyncProgressMonitor monitor = SyncService.getNullProgressMonitor();
                SyncService.SyncResult result = sync.pullFile(keyEntry, keyFile.getAbsolutePath(), monitor);
                if (result.getCode() != 0) {
                    DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", keyEntry.getName(), result.getMessage()));
                    return;
                }
                result = sync.pullFile(dataEntry, dataFile.getAbsolutePath(), monitor);
                if (result.getCode() != 0) {
                    DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", dataEntry.getName(), result.getMessage()));
                    return;
                }
                String[] command = new String[]{DdmUiPreferences.getTraceview(), path + File.separator + baseName};
                try {
                    final Process p = Runtime.getRuntime().exec(command);
                    new Thread("Traceview output"){

                        public void run() {
                            InputStreamReader is = new InputStreamReader(p.getErrorStream());
                            BufferedReader resultReader = new BufferedReader(is);
                            try {
                                String line;
                                while ((line = resultReader.readLine()) != null) {
                                    DdmConsole.printErrorToConsole("Traceview: " + line);
                                }
                                p.waitFor();
                            }
                            catch (IOException e) {
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", keyEntry.getName(), e.getMessage()));
            return;
        }
    }

    public void pullSelection() {
        String defaultPath;
        TreeItem[] items = this.mTree.getSelection();
        String filePullName = null;
        FileListingService.FileEntry singleEntry = null;
        if (items.length == 1 && (singleEntry = (FileListingService.FileEntry)items[0].getData()).getType() == 0) {
            filePullName = singleEntry.getName();
        }
        if ((defaultPath = this.mDefaultSave) == null) {
            defaultPath = System.getProperty("user.home");
        }
        if (filePullName != null) {
            FileDialog fileDialog = new FileDialog(this.mParent.getShell(), 8192);
            fileDialog.setText("Get Device File");
            fileDialog.setFileName(filePullName);
            fileDialog.setFilterPath(defaultPath);
            String fileName = fileDialog.open();
            if (fileName != null) {
                this.mDefaultSave = fileDialog.getFilterPath();
                this.pullFile(singleEntry, fileName);
            }
        } else {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.mParent.getShell(), 8192);
            directoryDialog.setText("Get Device Files/Folders");
            directoryDialog.setFilterPath(defaultPath);
            String directoryName = directoryDialog.open();
            if (directoryName != null) {
                this.pullSelection(items, directoryName);
            }
        }
    }

    public void pushIntoSelection() {
        TreeItem[] items = this.mTree.getSelection();
        if (items.length == 0) {
            return;
        }
        FileDialog dlg = new FileDialog(this.mParent.getShell(), 4096);
        dlg.setText("Put File on Device");
        FileListingService.FileEntry entry = (FileListingService.FileEntry)items[0].getData();
        dlg.setFileName(entry.getName());
        String defaultPath = this.mDefaultSave;
        if (defaultPath == null) {
            defaultPath = System.getProperty("user.home");
        }
        dlg.setFilterPath(defaultPath);
        String fileName = dlg.open();
        if (fileName != null) {
            String remotePath;
            this.mDefaultSave = dlg.getFilterPath();
            FileListingService.FileEntry toRefresh = entry;
            if (entry.isDirectory()) {
                remotePath = entry.getFullPath();
            } else {
                toRefresh = entry.getParent();
                remotePath = toRefresh.getFullPath();
            }
            this.pushFile(fileName, remotePath);
            this.mTreeViewer.refresh((Object)toRefresh);
        }
    }

    public void deleteSelection() {
        TreeItem[] items = this.mTree.getSelection();
        if (items.length != 1) {
            return;
        }
        FileListingService.FileEntry entry = (FileListingService.FileEntry)items[0].getData();
        final FileListingService.FileEntry parentEntry = entry.getParent();
        String command = "rm " + entry.getFullEscapedPath();
        try {
            this.mCurrentDevice.executeShellCommand(command, new IShellOutputReceiver(){

                public void addOutput(byte[] data, int offset, int length) {
                }

                public void flush() {
                    DeviceExplorer.this.mTreeViewer.refresh((Object)parentEntry);
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void refresh() {
        this.mTreeViewer.refresh(true);
    }

    public void switchDevice(IDevice device) {
        if (device != this.mCurrentDevice) {
            this.mCurrentDevice = device;
            if (!this.mTree.isDisposed()) {
                Display d = this.mTree.getDisplay();
                d.asyncExec(new Runnable(){

                    public void run() {
                        if (!DeviceExplorer.this.mTree.isDisposed() && DeviceExplorer.this.mCurrentDevice != null) {
                            FileListingService fls = DeviceExplorer.this.mCurrentDevice.getFileListingService();
                            DeviceExplorer.this.mContentProvider.setListingService(fls);
                            DeviceExplorer.this.mTreeViewer.setInput((Object)fls.getRoot());
                        }
                    }
                });
            }
        }
    }

    private void refresh(final FileListingService.FileEntry entry) {
        Display d = this.mTreeViewer.getTree().getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                DeviceExplorer.this.mTreeViewer.refresh((Object)entry);
            }
        });
    }

    private void pullSelection(TreeItem[] items, final String localDirectory) {
        try {
            final SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                ArrayList<FileListingService.FileEntry> entries = new ArrayList<FileListingService.FileEntry>();
                for (TreeItem item : items) {
                    Object data = item.getData();
                    if (!(data instanceof FileListingService.FileEntry)) continue;
                    entries.add((FileListingService.FileEntry)data);
                }
                final FileListingService.FileEntry[] entryArray = entries.toArray(new FileListingService.FileEntry[entries.size()]);
                new ProgressMonitorDialog(this.mParent.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SyncService.SyncResult result = sync.pull(entryArray, localDirectory, (SyncService.ISyncProgressMonitor)new SyncProgressMonitor(monitor, "Pulling file(s) from the device"));
                        if (result.getCode() != 0) {
                            DdmConsole.printErrorToConsole(String.format("Failed to pull selection: %1$s", result.getMessage()));
                        }
                        sync.close();
                    }
                });
            }
        }
        catch (Exception e) {
            DdmConsole.printErrorToConsole("Failed to pull selection");
            DdmConsole.printErrorToConsole(e.getMessage());
        }
    }

    private void pullFile(final FileListingService.FileEntry remote, final String local) {
        try {
            final SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                new ProgressMonitorDialog(this.mParent.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SyncService.SyncResult result = sync.pullFile(remote, local, (SyncService.ISyncProgressMonitor)new SyncProgressMonitor(monitor, String.format("Pulling %1$s from the device", remote.getName())));
                        if (result.getCode() != 0) {
                            DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", remote, result.getMessage()));
                        }
                        sync.close();
                    }
                });
            }
        }
        catch (Exception e) {
            DdmConsole.printErrorToConsole("Failed to pull selection");
            DdmConsole.printErrorToConsole(e.getMessage());
        }
    }

    private void pushFiles(final String[] localFiles, final FileListingService.FileEntry remoteDirectory) {
        try {
            final SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                new ProgressMonitorDialog(this.mParent.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SyncService.SyncResult result = sync.push(localFiles, remoteDirectory, (SyncService.ISyncProgressMonitor)new SyncProgressMonitor(monitor, "Pushing file(s) to the device"));
                        if (result.getCode() != 0) {
                            DdmConsole.printErrorToConsole(String.format("Failed to push the items: %1$s", result.getMessage()));
                        }
                        sync.close();
                    }
                });
            }
        }
        catch (Exception e) {
            DdmConsole.printErrorToConsole("Failed to push the items");
            DdmConsole.printErrorToConsole(e.getMessage());
        }
    }

    private void pushFile(final String local, final String remoteDirectory) {
        try {
            final SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                new ProgressMonitorDialog(this.mParent.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String[] segs = local.split(Pattern.quote(File.separator));
                        String name = segs[segs.length - 1];
                        String remoteFile = remoteDirectory + "/" + name;
                        SyncService.SyncResult result = sync.pushFile(local, remoteFile, (SyncService.ISyncProgressMonitor)new SyncProgressMonitor(monitor, String.format("Pushing %1$s to the device.", name)));
                        if (result.getCode() != 0) {
                            DdmConsole.printErrorToConsole(String.format("Failed to push %1$s on %2$s: %3$s", name, DeviceExplorer.this.mCurrentDevice.getSerialNumber(), result.getMessage()));
                        }
                        sync.close();
                    }
                });
            }
        }
        catch (Exception e) {
            DdmConsole.printErrorToConsole("Failed to push the item(s).");
            DdmConsole.printErrorToConsole(e.getMessage());
        }
    }

    protected void setDeleteEnabledState(FileListingService.FileEntry element) {
        this.mDeleteAction.setEnabled(element.getType() == 0);
    }

    private static class SyncProgressMonitor
    implements SyncService.ISyncProgressMonitor {
        private IProgressMonitor mMonitor;
        private String mName;

        SyncProgressMonitor(IProgressMonitor monitor, String name) {
            this.mMonitor = monitor;
            this.mName = name;
        }

        public void start(int totalWork) {
            this.mMonitor.beginTask(this.mName, totalWork);
        }

        public void stop() {
            this.mMonitor.done();
        }

        public void advance(int work) {
            this.mMonitor.worked(work);
        }

        public boolean isCanceled() {
            return this.mMonitor.isCanceled();
        }

        public void startSubTask(String name) {
            this.mMonitor.subTask(name);
        }
    }
}

