/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageHelper;
import com.android.ddmuilib.WritePng;
import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScreenShotDialog
extends Dialog {
    private Label mBusyLabel;
    private Label mImageLabel;
    private Button mSave;
    private IDevice mDevice;

    public ScreenShotDialog(Shell parent) {
        this(parent, 67680);
    }

    public ScreenShotDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void open(IDevice device) {
        this.mDevice = device;
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, this.getStyle());
        shell.setText("Device Screen Capture");
        this.createContents(shell);
        shell.pack();
        shell.open();
        this.updateDeviceImage(shell);
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(3, true));
        this.mBusyLabel = new Label((Composite)shell, 0);
        this.mBusyLabel.setText("Preparing...");
        GridData data = new GridData(32);
        data.horizontalSpan = 3;
        this.mBusyLabel.setLayoutData((Object)data);
        this.mImageLabel = new Label((Composite)shell, 2048);
        data = new GridData(64);
        data.horizontalSpan = 3;
        this.mImageLabel.setLayoutData((Object)data);
        Display display = shell.getDisplay();
        this.mImageLabel.setImage(ImageHelper.createPlaceHolderArt(display, 50, 50, display.getSystemColor(9)));
        Button refresh = new Button((Composite)shell, 8);
        refresh.setText("Refresh");
        data = new GridData(64);
        data.widthHint = 80;
        refresh.setLayoutData((Object)data);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenShotDialog.this.updateDeviceImage(shell);
            }
        });
        this.mSave = new Button((Composite)shell, 8);
        this.mSave.setText("Save");
        data = new GridData(64);
        data.widthHint = 80;
        this.mSave.setLayoutData((Object)data);
        this.mSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenShotDialog.this.saveImage(shell);
            }
        });
        Button done = new Button((Composite)shell, 8);
        done.setText("Done");
        data = new GridData(64);
        data.widthHint = 80;
        done.setLayoutData((Object)data);
        done.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        shell.setDefaultButton(done);
    }

    private void updateDeviceImage(Shell shell) {
        this.mBusyLabel.setText("Capturing...");
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
        Image image = this.getDeviceImage();
        if (image == null) {
            Display display = shell.getDisplay();
            image = ImageHelper.createPlaceHolderArt(display, 320, 240, display.getSystemColor(9));
            this.mSave.setEnabled(false);
            this.mBusyLabel.setText("Screen not available");
        } else {
            this.mSave.setEnabled(true);
            this.mBusyLabel.setText("Captured image:");
        }
        this.mImageLabel.setImage(image);
        this.mImageLabel.pack();
        shell.pack();
        shell.setCursor(shell.getDisplay().getSystemCursor(0));
    }

    private Image getDeviceImage() {
        RawImage rawImage;
        try {
            rawImage = this.mDevice.getScreenshot();
        }
        catch (IOException ioe) {
            Log.w((String)"ddms", (String)("Unable to get frame buffer: " + ioe.getMessage()));
            return null;
        }
        if (rawImage == null) {
            return null;
        }
        assert (rawImage.bpp == 16);
        PaletteData palette = new PaletteData(63488, 2016, 31);
        ImageData imageData = new ImageData(rawImage.width, rawImage.height, rawImage.bpp, palette, 1, rawImage.data);
        return new Image((Device)this.getParent().getDisplay(), imageData);
    }

    private void saveImage(Shell shell) {
        FileDialog dlg = new FileDialog(shell, 8192);
        dlg.setText("Save image...");
        dlg.setFileName("device.png");
        dlg.setFilterPath(DdmUiPreferences.getStore().getString("lastImageSaveDir"));
        dlg.setFilterNames(new String[]{"PNG Files (*.png)"});
        dlg.setFilterExtensions(new String[]{"*.png"});
        String fileName = dlg.open();
        if (fileName != null) {
            DdmUiPreferences.getStore().setValue("lastImageSaveDir", dlg.getFilterPath());
            Log.i((String)"ddms", (String)("Saving image to " + fileName));
            ImageData imageData = this.mImageLabel.getImage().getImageData();
            try {
                WritePng.savePng(fileName, imageData);
            }
            catch (IOException ioe) {
                Log.w((String)"ddms", (String)("Unable to save " + fileName + ": " + ioe));
            }
        }
    }
}

