/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class Archive
implements IDescription {
    public static final int NUM_MONITOR_INC = 100;
    private static final String PROP_OS = "Archive.Os";
    private static final String PROP_ARCH = "Archive.Arch";
    private final Os mOs;
    private final Arch mArch;
    private final String mUrl;
    private final long mSize;
    private final String mChecksum;
    private final ChecksumType mChecksumType = ChecksumType.SHA1;
    private final Package mPackage;
    private final String mLocalOsPath;
    private final boolean mIsLocal;

    Archive(Package pkg, Os os, Arch arch, String url, long size, String checksum) {
        this.mPackage = pkg;
        this.mOs = os;
        this.mArch = arch;
        this.mUrl = url;
        this.mLocalOsPath = null;
        this.mSize = size;
        this.mChecksum = checksum;
        this.mIsLocal = false;
    }

    Archive(Package pkg, Properties props, Os os, Arch arch, String localOsPath) {
        this.mPackage = pkg;
        this.mOs = props == null ? os : Os.valueOf(props.getProperty(PROP_OS, os.toString()));
        this.mArch = props == null ? arch : Arch.valueOf(props.getProperty(PROP_ARCH, arch.toString()));
        this.mUrl = null;
        this.mLocalOsPath = localOsPath;
        this.mSize = 0L;
        this.mChecksum = "";
        this.mIsLocal = true;
    }

    void saveProperties(Properties props) {
        props.setProperty(PROP_OS, this.mOs.toString());
        props.setProperty(PROP_ARCH, this.mArch.toString());
    }

    public boolean isLocal() {
        return this.mIsLocal;
    }

    public Package getParentPackage() {
        return this.mPackage;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getChecksum() {
        return this.mChecksum;
    }

    public ChecksumType getChecksumType() {
        return this.mChecksumType;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getLocalOsPath() {
        return this.mLocalOsPath;
    }

    public Os getOs() {
        return this.mOs;
    }

    public Arch getArch() {
        return this.mArch;
    }

    public String getOsDescription() {
        String os = this.mOs == null ? "unknown OS" : (this.mOs == Os.ANY ? "any OS" : this.mOs.getUiName());
        String arch = "";
        if (this.mArch != null && this.mArch != Arch.ANY) {
            arch = this.mArch.getUiName();
        }
        return String.format("%1$s%2$s%3$s", os, arch.length() > 0 ? " " : "", arch);
    }

    public String getShortDescription() {
        return String.format("Archive for %1$s", this.getOsDescription());
    }

    public String getLongDescription() {
        return String.format("%1$s\nSize: %2$d MiB\nSHA1: %3$s", this.getShortDescription(), Math.round(this.getSize() / 0x100000L), this.getChecksum());
    }

    public boolean isCompatible() {
        Arch arch2;
        Os os2;
        Os os = this.getOs();
        if (os != Os.ANY && (os2 = Os.getCurrentOs()) != os) {
            return false;
        }
        Arch arch = this.getArch();
        return arch == Arch.ANY || (arch2 = Arch.getCurrentArch()) == arch;
    }

    public void deleteLocal() {
        if (this.isLocal()) {
            this.deleteFileOrFolder(new File(this.getLocalOsPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(String osSdkRoot, boolean forceHttp, SdkManager sdkManager, ITaskMonitor monitor) {
        String name;
        File archiveFile;
        block8: {
            block7: {
                block6: {
                    Package pkg = this.getParentPackage();
                    archiveFile = null;
                    try {
                        name = pkg.getShortDescription();
                        if (!(pkg instanceof ExtraPackage) || ((ExtraPackage)pkg).isPathValid()) break block6;
                        monitor.setResult("Skipping %1$s: %2$s is not a valid install path.", name, ((ExtraPackage)pkg).getPath());
                        boolean bl = false;
                        this.deleteFileOrFolder(archiveFile);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        this.deleteFileOrFolder(archiveFile);
                        throw throwable;
                    }
                }
                if (!this.isLocal()) break block7;
                monitor.setResult("Skipping already installed archive: %1$s for %2$s", name, this.getOsDescription());
                boolean bl = false;
                this.deleteFileOrFolder(archiveFile);
                return bl;
            }
            if (this.isCompatible()) break block8;
            monitor.setResult("Skipping incompatible archive: %1$s for %2$s", name, this.getOsDescription());
            boolean bl = false;
            this.deleteFileOrFolder(archiveFile);
            return bl;
        }
        archiveFile = this.downloadFile(monitor, forceHttp);
        if (archiveFile != null && this.unarchive(osSdkRoot, archiveFile, sdkManager, monitor)) {
            monitor.setResult("Installed: %1$s", name);
            boolean bl = true;
            this.deleteFileOrFolder(archiveFile);
            return bl;
        }
        this.deleteFileOrFolder(archiveFile);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File downloadFile(ITaskMonitor monitor, boolean forceHttp) {
        File tmpFileToDelete = null;
        try {
            File tmpFile;
            tmpFileToDelete = tmpFile = File.createTempFile("sdkupload", ".bin");
            String name = this.getParentPackage().getShortDescription();
            String desc = String.format("Downloading %1$s", name);
            monitor.setDescription(desc, new Object[0]);
            String link = this.getUrl();
            if (!(link.startsWith("http://") || link.startsWith("https://") || link.startsWith("ftp://"))) {
                Package pkg = this.getParentPackage();
                RepoSource src = pkg.getParentSource();
                if (src == null) {
                    monitor.setResult("Internal error: no source for archive %1$s", name);
                    File file = null;
                    this.deleteFileOrFolder(tmpFileToDelete);
                    return file;
                }
                String repoXml = src.getUrl();
                int pos = repoXml.lastIndexOf(47);
                String base = repoXml.substring(0, pos + 1);
                link = base + link;
            }
            if (forceHttp) {
                link = link.replaceAll("https://", "http://");
            }
            if (this.fetchUrl(tmpFile, link, desc, monitor)) {
                tmpFileToDelete = null;
                File file = tmpFile;
                this.deleteFileOrFolder(tmpFileToDelete);
                return file;
            }
            this.deleteFileOrFolder(tmpFileToDelete);
            return null;
        }
        catch (IOException e) {
            try {
                monitor.setResult(e.getMessage(), new Object[0]);
                this.deleteFileOrFolder(tmpFileToDelete);
                return null;
            }
            catch (Throwable throwable) {
                this.deleteFileOrFolder(tmpFileToDelete);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchUrl(File tmpFile, String urlString, String description, ITaskMonitor monitor) {
        description = description + " (%1$d%%, %2$.0f KiB/s, %3$d %4$s left)";
        FileOutputStream os = null;
        InputStream is = null;
        try {
            int n;
            long inc;
            URL url = new URL(urlString);
            is = url.openStream();
            os = new FileOutputStream(tmpFile);
            MessageDigest digester = this.getChecksumType().getMessageDigest();
            byte[] buf = new byte[65536];
            long total = 0L;
            long size = this.getSize();
            long next_inc = inc = size / 100L;
            long startMs = System.currentTimeMillis();
            long nextMs = startMs + 2000L;
            while ((n = is.read(buf)) >= 0) {
                if (n > 0) {
                    os.write(buf, 0, n);
                    digester.update(buf, 0, n);
                }
                long timeMs = System.currentTimeMillis();
                if ((total += (long)n) >= next_inc) {
                    monitor.incProgress(1);
                    next_inc += inc;
                }
                if (timeMs > nextMs) {
                    long delta = timeMs - startMs;
                    if (total > 0L && delta > 0L) {
                        int percent = (int)(100L * total / size);
                        float speed = (float)total / (float)delta * 0.9765625f;
                        int timeLeft = (double)speed > 0.001 ? (int)((float)(size - total) / 1024.0f / speed) : 0;
                        String timeUnit = "seconds";
                        if (timeLeft > 120) {
                            timeUnit = "minutes";
                            timeLeft /= 60;
                        }
                        monitor.setDescription(description, percent, Float.valueOf(speed), timeLeft, timeUnit);
                    }
                    nextMs = timeMs + 1000L;
                }
                if (!monitor.isCancelRequested()) continue;
                monitor.setResult("Download aborted by user at %1$d bytes.", total);
                boolean delta = false;
                return delta;
            }
            if (total != size) {
                monitor.setResult("Download finished with wrong size. Expected %1$d bytes, got %2$d bytes.", size, total);
                boolean timeMs = false;
                return timeMs;
            }
            byte[] digest = digester.digest();
            n = digest.length;
            String hex = "0123456789abcdef";
            char[] hexDigest = new char[n * 2];
            for (int i = 0; i < n; ++i) {
                int b = digest[i] & 0xFF;
                hexDigest[i * 2 + 0] = hex.charAt(b >>> 4);
                hexDigest[i * 2 + 1] = hex.charAt(b & 0xF);
            }
            String actual = new String(hexDigest);
            String expected = this.getChecksum();
            if (!actual.equalsIgnoreCase(expected)) {
                monitor.setResult("Download finished with wrong checksum. Expected %1$s, got %2$s.", expected, actual);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            monitor.setResult("File not found: %1$s", e.getMessage());
            return false;
        }
        catch (Exception e) {
            monitor.setResult(e.getMessage(), new Object[0]);
            return false;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean unarchive(String osSdkRoot, File archiveFile, SdkManager sdkManager, ITaskMonitor monitor) {
        block18: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    pkgName = this.getParentPackage().getShortDescription();
                                    pkgDesc = String.format("Installing %1$s", new Object[]{pkgName});
                                    monitor.setDescription(pkgDesc, new Object[0]);
                                    pkgKind = this.getParentPackage().getClass().getSimpleName();
                                    destFolder = null;
                                    unzipDestFolder = null;
                                    renamedDestFolder = null;
                                    try {
                                        unzipDestFolder = this.findTempFolder(osSdkRoot, pkgKind, "new");
                                        if (unzipDestFolder != null) break block12;
                                        monitor.setResult("Failed to find a temp directory in %1$s.", new Object[]{osSdkRoot});
                                        var11_11 = false;
                                        this.deleteFileOrFolder(renamedDestFolder);
                                        this.deleteFileOrFolder(unzipDestFolder);
                                        return var11_11;
                                    }
                                    catch (Throwable var14_21) {
                                        this.deleteFileOrFolder(renamedDestFolder);
                                        this.deleteFileOrFolder(unzipDestFolder);
                                        throw var14_21;
                                    }
                                }
                                if (unzipDestFolder.mkdirs()) break block13;
                                monitor.setResult("Failed to create directory %1$s", new Object[]{unzipDestFolder.getPath()});
                                var11_12 = false;
                                this.deleteFileOrFolder(renamedDestFolder);
                                this.deleteFileOrFolder(unzipDestFolder);
                                return var11_12;
                            }
                            zipRootFolder = new String[]{null};
                            if (this.unzipFolder(archiveFile, this.getSize(), unzipDestFolder, pkgDesc, zipRootFolder, monitor)) break block14;
                            var12_14 = false;
                            this.deleteFileOrFolder(renamedDestFolder);
                            this.deleteFileOrFolder(unzipDestFolder);
                            return var12_14;
                        }
                        if (this.generateSourceProperties(unzipDestFolder)) break block15;
                        var12_15 = false;
                        this.deleteFileOrFolder(renamedDestFolder);
                        this.deleteFileOrFolder(unzipDestFolder);
                        return var12_15;
                    }
                    destFolder = this.getParentPackage().getInstallFolder(osSdkRoot, zipRootFolder[0], sdkManager);
                    if (destFolder != null) break block16;
                    monitor.setResult("Failed to compute installation directory for %1$s.", new Object[]{pkgName});
                    var12_16 = false;
                    this.deleteFileOrFolder(renamedDestFolder);
                    this.deleteFileOrFolder(unzipDestFolder);
                    return var12_16;
                }
                renameFailedForDir = null;
                if (!destFolder.isDirectory()) ** GOTO lbl68
                renamedDestFolder = this.findTempFolder(osSdkRoot, pkgKind, "old");
                if (renamedDestFolder != null) break block17;
                monitor.setResult("Failed to find a temp directory in %1$s.", new Object[]{osSdkRoot});
                var13_18 = false;
                this.deleteFileOrFolder(renamedDestFolder);
                this.deleteFileOrFolder(unzipDestFolder);
                return var13_18;
            }
            if (!destFolder.renameTo(renamedDestFolder)) {
                monitor.setResult("Failed to rename directory %1$s to %2$s", new Object[]{destFolder.getPath(), renamedDestFolder.getPath()});
                renameFailedForDir = destFolder;
            }
lbl68:
            // 4 sources

            if (renameFailedForDir == null && !unzipDestFolder.renameTo(destFolder)) {
                monitor.setResult("Failed to rename directory %1$s to %2$s", new Object[]{unzipDestFolder.getPath(), destFolder.getPath()});
                renameFailedForDir = unzipDestFolder;
            }
            if (renameFailedForDir == null) break block18;
            if (SdkConstants.CURRENT_PLATFORM == 2) {
                monitor.setResult("-= Warning ! =-\nA folder failed to be renamed or moved. On Windows this typically means that a program is using that folder (for example Windows Explorer.) Please close all running programs that may be locking the directory '%1$s' and try again.", new Object[]{renameFailedForDir.getPath()});
            }
            var13_19 = false;
            this.deleteFileOrFolder(renamedDestFolder);
            this.deleteFileOrFolder(unzipDestFolder);
            return var13_19;
        }
        unzipDestFolder = null;
        var13_20 = true;
        this.deleteFileOrFolder(renamedDestFolder);
        this.deleteFileOrFolder(unzipDestFolder);
        return var13_20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean unzipFolder(File archiveFile, long compressedSize, File unzipDestFolder, String description, String[] outZipRootFolder, ITaskMonitor monitor) {
        description = description + " (%1$d%%)";
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            boolean usingUnixPerm = SdkConstants.CURRENT_PLATFORM == 3 || SdkConstants.CURRENT_PLATFORM == 1;
            long incStep = compressedSize / 100L;
            long incTotal = 0L;
            long incCurr = 0L;
            int lastPercent = 0;
            byte[] buf = new byte[65536];
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                File parentDir;
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String name = entry.getName();
                int pos = (name = name.replace('\\', '/')).indexOf(47);
                if (pos < 0 || pos == name.length() - 1) continue;
                if (outZipRootFolder[0] == null && pos > 0) {
                    outZipRootFolder[0] = name.substring(0, pos);
                }
                name = name.substring(pos + 1);
                File destFile = new File(unzipDestFolder, name);
                if (name.endsWith("/")) {
                    if (destFile.isDirectory() || destFile.mkdirs()) continue;
                    monitor.setResult("Failed to create temp directory %1$s", destFile.getPath());
                    boolean bl = false;
                    return bl;
                }
                if (name.indexOf(47) != -1 && !(parentDir = destFile.getParentFile()).isDirectory() && !parentDir.mkdirs()) {
                    monitor.setResult("Failed to create temp directory %1$s", parentDir.getPath());
                    boolean e = false;
                    return e;
                }
                FileOutputStream fos = null;
                try {
                    int n;
                    fos = new FileOutputStream(destFile);
                    InputStream entryContent = zipFile.getInputStream(entry);
                    while ((n = entryContent.read(buf)) != -1) {
                        if (n <= 0) continue;
                        fos.write(buf, 0, n);
                    }
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
                if (usingUnixPerm) {
                    this.setPermission(destFile, entry.getUnixMode());
                }
                incTotal += entry.getCompressedSize();
                while (incCurr < incTotal) {
                    monitor.incProgress(1);
                    incCurr += incStep;
                }
                int percent = (int)(100L * incTotal / compressedSize);
                if (percent != lastPercent) {
                    monitor.setDescription(description, percent);
                    lastPercent = percent;
                }
                if (!monitor.isCancelRequested()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            monitor.setResult("Unzip failed: %1$s", e.getMessage());
            return false;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private File findTempFolder(String osBasePath, String prefix, String suffix) {
        File baseTempFolder = new File(osBasePath, "temp");
        if (!baseTempFolder.isDirectory() && !baseTempFolder.mkdirs()) {
            return null;
        }
        for (int i = 1; i < 100; ++i) {
            File folder = new File(baseTempFolder, String.format("%1$s.%2$s%3$02d", prefix, suffix, i));
            if (folder.exists()) continue;
            return folder;
        }
        return null;
    }

    private void deleteFileOrFolder(File fileOrFolder) {
        if (fileOrFolder != null) {
            if (fileOrFolder.isDirectory()) {
                for (File item : fileOrFolder.listFiles()) {
                    this.deleteFileOrFolder(item);
                }
            }
            if (!fileOrFolder.delete()) {
                fileOrFolder.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateSourceProperties(File unzipDestFolder) {
        Properties props = new Properties();
        this.saveProperties(props);
        this.mPackage.saveProperties(props);
        FileOutputStream fos = null;
        try {
            File f = new File(unzipDestFolder, "source.properties");
            fos = new FileOutputStream(f);
            props.store(fos, "## Android Tool: Source of this archive.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private void setPermission(File file, int unixMode) throws IOException {
        String permission = String.format("%o", unixMode);
        permission = permission.substring(permission.length() - 3, permission.length());
        Runtime.getRuntime().exec(new String[]{"chmod", permission, file.getAbsolutePath()});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arch {
        ANY("Any"),
        PPC("PowerPC"),
        X86("x86"),
        X86_64("x86_64");

        private final String mUiName;

        private Arch(String uiName) {
            this.mUiName = uiName;
        }

        public String getUiName() {
            return this.mUiName;
        }

        public static Arch getCurrentArch() {
            String arch = System.getProperty("os.arch");
            if (arch.equalsIgnoreCase("x86_64") || arch.equalsIgnoreCase("amd64")) {
                return X86_64;
            }
            if (arch.equalsIgnoreCase("x86") || arch.equalsIgnoreCase("i386") || arch.equalsIgnoreCase("i686")) {
                return X86;
            }
            if (arch.equalsIgnoreCase("ppc") || arch.equalsIgnoreCase("PowerPC")) {
                return PPC;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Os {
        ANY("Any"),
        LINUX("Linux"),
        MACOSX("MacOS X"),
        WINDOWS("Windows");

        private final String mUiName;

        private Os(String uiName) {
            this.mUiName = uiName;
        }

        public String getUiName() {
            return this.mUiName;
        }

        public static Os getCurrentOs() {
            String os = System.getProperty("os.name");
            if (os.startsWith("Mac")) {
                return MACOSX;
            }
            if (os.startsWith("Windows")) {
                return WINDOWS;
            }
            if (os.startsWith("Linux")) {
                return LINUX;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChecksumType {
        SHA1("SHA-1");

        private final String mAlgorithmName;

        private ChecksumType(String algorithmName) {
            this.mAlgorithmName = algorithmName;
        }

        public MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance(this.mAlgorithmName);
        }
    }
}

