/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;

public class InstrumentationResultParser
extends MultiLineReceiver {
    private final ITestRunListener mTestListener;
    private TestResult mCurrentTestResult = null;
    private String mCurrentKey = null;
    private StringBuilder mCurrentValue = null;
    private boolean mTestStartReported = false;
    private long mTestTime = 0L;
    private boolean mIsCancelled = false;
    private static final String LOG_TAG = "InstrumentationResultParser";

    public InstrumentationResultParser(ITestRunListener listener) {
        this.mTestListener = listener;
    }

    public void processNewLines(String[] lines) {
        for (String line : lines) {
            this.parse(line);
            Log.v(LOG_TAG, line);
        }
    }

    private void parse(String line) {
        if (line.startsWith("INSTRUMENTATION_STATUS_CODE: ")) {
            this.submitCurrentKeyValue();
            this.parseStatusCode(line);
        } else if (line.startsWith("INSTRUMENTATION_STATUS: ")) {
            this.submitCurrentKeyValue();
            this.parseKey(line, "INSTRUMENTATION_STATUS: ".length());
        } else if (line.startsWith("INSTRUMENTATION_RESULT: ")) {
            this.submitCurrentKeyValue();
            this.parseKey(line, "INSTRUMENTATION_RESULT: ".length());
        } else if (line.startsWith("INSTRUMENTATION_FAILED: ") || line.startsWith("INSTRUMENTATION_CODE: ")) {
            this.submitCurrentKeyValue();
        } else if (line.startsWith("Time: ")) {
            this.parseTime(line, "Time: ".length());
        } else if (this.mCurrentValue != null) {
            this.mCurrentValue.append("\r\n");
            this.mCurrentValue.append(line);
        } else {
            Log.w(LOG_TAG, "unrecognized line " + line);
        }
    }

    private void submitCurrentKeyValue() {
        if (this.mCurrentKey != null && this.mCurrentValue != null) {
            TestResult testInfo = this.getCurrentTestInfo();
            String statusValue = this.mCurrentValue.toString();
            if (this.mCurrentKey.equals("class")) {
                testInfo.mTestClass = statusValue.trim();
            } else if (this.mCurrentKey.equals("test")) {
                testInfo.mTestName = statusValue.trim();
            } else if (this.mCurrentKey.equals("numtests")) {
                try {
                    testInfo.mNumTests = Integer.parseInt(statusValue);
                }
                catch (NumberFormatException e) {
                    Log.e(LOG_TAG, "Unexpected integer number of tests, received " + statusValue);
                }
            } else if (this.mCurrentKey.equals("Error") || this.mCurrentKey.equals("shortMsg")) {
                this.handleTestRunFailed(statusValue);
            } else if (this.mCurrentKey.equals("stack")) {
                testInfo.mStackTrace = statusValue;
            }
            this.mCurrentKey = null;
            this.mCurrentValue = null;
        }
    }

    private TestResult getCurrentTestInfo() {
        if (this.mCurrentTestResult == null) {
            this.mCurrentTestResult = new TestResult();
        }
        return this.mCurrentTestResult;
    }

    private void clearCurrentTestInfo() {
        this.mCurrentTestResult = null;
    }

    private void parseKey(String line, int keyStartPos) {
        int endKeyPos = line.indexOf(61, keyStartPos);
        if (endKeyPos != -1) {
            this.mCurrentKey = line.substring(keyStartPos, endKeyPos).trim();
            this.parseValue(line, endKeyPos + 1);
        }
    }

    private void parseValue(String line, int valueStartPos) {
        this.mCurrentValue = new StringBuilder();
        this.mCurrentValue.append(line.substring(valueStartPos));
    }

    private void parseStatusCode(String line) {
        String value = line.substring("INSTRUMENTATION_STATUS_CODE: ".length()).trim();
        TestResult testInfo = this.getCurrentTestInfo();
        try {
            testInfo.mCode = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Log.e(LOG_TAG, "Expected integer status code, received: " + value);
        }
        this.reportResult(testInfo);
        this.clearCurrentTestInfo();
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    public void cancel() {
        this.mIsCancelled = true;
    }

    private void reportResult(TestResult testInfo) {
        if (!testInfo.isComplete()) {
            Log.w(LOG_TAG, "invalid instrumentation status bundle " + testInfo.toString());
            return;
        }
        this.reportTestRunStarted(testInfo);
        TestIdentifier testId = new TestIdentifier(testInfo.mTestClass, testInfo.mTestName);
        switch (testInfo.mCode) {
            case 1: {
                this.mTestListener.testStarted(testId);
                break;
            }
            case -2: {
                this.mTestListener.testFailed(ITestRunListener.TestFailure.FAILURE, testId, this.getTrace(testInfo));
                this.mTestListener.testEnded(testId);
                break;
            }
            case -1: {
                this.mTestListener.testFailed(ITestRunListener.TestFailure.ERROR, testId, this.getTrace(testInfo));
                this.mTestListener.testEnded(testId);
                break;
            }
            case 0: {
                this.mTestListener.testEnded(testId);
                break;
            }
            default: {
                Log.e(LOG_TAG, "Unknown status code received: " + testInfo.mCode);
                this.mTestListener.testEnded(testId);
            }
        }
    }

    private void reportTestRunStarted(TestResult testInfo) {
        if (!this.mTestStartReported && testInfo.mNumTests != null) {
            this.mTestListener.testRunStarted(testInfo.mNumTests);
            this.mTestStartReported = true;
        }
    }

    private String getTrace(TestResult testInfo) {
        if (testInfo.mStackTrace != null) {
            return testInfo.mStackTrace;
        }
        Log.e(LOG_TAG, "Could not find stack trace for failed test ");
        return new Throwable("Unknown failure").toString();
    }

    private void parseTime(String line, int startPos) {
        String timeString = line.substring(startPos);
        try {
            float timeSeconds = Float.parseFloat(timeString);
            this.mTestTime = (long)(timeSeconds * 1000.0f);
        }
        catch (NumberFormatException e) {
            Log.e(LOG_TAG, "Unexpected time format " + timeString);
        }
    }

    private void handleTestRunFailed(String errorMsg) {
        this.mTestListener.testRunFailed(errorMsg == null ? "Unknown error" : errorMsg);
    }

    public void done() {
        super.done();
        this.mTestListener.testRunEnded(this.mTestTime);
    }

    private static class TestResult {
        private Integer mCode = null;
        private String mTestName = null;
        private String mTestClass = null;
        private String mStackTrace = null;
        private Integer mNumTests = null;

        private TestResult() {
        }

        boolean isComplete() {
            return this.mCode != null && this.mTestName != null && this.mTestClass != null;
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            if (this.mTestClass != null) {
                output.append(this.mTestClass);
                output.append('#');
            }
            if (this.mTestName != null) {
                output.append(this.mTestName);
            }
            if (output.length() > 0) {
                return output.toString();
            }
            return "unknown result";
        }
    }

    private static class Prefixes {
        private static final String STATUS = "INSTRUMENTATION_STATUS: ";
        private static final String STATUS_CODE = "INSTRUMENTATION_STATUS_CODE: ";
        private static final String STATUS_FAILED = "INSTRUMENTATION_FAILED: ";
        private static final String CODE = "INSTRUMENTATION_CODE: ";
        private static final String RESULT = "INSTRUMENTATION_RESULT: ";
        private static final String TIME_REPORT = "Time: ";

        private Prefixes() {
        }
    }

    private static class StatusCodes {
        private static final int FAILURE = -2;
        private static final int START = 1;
        private static final int ERROR = -1;
        private static final int OK = 0;

        private StatusCodes() {
        }
    }

    private static class StatusKeys {
        private static final String TEST = "test";
        private static final String CLASS = "class";
        private static final String STACK = "stack";
        private static final String NUMTESTS = "numtests";
        private static final String ERROR = "Error";
        private static final String SHORTMSG = "shortMsg";

        private StatusKeys() {
        }
    }
}

